/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "InspectorBackendDispatcher.h"
#include "InspectorProtocolObjects.h"
#include <tuple>
#include <wtf/Expected.h>
#include <wtf/text/MakeString.h>
#include <wtf/text/WTFString.h>

namespace Inspector {



#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
class AlternateAnimationBackendDispatcher;
class AlternateAuditBackendDispatcher;
class AlternateBrowserBackendDispatcher;
#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateCPUProfilerBackendDispatcher;
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateCSSBackendDispatcher;
class AlternateCanvasBackendDispatcher;
class AlternateConsoleBackendDispatcher;
class AlternateDOMBackendDispatcher;
class AlternateDOMDebuggerBackendDispatcher;
class AlternateDOMStorageBackendDispatcher;
class AlternateDebuggerBackendDispatcher;
class AlternateHeapBackendDispatcher;
class AlternateIndexedDBBackendDispatcher;
class AlternateInspectorBackendDispatcher;
class AlternateLayerTreeBackendDispatcher;
#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateMemoryBackendDispatcher;
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateNetworkBackendDispatcher;
class AlternatePageBackendDispatcher;
class AlternateRuntimeBackendDispatcher;
class AlternateScriptProfilerBackendDispatcher;
class AlternateServiceWorkerBackendDispatcher;
class AlternateTargetBackendDispatcher;
class AlternateTimelineBackendDispatcher;
class AlternateWorkerBackendDispatcher;
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

class JS_EXPORT_PRIVATE AnimationBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<RefPtr<Protocol::Animation::Effect> /* opt_effect */> requestEffect(const String& animationId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::DOM::Styleable> /* effectTarget */> requestEffectTarget(const String& animationId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::Runtime::RemoteObject> /* object */> resolveAnimation(const String& animationId, const String& opt_objectGroup) = 0;
    virtual Inspector::CommandResult<void> startTracking() = 0;
    virtual Inspector::CommandResult<void> stopTracking() = 0;
protected:
    virtual ~AnimationBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE AuditBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> setup(std::optional<int>&& opt_contextId) = 0;
    virtual Inspector::CommandResultOf<Ref<Protocol::Runtime::RemoteObject> /* result */, std::optional<bool> /* opt_wasThrown */> run(const String& test, std::optional<int>&& opt_contextId) = 0;
    virtual Inspector::CommandResult<void> teardown() = 0;
protected:
    virtual ~AuditBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE BrowserBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
protected:
    virtual ~BrowserBackendDispatcherHandler();
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE CPUProfilerBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> startTracking() = 0;
    virtual Inspector::CommandResult<void> stopTracking() = 0;
protected:
    virtual ~CPUProfilerBackendDispatcherHandler();
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE CSSBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResultOf<RefPtr<JSON::ArrayOf<Protocol::CSS::RuleMatch>> /* opt_matchedCSSRules */, RefPtr<JSON::ArrayOf<Protocol::CSS::PseudoIdMatches>> /* opt_pseudoElements */, RefPtr<JSON::ArrayOf<Protocol::CSS::InheritedStyleEntry>> /* opt_inherited */> getMatchedStylesForNode(int nodeId, std::optional<bool>&& opt_includePseudo, std::optional<bool>&& opt_includeInherited) = 0;
    virtual Inspector::CommandResultOf<RefPtr<Protocol::CSS::CSSStyle> /* opt_inlineStyle */, RefPtr<Protocol::CSS::CSSStyle> /* opt_attributesStyle */> getInlineStylesForNode(int nodeId) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::CSS::CSSComputedStyleProperty>> /* computedStyle */> getComputedStyleForNode(int nodeId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::CSS::Font> /* primaryFont */> getFontDataForNode(int nodeId) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::CSS::CSSStyleSheetHeader>> /* headers */> getAllStyleSheets() = 0;
    virtual Inspector::CommandResult<Ref<Protocol::CSS::CSSStyleSheetBody> /* styleSheet */> getStyleSheet(const String& styleSheetId) = 0;
    virtual Inspector::CommandResult<String /* text */> getStyleSheetText(const String& styleSheetId) = 0;
    virtual Inspector::CommandResult<void> setStyleSheetText(const String& styleSheetId, const String& text) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::CSS::CSSStyle> /* style */> setStyleText(Ref<JSON::Object>&& styleId, const String& text) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::CSS::CSSRule> /* rule */> setRuleSelector(Ref<JSON::Object>&& ruleId, const String& selector) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::CSS::Grouping> /* grouping */> setGroupingHeaderText(Ref<JSON::Object>&& ruleId, const String& headerText) = 0;
    virtual Inspector::CommandResult<String /* styleSheetId */> createStyleSheet(const String& frameId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::CSS::CSSRule> /* rule */> addRule(const String& styleSheetId, const String& selector) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::CSS::CSSPropertyInfo>> /* cssProperties */> getSupportedCSSProperties() = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<String>> /* fontFamilyNames */> getSupportedSystemFontFamilyNames() = 0;
    virtual Inspector::CommandResult<void> forcePseudoState(int nodeId, Ref<JSON::Array>&& forcedPseudoClasses) = 0;
    virtual Inspector::CommandResult<void> setLayoutContextTypeChangedMode(Protocol::CSS::LayoutContextTypeChangedMode mode) = 0;
protected:
    virtual ~CSSBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE CanvasBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<int /* nodeId */> requestNode(const String& canvasId) = 0;
    virtual Inspector::CommandResult<String /* content */> requestContent(const String& canvasId) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<int>> /* clientNodeIds */> requestClientNodes(const String& canvasId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::Runtime::RemoteObject> /* object */> resolveContext(const String& canvasId, const String& opt_objectGroup) = 0;
    virtual Inspector::CommandResult<void> setRecordingAutoCaptureFrameCount(int count) = 0;
    virtual Inspector::CommandResult<void> startRecording(const String& canvasId, std::optional<int>&& opt_frameCount, std::optional<int>&& opt_memoryLimit) = 0;
    virtual Inspector::CommandResult<void> stopRecording(const String& canvasId) = 0;
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual Inspector::CommandResult<String /* source */> requestShaderSource(const String& programId, Protocol::Canvas::ShaderType shaderType) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual Inspector::CommandResult<void> updateShader(const String& programId, Protocol::Canvas::ShaderType shaderType, const String& source) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual Inspector::CommandResult<void> setShaderProgramDisabled(const String& programId, bool disabled) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual Inspector::CommandResult<void> setShaderProgramHighlighted(const String& programId, bool highlighted) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
protected:
    virtual ~CanvasBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ConsoleBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> clearMessages() = 0;
    virtual Inspector::CommandResult<void> setConsoleClearAPIEnabled(bool enable) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Console::Channel>> /* channels */> getLoggingChannels() = 0;
    virtual Inspector::CommandResult<void> setLoggingChannelLevel(Protocol::Console::ChannelSource source, Protocol::Console::ChannelLevel level) = 0;
protected:
    virtual ~ConsoleBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<Ref<Protocol::DOM::Node> /* root */> getDocument() = 0;
    virtual Inspector::CommandResult<void> requestChildNodes(int nodeId, std::optional<int>&& opt_depth) = 0;
    virtual Inspector::CommandResult<std::optional<int> /* opt_slotElementId */> requestAssignedSlot(int nodeId) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<int>> /* assignedNodeIds */> requestAssignedNodes(int slotElementId) = 0;
    virtual Inspector::CommandResult<std::optional<int> /* opt_nodeId */> querySelector(int nodeId, const String& selector) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<int>> /* nodeIds */> querySelectorAll(int nodeId, const String& selector) = 0;
    virtual Inspector::CommandResult<int /* nodeId */> setNodeName(int nodeId, const String& name) = 0;
    virtual Inspector::CommandResult<void> setNodeValue(int nodeId, const String& value) = 0;
    virtual Inspector::CommandResult<void> removeNode(int nodeId) = 0;
    virtual Inspector::CommandResult<void> setAttributeValue(int nodeId, const String& name, const String& value) = 0;
    virtual Inspector::CommandResult<void> setAttributesAsText(int nodeId, const String& text, const String& opt_name) = 0;
    virtual Inspector::CommandResult<void> removeAttribute(int nodeId, const String& name) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<String>> /* eventNames */> getSupportedEventNames() = 0;
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::DOM::DataBinding>> /* dataBindings */> getDataBindingsForNode(int nodeId) = 0;
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual Inspector::CommandResult<String /* opt_associatedData */> getAssociatedDataForNode(int nodeId) = 0;
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::DOM::EventListener>> /* listeners */> getEventListenersForNode(int nodeId, std::optional<bool>&& opt_includeAncestors) = 0;
    virtual Inspector::CommandResult<void> setEventListenerDisabled(int eventListenerId, bool disabled) = 0;
    virtual Inspector::CommandResult<void> setBreakpointForEventListener(int eventListenerId, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> removeBreakpointForEventListener(int eventListenerId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::DOM::AccessibilityProperties> /* properties */> getAccessibilityPropertiesForNode(int nodeId) = 0;
    virtual Inspector::CommandResult<String /* outerHTML */> getOuterHTML(int nodeId) = 0;
    virtual Inspector::CommandResult<void> setOuterHTML(int nodeId, const String& outerHTML) = 0;
    virtual Inspector::CommandResult<void> insertAdjacentHTML(int nodeId, const String& position, const String& html) = 0;
    virtual Inspector::CommandResultOf<String /* searchId */, int /* resultCount */> performSearch(const String& query, RefPtr<JSON::Array>&& opt_nodeIds, std::optional<bool>&& opt_caseSensitive) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<int>> /* nodeIds */> getSearchResults(const String& searchId, int fromIndex, int toIndex) = 0;
    virtual Inspector::CommandResult<void> discardSearchResults(const String& searchId) = 0;
    virtual Inspector::CommandResult<int /* nodeId */> requestNode(const String& objectId) = 0;
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    virtual Inspector::CommandResult<void> setInspectModeEnabled(bool enabled, RefPtr<JSON::Object>&& opt_highlightConfig, RefPtr<JSON::Object>&& opt_gridOverlayConfig, RefPtr<JSON::Object>&& opt_flexOverlayConfig) = 0;
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Inspector::CommandResult<void> setInspectModeEnabled(bool enabled, RefPtr<JSON::Object>&& opt_highlightConfig, RefPtr<JSON::Object>&& opt_gridOverlayConfig, RefPtr<JSON::Object>&& opt_flexOverlayConfig, std::optional<bool>&& opt_showRulers) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Inspector::CommandResult<void> highlightRect(int x, int y, int width, int height, RefPtr<JSON::Object>&& opt_color, RefPtr<JSON::Object>&& opt_outlineColor, std::optional<bool>&& opt_usePageCoordinates) = 0;
    virtual Inspector::CommandResult<void> highlightQuad(Ref<JSON::Array>&& quad, RefPtr<JSON::Object>&& opt_color, RefPtr<JSON::Object>&& opt_outlineColor, std::optional<bool>&& opt_usePageCoordinates) = 0;
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    virtual Inspector::CommandResult<void> highlightSelector(const String& selectorString, const String& opt_frameId, Ref<JSON::Object>&& highlightConfig, RefPtr<JSON::Object>&& opt_gridOverlayConfig, RefPtr<JSON::Object>&& opt_flexOverlayConfig) = 0;
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Inspector::CommandResult<void> highlightSelector(const String& selectorString, const String& opt_frameId, Ref<JSON::Object>&& highlightConfig, RefPtr<JSON::Object>&& opt_gridOverlayConfig, RefPtr<JSON::Object>&& opt_flexOverlayConfig, std::optional<bool>&& opt_showRulers) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    virtual Inspector::CommandResult<void> highlightNode(std::optional<int>&& opt_nodeId, const String& opt_objectId, Ref<JSON::Object>&& highlightConfig, RefPtr<JSON::Object>&& opt_gridOverlayConfig, RefPtr<JSON::Object>&& opt_flexOverlayConfig) = 0;
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Inspector::CommandResult<void> highlightNode(std::optional<int>&& opt_nodeId, const String& opt_objectId, Ref<JSON::Object>&& highlightConfig, RefPtr<JSON::Object>&& opt_gridOverlayConfig, RefPtr<JSON::Object>&& opt_flexOverlayConfig, std::optional<bool>&& opt_showRulers) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    virtual Inspector::CommandResult<void> highlightNodeList(Ref<JSON::Array>&& nodeIds, Ref<JSON::Object>&& highlightConfig, RefPtr<JSON::Object>&& opt_gridOverlayConfig, RefPtr<JSON::Object>&& opt_flexOverlayConfig) = 0;
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Inspector::CommandResult<void> highlightNodeList(Ref<JSON::Array>&& nodeIds, Ref<JSON::Object>&& highlightConfig, RefPtr<JSON::Object>&& opt_gridOverlayConfig, RefPtr<JSON::Object>&& opt_flexOverlayConfig, std::optional<bool>&& opt_showRulers) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Inspector::CommandResult<void> hideHighlight() = 0;
    virtual Inspector::CommandResult<void> highlightFrame(const String& frameId, RefPtr<JSON::Object>&& opt_contentColor, RefPtr<JSON::Object>&& opt_contentOutlineColor) = 0;
    virtual Inspector::CommandResult<void> showGridOverlay(int nodeId, Ref<JSON::Object>&& gridOverlayConfig) = 0;
    virtual Inspector::CommandResult<void> hideGridOverlay(std::optional<int>&& opt_nodeId) = 0;
    virtual Inspector::CommandResult<void> showFlexOverlay(int nodeId, Ref<JSON::Object>&& flexOverlayConfig) = 0;
    virtual Inspector::CommandResult<void> hideFlexOverlay(std::optional<int>&& opt_nodeId) = 0;
    virtual Inspector::CommandResult<int /* nodeId */> pushNodeByPathToFrontend(const String& path) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::Runtime::RemoteObject> /* object */> resolveNode(int nodeId, const String& opt_objectGroup) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<String>> /* attributes */> getAttributes(int nodeId) = 0;
    virtual Inspector::CommandResult<int /* nodeId */> moveTo(int nodeId, int targetNodeId, std::optional<int>&& opt_insertBeforeNodeId) = 0;
    virtual Inspector::CommandResult<void> undo() = 0;
    virtual Inspector::CommandResult<void> redo() = 0;
    virtual Inspector::CommandResult<void> markUndoableState() = 0;
    virtual Inspector::CommandResult<void> focus(int nodeId) = 0;
    virtual Inspector::CommandResult<void> setInspectedNode(int nodeId) = 0;
    virtual Inspector::CommandResult<void> setAllowEditingUserAgentShadowTrees(bool allow) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::DOM::MediaStats> /* mediaStats */> getMediaStats(int nodeId) = 0;
protected:
    virtual ~DOMBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMDebuggerBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> setDOMBreakpoint(int nodeId, Protocol::DOMDebugger::DOMBreakpointType type, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> removeDOMBreakpoint(int nodeId, Protocol::DOMDebugger::DOMBreakpointType type) = 0;
    virtual Inspector::CommandResult<void> setEventBreakpoint(Protocol::DOMDebugger::EventBreakpointType breakpointType, const String& opt_eventName, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> removeEventBreakpoint(Protocol::DOMDebugger::EventBreakpointType breakpointType, const String& opt_eventName, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Inspector::CommandResult<void> setURLBreakpoint(const String& url, std::optional<bool>&& opt_isRegex, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> removeURLBreakpoint(const String& url, std::optional<bool>&& opt_isRegex) = 0;
protected:
    virtual ~DOMDebuggerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMStorageBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::DOMStorage::Item>> /* entries */> getDOMStorageItems(Ref<JSON::Object>&& storageId) = 0;
    virtual Inspector::CommandResult<void> setDOMStorageItem(Ref<JSON::Object>&& storageId, const String& key, const String& value) = 0;
    virtual Inspector::CommandResult<void> removeDOMStorageItem(Ref<JSON::Object>&& storageId, const String& key) = 0;
    virtual Inspector::CommandResult<void> clearDOMStorageItems(Ref<JSON::Object>&& storageId) = 0;
protected:
    virtual ~DOMStorageBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DebuggerBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> setAsyncStackTraceDepth(int depth) = 0;
    virtual Inspector::CommandResult<void> setBreakpointsActive(bool active) = 0;
    virtual Inspector::CommandResultOf<String /* breakpointId */, Ref<JSON::ArrayOf<Protocol::Debugger::Location>> /* locations */> setBreakpointByUrl(int lineNumber, const String& opt_url, const String& opt_urlRegex, std::optional<int>&& opt_columnNumber, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResultOf<String /* breakpointId */, Ref<Protocol::Debugger::Location> /* actualLocation */> setBreakpoint(Ref<JSON::Object>&& location, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> removeBreakpoint(const String& breakpointId) = 0;
    virtual Inspector::CommandResult<void> addSymbolicBreakpoint(const String& symbol, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> removeSymbolicBreakpoint(const String& symbol, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Inspector::CommandResult<void> continueUntilNextRunLoop() = 0;
    virtual Inspector::CommandResult<void> continueToLocation(Ref<JSON::Object>&& location) = 0;
    virtual Inspector::CommandResult<void> stepNext() = 0;
    virtual Inspector::CommandResult<void> stepOver() = 0;
    virtual Inspector::CommandResult<void> stepInto() = 0;
    virtual Inspector::CommandResult<void> stepOut() = 0;
    virtual Inspector::CommandResult<void> pause() = 0;
    virtual Inspector::CommandResult<void> resume() = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::GenericTypes::SearchMatch>> /* result */> searchInContent(const String& scriptId, const String& query, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Inspector::CommandResult<String /* scriptSource */> getScriptSource(const String& scriptId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::Debugger::FunctionDetails> /* details */> getFunctionDetails(const String& functionId) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Debugger::Location>> /* locations */> getBreakpointLocations(Ref<JSON::Object>&& start, Ref<JSON::Object>&& end) = 0;
    virtual Inspector::CommandResult<void> setPauseOnDebuggerStatements(bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> setPauseOnExceptions(const String& state, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> setPauseOnAssertions(bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> setPauseOnMicrotasks(bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Inspector::CommandResult<void> setPauseForInternalScripts(bool shouldPause) = 0;
    virtual Inspector::CommandResultOf<Ref<Protocol::Runtime::RemoteObject> /* result */, std::optional<bool> /* opt_wasThrown */, std::optional<int> /* opt_savedResultIndex */> evaluateOnCallFrame(const String& callFrameId, const String& expression, const String& opt_objectGroup, std::optional<bool>&& opt_includeCommandLineAPI, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult, std::optional<bool>&& opt_emulateUserGesture) = 0;
    virtual Inspector::CommandResult<void> setShouldBlackboxURL(const String& url, bool shouldBlackbox, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex, RefPtr<JSON::Array>&& opt_sourceRanges) = 0;
    virtual Inspector::CommandResult<void> setBlackboxBreakpointEvaluations(bool blackboxBreakpointEvaluations) = 0;
protected:
    virtual ~DebuggerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE HeapBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> gc() = 0;
    virtual Inspector::CommandResultOf<double /* timestamp */, String /* snapshotData */> snapshot() = 0;
    virtual Inspector::CommandResult<void> startTracking() = 0;
    virtual Inspector::CommandResult<void> stopTracking() = 0;
    virtual Inspector::CommandResultOf<String /* opt_string */, RefPtr<Protocol::Debugger::FunctionDetails> /* opt_functionDetails */, RefPtr<Protocol::Runtime::ObjectPreview> /* opt_preview */> getPreview(int heapObjectId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::Runtime::RemoteObject> /* result */> getRemoteObject(int heapObjectId, const String& opt_objectGroup) = 0;
protected:
    virtual ~HeapBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE IndexedDBBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    class JS_EXPORT_PRIVATE RequestDatabaseNamesCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDatabaseNamesCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<JSON::ArrayOf<String>>&& databaseNames);
    };
    virtual void requestDatabaseNames(const String& securityOrigin, Ref<RequestDatabaseNamesCallback>&&) = 0;
    class JS_EXPORT_PRIVATE RequestDatabaseCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDatabaseCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::IndexedDB::DatabaseWithObjectStores>&& databaseWithObjectStores);
    };
    virtual void requestDatabase(const String& securityOrigin, const String& databaseName, Ref<RequestDatabaseCallback>&&) = 0;
    class JS_EXPORT_PRIVATE RequestDataCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDataCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<JSON::ArrayOf<Protocol::IndexedDB::DataEntry>>&& objectStoreDataEntries, bool hasMore);
    };
    virtual void requestData(const String& securityOrigin, const String& databaseName, const String& objectStoreName, const String& indexName, int skipCount, int pageSize, RefPtr<JSON::Object>&& opt_keyRange, Ref<RequestDataCallback>&&) = 0;
    class JS_EXPORT_PRIVATE ClearObjectStoreCallback : public BackendDispatcher::CallbackBase {
    public:
        ClearObjectStoreCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void clearObjectStore(const String& securityOrigin, const String& databaseName, const String& objectStoreName, Ref<ClearObjectStoreCallback>&&) = 0;
protected:
    virtual ~IndexedDBBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE InspectorBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> initialized() = 0;
protected:
    virtual ~InspectorBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE LayerTreeBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::LayerTree::Layer>> /* layers */> layersForNode(int nodeId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::LayerTree::CompositingReasons> /* compositingReasons */> reasonsForCompositingLayer(const String& layerId) = 0;
protected:
    virtual ~LayerTreeBackendDispatcherHandler();
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE MemoryBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> startTracking() = 0;
    virtual Inspector::CommandResult<void> stopTracking() = 0;
protected:
    virtual ~MemoryBackendDispatcherHandler();
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE NetworkBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> setExtraHTTPHeaders(Ref<JSON::Object>&& headers) = 0;
    virtual Inspector::CommandResultOf<String /* body */, bool /* base64Encoded */> getResponseBody(const String& requestId) = 0;
    virtual Inspector::CommandResult<void> setResourceCachingDisabled(bool disabled) = 0;
    class JS_EXPORT_PRIVATE LoadResourceCallback : public BackendDispatcher::CallbackBase {
    public:
        LoadResourceCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& content, const String& mimeType, int status);
    };
    virtual void loadResource(const String& frameId, const String& url, Ref<LoadResourceCallback>&&) = 0;
    virtual Inspector::CommandResult<String /* serializedCertificate */> getSerializedCertificate(const String& requestId) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::Runtime::RemoteObject> /* object */> resolveWebSocket(const String& requestId, const String& opt_objectGroup) = 0;
    virtual Inspector::CommandResult<void> setInterceptionEnabled(bool enabled) = 0;
    virtual Inspector::CommandResult<void> addInterception(const String& url, Protocol::Network::NetworkStage stage, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Inspector::CommandResult<void> removeInterception(const String& url, Protocol::Network::NetworkStage stage, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Inspector::CommandResult<void> interceptContinue(const String& requestId, Protocol::Network::NetworkStage stage) = 0;
    virtual Inspector::CommandResult<void> interceptWithRequest(const String& requestId, const String& opt_url, const String& opt_method, RefPtr<JSON::Object>&& opt_headers, const String& opt_postData) = 0;
    virtual Inspector::CommandResult<void> interceptWithResponse(const String& requestId, const String& content, bool base64Encoded, const String& opt_mimeType, std::optional<int>&& opt_status, const String& opt_statusText, RefPtr<JSON::Object>&& opt_headers) = 0;
    virtual Inspector::CommandResult<void> interceptRequestWithResponse(const String& requestId, const String& content, bool base64Encoded, const String& mimeType, int status, const String& statusText, Ref<JSON::Object>&& headers) = 0;
    virtual Inspector::CommandResult<void> interceptRequestWithError(const String& requestId, Protocol::Network::ResourceErrorType errorType) = 0;
#if defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    virtual Inspector::CommandResult<void> setEmulatedConditions(std::optional<int>&& opt_bytesPerSecondLimit) = 0;
#endif // defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
protected:
    virtual ~NetworkBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE PageBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> reload(std::optional<bool>&& opt_ignoreCache, std::optional<bool>&& opt_revalidateAllResources) = 0;
    virtual Inspector::CommandResult<void> navigate(const String& url) = 0;
    virtual Inspector::CommandResult<void> overrideUserAgent(const String& opt_value) = 0;
    virtual Inspector::CommandResult<void> overrideSetting(Protocol::Page::Setting setting, std::optional<bool>&& opt_value) = 0;
    virtual Inspector::CommandResult<void> overrideUserPreference(Protocol::Page::UserPreferenceName name, std::optional<Protocol::Page::UserPreferenceValue>&& opt_value) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Page::Cookie>> /* cookies */> getCookies() = 0;
    virtual Inspector::CommandResult<void> setCookie(Ref<JSON::Object>&& cookie, std::optional<bool>&& opt_shouldPartition) = 0;
    virtual Inspector::CommandResult<void> deleteCookie(const String& cookieName, const String& url) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::Page::FrameResourceTree> /* frameTree */> getResourceTree() = 0;
    virtual Inspector::CommandResultOf<String /* content */, bool /* base64Encoded */> getResourceContent(const String& frameId, const String& url) = 0;
    virtual Inspector::CommandResult<void> setBootstrapScript(const String& opt_source) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::GenericTypes::SearchMatch>> /* result */> searchInResource(const String& frameId, const String& url, const String& query, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex, const String& opt_requestId) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Page::SearchResult>> /* result */> searchInResources(const String& text, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Inspector::CommandResult<void> setShowRulers(bool result) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Inspector::CommandResult<void> setShowPaintRects(bool result) = 0;
    virtual Inspector::CommandResult<void> setEmulatedMedia(const String& media) = 0;
    virtual Inspector::CommandResult<String /* dataURL */> snapshotNode(int nodeId) = 0;
    virtual Inspector::CommandResult<String /* dataURL */> snapshotRect(int x, int y, int width, int height, Protocol::Page::CoordinateSystem coordinateSystem) = 0;
#if (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    virtual Inspector::CommandResult<String /* data */> archive() = 0;
#endif // (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
#if !(defined(WTF_PLATFORM_COCOA) && WTF_PLATFORM_COCOA)
    virtual Inspector::CommandResult<void> setScreenSizeOverride(std::optional<int>&& opt_width, std::optional<int>&& opt_height) = 0;
#endif // !(defined(WTF_PLATFORM_COCOA) && WTF_PLATFORM_COCOA)
protected:
    virtual ~PageBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE RuntimeBackendDispatcherHandler {
public:
    virtual Inspector::CommandResultOf<Protocol::Runtime::SyntaxErrorType /* result */, String /* opt_message */, RefPtr<Protocol::Runtime::ErrorRange> /* opt_range */> parse(const String& source) = 0;
    virtual Inspector::CommandResultOf<Ref<Protocol::Runtime::RemoteObject> /* result */, std::optional<bool> /* opt_wasThrown */, std::optional<int> /* opt_savedResultIndex */> evaluate(const String& expression, const String& opt_objectGroup, std::optional<bool>&& opt_includeCommandLineAPI, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<int>&& opt_contextId, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult, std::optional<bool>&& opt_emulateUserGesture) = 0;
    class JS_EXPORT_PRIVATE AwaitPromiseCallback : public BackendDispatcher::CallbackBase {
    public:
        AwaitPromiseCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::Runtime::RemoteObject>&& result, std::optional<bool>&& opt_wasThrown, std::optional<int>&& opt_savedResultIndex);
    };
    virtual void awaitPromise(const String& promiseObjectId, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult, Ref<AwaitPromiseCallback>&&) = 0;
    class JS_EXPORT_PRIVATE CallFunctionOnCallback : public BackendDispatcher::CallbackBase {
    public:
        CallFunctionOnCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::Runtime::RemoteObject>&& result, std::optional<bool>&& opt_wasThrown);
    };
    virtual void callFunctionOn(const String& objectId, const String& functionDeclaration, RefPtr<JSON::Array>&& opt_arguments, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_emulateUserGesture, std::optional<bool>&& opt_awaitPromise, Ref<CallFunctionOnCallback>&&) = 0;
    virtual Inspector::CommandResult<Ref<Protocol::Runtime::ObjectPreview> /* preview */> getPreview(const String& objectId) = 0;
    virtual Inspector::CommandResultOf<Ref<JSON::ArrayOf<Protocol::Runtime::PropertyDescriptor>> /* properties */, RefPtr<JSON::ArrayOf<Protocol::Runtime::InternalPropertyDescriptor>> /* opt_internalProperties */> getProperties(const String& objectId, std::optional<bool>&& opt_ownProperties, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount, std::optional<bool>&& opt_generatePreview) = 0;
    virtual Inspector::CommandResultOf<Ref<JSON::ArrayOf<Protocol::Runtime::PropertyDescriptor>> /* properties */, RefPtr<JSON::ArrayOf<Protocol::Runtime::InternalPropertyDescriptor>> /* opt_internalProperties */> getDisplayableProperties(const String& objectId, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount, std::optional<bool>&& opt_generatePreview) = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Runtime::CollectionEntry>> /* entries */> getCollectionEntries(const String& objectId, const String& opt_objectGroup, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount) = 0;
    virtual Inspector::CommandResult<std::optional<int> /* opt_savedResultIndex */> saveResult(Ref<JSON::Object>&& value, std::optional<int>&& opt_contextId) = 0;
    virtual Inspector::CommandResult<void> setSavedResultAlias(const String& opt_alias) = 0;
    virtual Inspector::CommandResult<void> releaseObject(const String& objectId) = 0;
    virtual Inspector::CommandResult<void> releaseObjectGroup(const String& objectGroup) = 0;
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Runtime::TypeDescription>> /* types */> getRuntimeTypesForVariablesAtOffsets(Ref<JSON::Array>&& locations) = 0;
    virtual Inspector::CommandResult<void> enableTypeProfiler() = 0;
    virtual Inspector::CommandResult<void> disableTypeProfiler() = 0;
    virtual Inspector::CommandResult<void> enableControlFlowProfiler() = 0;
    virtual Inspector::CommandResult<void> disableControlFlowProfiler() = 0;
    virtual Inspector::CommandResult<Ref<JSON::ArrayOf<Protocol::Runtime::BasicBlock>> /* basicBlocks */> getBasicBlocks(const String& sourceID) = 0;
protected:
    virtual ~RuntimeBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ScriptProfilerBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> startTracking(std::optional<bool>&& opt_includeSamples) = 0;
    virtual Inspector::CommandResult<void> stopTracking() = 0;
protected:
    virtual ~ScriptProfilerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ServiceWorkerBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<Ref<Protocol::ServiceWorker::Configuration> /* info */> getInitializationInfo() = 0;
protected:
    virtual ~ServiceWorkerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE TargetBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> setPauseOnStart(bool pauseOnStart) = 0;
    virtual Inspector::CommandResult<void> resume(const String& targetId) = 0;
    virtual Inspector::CommandResult<void> sendMessageToTarget(const String& targetId, const String& message) = 0;
protected:
    virtual ~TargetBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE TimelineBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> start(std::optional<int>&& opt_maxCallStackDepth) = 0;
    virtual Inspector::CommandResult<void> stop() = 0;
    virtual Inspector::CommandResult<void> setAutoCaptureEnabled(bool enabled) = 0;
    virtual Inspector::CommandResult<void> setInstruments(Ref<JSON::Array>&& instruments) = 0;
protected:
    virtual ~TimelineBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE WorkerBackendDispatcherHandler {
public:
    virtual Inspector::CommandResult<void> enable() = 0;
    virtual Inspector::CommandResult<void> disable() = 0;
    virtual Inspector::CommandResult<void> initialized(const String& workerId) = 0;
    virtual Inspector::CommandResult<void> sendMessageToWorker(const String& workerId, const String& message) = 0;
protected:
    virtual ~WorkerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE AnimationBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<AnimationBackendDispatcher> create(BackendDispatcher&, AnimationBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestEffect(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestEffectTarget(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveAnimation(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateAnimationBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateAnimationBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    AnimationBackendDispatcher(BackendDispatcher&, AnimationBackendDispatcherHandler*);
    AnimationBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE AuditBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<AuditBackendDispatcher> create(BackendDispatcher&, AuditBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void setup(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void run(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void teardown(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateAuditBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateAuditBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    AuditBackendDispatcher(BackendDispatcher&, AuditBackendDispatcherHandler*);
    AuditBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE BrowserBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<BrowserBackendDispatcher> create(BackendDispatcher&, BrowserBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateBrowserBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateBrowserBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    BrowserBackendDispatcher(BackendDispatcher&, BrowserBackendDispatcherHandler*);
    BrowserBackendDispatcherHandler* m_agent { nullptr };
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE CPUProfilerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CPUProfilerBackendDispatcher> create(BackendDispatcher&, CPUProfilerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCPUProfilerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCPUProfilerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    CPUProfilerBackendDispatcher(BackendDispatcher&, CPUProfilerBackendDispatcherHandler*);
    CPUProfilerBackendDispatcherHandler* m_agent { nullptr };
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE CSSBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CSSBackendDispatcher> create(BackendDispatcher&, CSSBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getMatchedStylesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getInlineStylesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getComputedStyleForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getFontDataForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAllStyleSheets(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getStyleSheet(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getStyleSheetText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setStyleSheetText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setStyleText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setRuleSelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setGroupingHeaderText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void createStyleSheet(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addRule(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSupportedCSSProperties(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSupportedSystemFontFamilyNames(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void forcePseudoState(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setLayoutContextTypeChangedMode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCSSBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCSSBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    CSSBackendDispatcher(BackendDispatcher&, CSSBackendDispatcherHandler*);
    CSSBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE CanvasBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CanvasBackendDispatcher> create(BackendDispatcher&, CanvasBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestClientNodes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setRecordingAutoCaptureFrameCount(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startRecording(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopRecording(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void requestShaderSource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void updateShader(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void setShaderProgramDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void setShaderProgramHighlighted(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCanvasBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCanvasBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    CanvasBackendDispatcher(BackendDispatcher&, CanvasBackendDispatcherHandler*);
    CanvasBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ConsoleBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ConsoleBackendDispatcher> create(BackendDispatcher&, ConsoleBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void clearMessages(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setConsoleClearAPIEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getLoggingChannels(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setLoggingChannelLevel(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateConsoleBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateConsoleBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    ConsoleBackendDispatcher(BackendDispatcher&, ConsoleBackendDispatcherHandler*);
    ConsoleBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMBackendDispatcher> create(BackendDispatcher&, DOMBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void getDocument(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestChildNodes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestAssignedSlot(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestAssignedNodes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void querySelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void querySelectorAll(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setNodeName(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setNodeValue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAttributeValue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAttributesAsText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeAttribute(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSupportedEventNames(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    void getDataBindingsForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    void getAssociatedDataForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    void getEventListenersForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setEventListenerDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBreakpointForEventListener(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeBreakpointForEventListener(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAccessibilityPropertiesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getOuterHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setOuterHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void insertAdjacentHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void performSearch(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSearchResults(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void discardSearchResults(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    void setInspectModeEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void setInspectModeEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void highlightRect(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void highlightQuad(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    void highlightSelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void highlightSelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    void highlightNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void highlightNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    void highlightNodeList(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void highlightNodeList(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void hideHighlight(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void highlightFrame(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void showGridOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void hideGridOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void showFlexOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void hideFlexOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void pushNodeByPathToFrontend(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAttributes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void moveTo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void undo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void redo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void markUndoableState(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void focus(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setInspectedNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAllowEditingUserAgentShadowTrees(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getMediaStats(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DOMBackendDispatcher(BackendDispatcher&, DOMBackendDispatcherHandler*);
    DOMBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMDebuggerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMDebuggerBackendDispatcher> create(BackendDispatcher&, DOMDebuggerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void setDOMBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeDOMBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setEventBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeEventBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setURLBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeURLBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMDebuggerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMDebuggerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DOMDebuggerBackendDispatcher(BackendDispatcher&, DOMDebuggerBackendDispatcherHandler*);
    DOMDebuggerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMStorageBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMStorageBackendDispatcher> create(BackendDispatcher&, DOMStorageBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getDOMStorageItems(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setDOMStorageItem(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeDOMStorageItem(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void clearDOMStorageItems(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMStorageBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMStorageBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DOMStorageBackendDispatcher(BackendDispatcher&, DOMStorageBackendDispatcherHandler*);
    DOMStorageBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DebuggerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DebuggerBackendDispatcher> create(BackendDispatcher&, DebuggerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAsyncStackTraceDepth(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBreakpointsActive(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBreakpointByUrl(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addSymbolicBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeSymbolicBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void continueUntilNextRunLoop(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void continueToLocation(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stepNext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stepOver(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stepInto(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stepOut(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void pause(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resume(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void searchInContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getScriptSource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getFunctionDetails(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getBreakpointLocations(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseOnDebuggerStatements(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseOnExceptions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseOnAssertions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseOnMicrotasks(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseForInternalScripts(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void evaluateOnCallFrame(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setShouldBlackboxURL(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBlackboxBreakpointEvaluations(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDebuggerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDebuggerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DebuggerBackendDispatcher(BackendDispatcher&, DebuggerBackendDispatcherHandler*);
    DebuggerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE HeapBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<HeapBackendDispatcher> create(BackendDispatcher&, HeapBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void gc(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void snapshot(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getPreview(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getRemoteObject(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateHeapBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateHeapBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    HeapBackendDispatcher(BackendDispatcher&, HeapBackendDispatcherHandler*);
    HeapBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE IndexedDBBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<IndexedDBBackendDispatcher> create(BackendDispatcher&, IndexedDBBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestDatabaseNames(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestDatabase(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestData(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void clearObjectStore(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateIndexedDBBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateIndexedDBBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    IndexedDBBackendDispatcher(BackendDispatcher&, IndexedDBBackendDispatcherHandler*);
    IndexedDBBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE InspectorBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<InspectorBackendDispatcher> create(BackendDispatcher&, InspectorBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void initialized(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateInspectorBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateInspectorBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    InspectorBackendDispatcher(BackendDispatcher&, InspectorBackendDispatcherHandler*);
    InspectorBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE LayerTreeBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<LayerTreeBackendDispatcher> create(BackendDispatcher&, LayerTreeBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void layersForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void reasonsForCompositingLayer(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateLayerTreeBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateLayerTreeBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    LayerTreeBackendDispatcher(BackendDispatcher&, LayerTreeBackendDispatcherHandler*);
    LayerTreeBackendDispatcherHandler* m_agent { nullptr };
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE MemoryBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<MemoryBackendDispatcher> create(BackendDispatcher&, MemoryBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateMemoryBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateMemoryBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    MemoryBackendDispatcher(BackendDispatcher&, MemoryBackendDispatcherHandler*);
    MemoryBackendDispatcherHandler* m_agent { nullptr };
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE NetworkBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<NetworkBackendDispatcher> create(BackendDispatcher&, NetworkBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setExtraHTTPHeaders(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getResponseBody(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setResourceCachingDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void loadResource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSerializedCertificate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveWebSocket(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setInterceptionEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addInterception(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeInterception(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptContinue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptWithRequest(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptWithResponse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptRequestWithResponse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptRequestWithError(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    void setEmulatedConditions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateNetworkBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateNetworkBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    NetworkBackendDispatcher(BackendDispatcher&, NetworkBackendDispatcherHandler*);
    NetworkBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE PageBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<PageBackendDispatcher> create(BackendDispatcher&, PageBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void reload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void navigate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void overrideUserAgent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void overrideSetting(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void overrideUserPreference(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getResourceTree(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getResourceContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBootstrapScript(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void searchInResource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void searchInResources(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void setShowRulers(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void setShowPaintRects(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setEmulatedMedia(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void snapshotNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void snapshotRect(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    void archive(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
#if !(defined(WTF_PLATFORM_COCOA) && WTF_PLATFORM_COCOA)
    void setScreenSizeOverride(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // !(defined(WTF_PLATFORM_COCOA) && WTF_PLATFORM_COCOA)
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternatePageBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternatePageBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    PageBackendDispatcher(BackendDispatcher&, PageBackendDispatcherHandler*);
    PageBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE RuntimeBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<RuntimeBackendDispatcher> create(BackendDispatcher&, RuntimeBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void parse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void evaluate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void awaitPromise(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void callFunctionOn(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getPreview(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getProperties(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getDisplayableProperties(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getCollectionEntries(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void saveResult(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setSavedResultAlias(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void releaseObject(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void releaseObjectGroup(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getRuntimeTypesForVariablesAtOffsets(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void enableTypeProfiler(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disableTypeProfiler(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void enableControlFlowProfiler(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disableControlFlowProfiler(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getBasicBlocks(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateRuntimeBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateRuntimeBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    RuntimeBackendDispatcher(BackendDispatcher&, RuntimeBackendDispatcherHandler*);
    RuntimeBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ScriptProfilerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ScriptProfilerBackendDispatcher> create(BackendDispatcher&, ScriptProfilerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateScriptProfilerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateScriptProfilerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    ScriptProfilerBackendDispatcher(BackendDispatcher&, ScriptProfilerBackendDispatcherHandler*);
    ScriptProfilerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ServiceWorkerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ServiceWorkerBackendDispatcher> create(BackendDispatcher&, ServiceWorkerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void getInitializationInfo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateServiceWorkerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateServiceWorkerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    ServiceWorkerBackendDispatcher(BackendDispatcher&, ServiceWorkerBackendDispatcherHandler*);
    ServiceWorkerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE TargetBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<TargetBackendDispatcher> create(BackendDispatcher&, TargetBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void setPauseOnStart(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resume(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void sendMessageToTarget(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateTargetBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateTargetBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    TargetBackendDispatcher(BackendDispatcher&, TargetBackendDispatcherHandler*);
    TargetBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE TimelineBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<TimelineBackendDispatcher> create(BackendDispatcher&, TimelineBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void start(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stop(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAutoCaptureEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setInstruments(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateTimelineBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateTimelineBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    TimelineBackendDispatcher(BackendDispatcher&, TimelineBackendDispatcherHandler*);
    TimelineBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE WorkerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<WorkerBackendDispatcher> create(BackendDispatcher&, WorkerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void initialized(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void sendMessageToWorker(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateWorkerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateWorkerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    WorkerBackendDispatcher(BackendDispatcher&, WorkerBackendDispatcherHandler*);
    WorkerBackendDispatcherHandler* m_agent { nullptr };
};

} // namespace Inspector
