/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha2

import (
	v1 "sigs.k8s.io/gateway-api/apis/v1"
	apisv1 "sigs.k8s.io/gateway-api/applyconfiguration/apis/v1"
)

// TLSRouteRuleApplyConfiguration represents a declarative configuration of the TLSRouteRule type for use
// with apply.
type TLSRouteRuleApplyConfiguration struct {
	Name        *v1.SectionName                       `json:"name,omitempty"`
	BackendRefs []apisv1.BackendRefApplyConfiguration `json:"backendRefs,omitempty"`
}

// TLSRouteRuleApplyConfiguration constructs a declarative configuration of the TLSRouteRule type for use with
// apply.
func TLSRouteRule() *TLSRouteRuleApplyConfiguration {
	return &TLSRouteRuleApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *TLSRouteRuleApplyConfiguration) WithName(value v1.SectionName) *TLSRouteRuleApplyConfiguration {
	b.Name = &value
	return b
}

// WithBackendRefs adds the given value to the BackendRefs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BackendRefs field.
func (b *TLSRouteRuleApplyConfiguration) WithBackendRefs(values ...*apisv1.BackendRefApplyConfiguration) *TLSRouteRuleApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithBackendRefs")
		}
		b.BackendRefs = append(b.BackendRefs, *values[i])
	}
	return b
}
