//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/comm/mailnews/protocols/ews/src/IEwsClient.idl
//


/// `interface IEwsClient : nsISupports`
///

/// ```text
/// /**
///  * A client for communicating with a Microsoft Exchange server via Exchange Web
///  * Services.
///  *
///  * This interface is intended to provide an abstraction of EWS operations to
///  * bridge the foreign function interface between the components of a Thunderbird
///  * mail protocol implementation and a single implementation of those EWS ops.
///  *
///  * With the exception of initialization, all client operations are intended to
///  * be asynchronous, with implementations of the callback interfaces used to
///  * handle the results of the operations or handle errors.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct IEwsClient {
    vtable: &'static IEwsClientVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for IEwsClient.
unsafe impl XpCom for IEwsClient {
    const IID: nsIID = nsID(0x4a117361, 0x653b, 0x48a5,
        [0x9d, 0xdb, 0x58, 0x84, 0x82, 0xef, 0x9d, 0xbb]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for IEwsClient {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from IEwsClient.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait IEwsClientCoerce {
    /// Cheaply cast a value of this type from a `IEwsClient`.
    fn coerce_from(v: &IEwsClient) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl IEwsClientCoerce for IEwsClient {
    #[inline]
    fn coerce_from(v: &IEwsClient) -> &Self {
        v
    }
}

impl IEwsClient {
    /// Cast this `IEwsClient` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: IEwsClientCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for IEwsClient {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> IEwsClientCoerce for T {
    #[inline]
    fn coerce_from(v: &IEwsClient) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every IEwsClient
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct IEwsClientVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void recordTelemetry (in AUTF8String endpoint); */
    pub RecordTelemetry: unsafe extern "system" fn (this: *const IEwsClient, endpoint: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void initialize (in AUTF8String endpoint, in nsIMsgIncomingServer server); */
    pub Initialize: unsafe extern "system" fn (this: *const IEwsClient, endpoint: *const ::nsstring::nsACString, server: *const nsIMsgIncomingServer) -> ::nserror::nsresult,

    /* nsIURI checkConnectivity (in nsIUrlListener listener); */
    pub CheckConnectivity: unsafe extern "system" fn (this: *const IEwsClient, listener: *const nsIUrlListener, _retval: *mut*const nsIURI) -> ::nserror::nsresult,

    /* void syncFolderHierarchy (in IEwsFolderListener listener, in AUTF8String syncStateToken); */
    pub SyncFolderHierarchy: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsFolderListener, syncStateToken: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void createFolder (in IEwsSimpleOperationListener listener, in AUTF8String parentId, in AUTF8String name); */
    pub CreateFolder: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, parentId: *const ::nsstring::nsACString, name: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void syncMessagesForFolder (in IEwsMessageSyncListener listener, in AUTF8String folderId, in AUTF8String syncStateToken); */
    pub SyncMessagesForFolder: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsMessageSyncListener, folderId: *const ::nsstring::nsACString, syncStateToken: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void getMessage (in IEwsMessageFetchListener listener, in AUTF8String id); */
    pub GetMessage: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsMessageFetchListener, id: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void changeReadStatus (in IEwsSimpleOperationListener listener, in Array<AUTF8String> messageIds, in boolean isRead); */
    pub ChangeReadStatus: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, messageIds: *const thin_vec::ThinVec<::nsstring::nsCString>, isRead: bool) -> ::nserror::nsresult,

    /* void changeReadStatusAll (in IEwsSimpleOperationListener listener, in Array<AUTF8String> folderIds, in boolean isRead, in boolean suppressReadReceipts); */
    pub ChangeReadStatusAll: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>, isRead: bool, suppressReadReceipts: bool) -> ::nserror::nsresult,

    /* void createMessage (in IEwsMessageCreateListener listener, in AUTF8String folderId, in boolean isDraft, in boolean isRead, in nsIInputStream messageStream); */
    pub CreateMessage: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsMessageCreateListener, folderId: *const ::nsstring::nsACString, isDraft: bool, isRead: bool, messageStream: *const nsIInputStream) -> ::nserror::nsresult,

    /* void deleteMessages (in IEwsSimpleOperationListener listener, in Array<AUTF8String> messageEwsIds); */
    pub DeleteMessages: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, messageEwsIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void deleteFolder (in IEwsSimpleOperationListener listener, in Array<AUTF8String> folderIds); */
    pub DeleteFolder: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void emptyFolder (in IEwsSimpleOperationListener listener, in Array<AUTF8String> folderIds, in Array<AUTF8String> subfolderIds, in Array<AUTF8String> messageIds); */
    pub EmptyFolder: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>, subfolderIds: *const thin_vec::ThinVec<::nsstring::nsCString>, messageIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void updateFolder (in IEwsSimpleOperationListener listener, in AUTF8String folderId, in AUTF8String folderName); */
    pub UpdateFolder: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, folderId: *const ::nsstring::nsACString, folderName: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void moveItems (in IEwsSimpleOperationListener listener, in AUTF8String destinationFolderId, in Array<AUTF8String> itemIds); */
    pub MoveItems: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, destinationFolderId: *const ::nsstring::nsACString, itemIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void copyItems (in IEwsSimpleOperationListener listener, in AUTF8String destinationFolderId, in Array<AUTF8String> itemIds); */
    pub CopyItems: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, destinationFolderId: *const ::nsstring::nsACString, itemIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void moveFolders (in IEwsSimpleOperationListener listener, in AUTF8String destinationFolderId, in Array<AUTF8String> folderIds); */
    pub MoveFolders: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, destinationFolderId: *const ::nsstring::nsACString, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void copyFolders (in IEwsSimpleOperationListener listener, in AUTF8String destinationFolderId, in Array<AUTF8String> folderIds); */
    pub CopyFolders: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, destinationFolderId: *const ::nsstring::nsACString, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult,

    /* void markItemsAsJunk (in IEwsSimpleOperationListener listener, in Array<AUTF8String> itemIds, in boolean isJunk, in AUTF8String legacyDestinationFolderId); */
    pub MarkItemsAsJunk: unsafe extern "system" fn (this: *const IEwsClient, listener: *const IEwsSimpleOperationListener, itemIds: *const thin_vec::ThinVec<::nsstring::nsCString>, isJunk: bool, legacyDestinationFolderId: *const ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl IEwsClient {

    /// ```text
    /// /**
    ///    * Record in telemetry (Glean) the version for the Exchange Server with the
    ///    * provided URL, and whether it refers to Office365 or an on-premise server.
    ///    *
    ///    * This method can fail if the provided URL is invalid (e.g. un-parseable
        ///    * URL, URL without a domain...) or if reading the pref in which Exchange
    ///    * Server versions are stored failed. If a failure, happens, no telemetry
    ///    * records are created.
    ///    *
    ///    * If no known version exists for this server, no version is recorded for this
    ///    * server in the telemetry data. However, a record regarding whether the
    ///    * server refers to Office365 or an on-premise server is still created in this
    ///    * case.
    ///    *
    ///    * This method is stateless (thus can be called repeatedly on the same
        ///    * `IEwsClient` instance with different URLs) and does not require
    ///    * `initialize` to be called.
    ///    *
    ///    * @param endpoint - The full URL to the server's EWS endpoint.
    ///    */
    /// ```
    ///

    /// `void recordTelemetry (in AUTF8String endpoint);`
    #[inline]
    pub unsafe fn RecordTelemetry(&self, endpoint: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).RecordTelemetry)(self, endpoint)
    }


    /// ```text
    /// /**
    ///    * Initializes a new client with the necessary host address and authentication
    ///    * details to communicate with an Exchange server.
    ///    *
    ///    * @param endpoint - The HTTP(S) address of an Exchange server's EWS endpoint.
    ///    * @param server - An incoming server entity corresponding to an EWS-capable
    ///    *   account.
    ///    */
    /// ```
    ///

    /// `void initialize (in AUTF8String endpoint, in nsIMsgIncomingServer server);`
    #[inline]
    pub unsafe fn Initialize(&self, endpoint: *const ::nsstring::nsACString, server: *const nsIMsgIncomingServer) -> ::nserror::nsresult {
        ((*self.vtable).Initialize)(self, endpoint, server)
    }


    /// ```text
    /// /**
    ///    * Checks that the current client configuration is able to connect and
    ///    * authenticate against an EWS server.
    ///    *
    ///    * EWS does not have a dedicated endpoint that can be queried for this, so
    ///    * instead we test this by attempting to look up the account's root mail
    ///    * folder, since it results in a fairly small request and represents the first
    ///    * operation performed when adding the account to Thunderbird.
    ///    *
    ///    * @param listener - Listener to communicate the success or failure of the
    ///    *   check.
    ///    * @returns The client's EWS endpoint's URL.
    ///    */
    /// ```
    ///

    /// `nsIURI checkConnectivity (in nsIUrlListener listener);`
    #[inline]
    pub unsafe fn CheckConnectivity(&self, listener: *const nsIUrlListener, _retval: *mut*const nsIURI) -> ::nserror::nsresult {
        ((*self.vtable).CheckConnectivity)(self, listener, _retval)
    }


    /// ```text
    /// /**
    ///    * Synchronizes the local folder listing with changes made on the remote
    ///    * Exchange server.
    ///    *
    ///    * @param listener - Listener for communicating changes to the folder list and
    ///    *   to the recorded synchronization state.
    ///    * @param syncStateToken - A synchronization state token provided by a prior
    ///    *   sync request, or an empty string to indicate that this is the initial
    ///    *   sync.
    ///    */
    /// ```
    ///

    /// `void syncFolderHierarchy (in IEwsFolderListener listener, in AUTF8String syncStateToken);`
    #[inline]
    pub unsafe fn SyncFolderHierarchy(&self, listener: *const IEwsFolderListener, syncStateToken: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SyncFolderHierarchy)(self, listener, syncStateToken)
    }


    /// ```text
    /// /**
    ///    * Creates a new folder on the Exchange server as a child of the specified
    ///    * parent.
    ///    *
    ///    * @param listener - Listener that propagates the success or failure of the
    ///    *   folder creation operation to the consumer.
    ///    * @param parentId - The EWS ID of the folder under which to create the new
    ///    *   folder.
    ///    * @param name - The name to use for the new folder.
    ///    */
    /// ```
    ///

    /// `void createFolder (in IEwsSimpleOperationListener listener, in AUTF8String parentId, in AUTF8String name);`
    #[inline]
    pub unsafe fn CreateFolder(&self, listener: *const IEwsSimpleOperationListener, parentId: *const ::nsstring::nsACString, name: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).CreateFolder)(self, listener, parentId, name)
    }


    /// ```text
    /// /**
    ///    * Synchronizes the local message listing for the given folder with changes
    ///    * made on the remote Exchange server.
    ///    *
    ///    * @param listener - Listener for communicating changes to the message list
    ///    *   and to the recorded synchronization state.
    ///    * @param folderId - The EWS ID of the folder which message list to
    ///    *   synchronize.
    ///    * @param syncStateToken - A synchronization state token provided by a prior
    ///    *   sync request, or an empty string to indicate that this is the initial
    ///    *   sync.
    ///    */
    /// ```
    ///

    /// `void syncMessagesForFolder (in IEwsMessageSyncListener listener, in AUTF8String folderId, in AUTF8String syncStateToken);`
    #[inline]
    pub unsafe fn SyncMessagesForFolder(&self, listener: *const IEwsMessageSyncListener, folderId: *const ::nsstring::nsACString, syncStateToken: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SyncMessagesForFolder)(self, listener, folderId, syncStateToken)
    }


    /// ```text
    /// /**
    ///    * Retrieves the content of a message on the Exchange server.
    ///    *
    ///    * @param listener - Listener to communicate the operation's state and status,
    ///    *   as well as the message's content, to the consumer.
    ///    * @param id - The EWS ID of the message to fetch.
    ///    */
    /// ```
    ///

    /// `void getMessage (in IEwsMessageFetchListener listener, in AUTF8String id);`
    #[inline]
    pub unsafe fn GetMessage(&self, listener: *const IEwsMessageFetchListener, id: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetMessage)(self, listener, id)
    }


    /// ```text
    /// /**
    ///    * Changes the read/unread status of one or more messages on the Exchange
    ///    * server.
    ///    *
    ///    * @param messageIds - The EWS IDs of the messages which read/unread status to
    ///    *   change.
    ///    * @param isRead - The new read/unread state for the message, indicating
    ///    *   whether the message should be marked as read.
    ///    */
    /// ```
    ///

    /// `void changeReadStatus (in IEwsSimpleOperationListener listener, in Array<AUTF8String> messageIds, in boolean isRead);`
    #[inline]
    pub unsafe fn ChangeReadStatus(&self, listener: *const IEwsSimpleOperationListener, messageIds: *const thin_vec::ThinVec<::nsstring::nsCString>, isRead: bool) -> ::nserror::nsresult {
        ((*self.vtable).ChangeReadStatus)(self, listener, messageIds, isRead)
    }


    /// ```text
    /// /**
    ///    * Changes the read/unread status of all messages in the listed folders on the
    ///    * Exchange server, if the server supports it (Exchange 2013 on).
    ///    *
    ///    * If the server is too old, the listener will use the success callback with
    ///    * the use_legacy_fallback flag set, but the items will not be marked read.
    ///    *
    ///    * @param folderIds - The EWS IDs of the folders which read/unread status to
    ///    *   change.
    ///    * @param isRead - The new read/unread state for the messages, indicating
    ///    *   whether the messages should be marked as read.
    ///    * @param suppressReadReceipts - Whether read receipts should be suppressed
    ///    *   for any messages marked read. This is ignored if the server is too old to
    ///    *   support it (pre-2013).
    ///    */
    /// ```
    ///

    /// `void changeReadStatusAll (in IEwsSimpleOperationListener listener, in Array<AUTF8String> folderIds, in boolean isRead, in boolean suppressReadReceipts);`
    #[inline]
    pub unsafe fn ChangeReadStatusAll(&self, listener: *const IEwsSimpleOperationListener, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>, isRead: bool, suppressReadReceipts: bool) -> ::nserror::nsresult {
        ((*self.vtable).ChangeReadStatusAll)(self, listener, folderIds, isRead, suppressReadReceipts)
    }


    /// ```text
    /// /**
    ///    * Creates a new message on the server using the data read from the stream.
    ///    *
    ///    * @param listener - Listener to indicate operation state and status.
    ///    * @param folderId - The EWS ID of the folder.
    ///    * @param isDraft - Whether the message being created is an unsent draft.
    ///    * @param isRead - Whether the message has already been read.
    ///    * @param messageStream - The input stream to read the message from.
    ///    */
    /// ```
    ///

    /// `void createMessage (in IEwsMessageCreateListener listener, in AUTF8String folderId, in boolean isDraft, in boolean isRead, in nsIInputStream messageStream);`
    #[inline]
    pub unsafe fn CreateMessage(&self, listener: *const IEwsMessageCreateListener, folderId: *const ::nsstring::nsACString, isDraft: bool, isRead: bool, messageStream: *const nsIInputStream) -> ::nserror::nsresult {
        ((*self.vtable).CreateMessage)(self, listener, folderId, isDraft, isRead, messageStream)
    }


    /// ```text
    /// /**
    ///    * Deletes the messages with the given EWS IDs from the server.
    ///    *
    ///    * @param listener - Listener to indicate the success or failure of the
    ///    *   message deletion operation.
    ///    * @param messageEwsIds - The EWS IDs of the messages to delete.
    ///    */
    /// ```
    ///

    /// `void deleteMessages (in IEwsSimpleOperationListener listener, in Array<AUTF8String> messageEwsIds);`
    #[inline]
    pub unsafe fn DeleteMessages(&self, listener: *const IEwsSimpleOperationListener, messageEwsIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).DeleteMessages)(self, listener, messageEwsIds)
    }


    /// ```text
    /// /**
    ///    * Deletes the folders with the given EWS IDs from the server.
    ///    *
    ///    * @param listener - Listener to indicate the success or failure of the
    ///    *   folder deletion operation.
    ///    * @param folderIds - The EWS IDs of the folders to delete.
    ///    */
    /// ```
    ///

    /// `void deleteFolder (in IEwsSimpleOperationListener listener, in Array<AUTF8String> folderIds);`
    #[inline]
    pub unsafe fn DeleteFolder(&self, listener: *const IEwsSimpleOperationListener, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).DeleteFolder)(self, listener, folderIds)
    }


    /// ```text
    /// /**
    ///    * Empties the folders with the given EWS IDs from the server (deletes all
        ///    * messages and subfolders).
    ///    *
    ///    * @param listener - Listener to indicate the success or failure of the empty
    ///    *   folder operation. The `ids` argument of `onOperationSuccess` is currently
    ///    *   unset, the `useLegacyFallback` argument is true iff EmptyFolder was
    ///    *   unsupported and the workaround was used (which hopefully shouldn't
        ///    *   matter).
    ///    * @param folderIds - The EWS IDs of the folders to empty. Only used if the
    ///    *   EmptyFolder operation is supported.
    ///    * @param subfolderIds - The EWS IDs of the child folders of the given
    ///    *   folderIds. Only used if EmptyFolder operation is not supported.
    ///    * @param messageIds - The EWS IDs of the messages in the folders listed in
    ///    *   folderIds. Only used if EmptyFolder operation is not supported.
    ///    */
    /// ```
    ///

    /// `void emptyFolder (in IEwsSimpleOperationListener listener, in Array<AUTF8String> folderIds, in Array<AUTF8String> subfolderIds, in Array<AUTF8String> messageIds);`
    #[inline]
    pub unsafe fn EmptyFolder(&self, listener: *const IEwsSimpleOperationListener, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>, subfolderIds: *const thin_vec::ThinVec<::nsstring::nsCString>, messageIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).EmptyFolder)(self, listener, folderIds, subfolderIds, messageIds)
    }


    /// ```text
    /// /**
    ///    * Renames a folder on the Exchange server.
    ///    *
    ///    * @param listener - Listener to indicate the success or failure of the
    ///    *   folder update operation to rename the folder.
    ///    * @param folderId - The EWS ID of the folder to rename.
    ///    */
    /// ```
    ///

    /// `void updateFolder (in IEwsSimpleOperationListener listener, in AUTF8String folderId, in AUTF8String folderName);`
    #[inline]
    pub unsafe fn UpdateFolder(&self, listener: *const IEwsSimpleOperationListener, folderId: *const ::nsstring::nsACString, folderName: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).UpdateFolder)(self, listener, folderId, folderName)
    }


    /// ```text
    /// /**
    ///    * Moves items on the Exchange server.
    ///    *
    ///    * @param listener - Listener to indicate the success or failure of the move
    ///    * operation.
    ///    * @param destinationFolderId - The EWS ID of the destination folder.
    ///    * @param itemIds - A list of the EWS IDs of the items to be moved.
    ///    */
    /// ```
    ///

    /// `void moveItems (in IEwsSimpleOperationListener listener, in AUTF8String destinationFolderId, in Array<AUTF8String> itemIds);`
    #[inline]
    pub unsafe fn MoveItems(&self, listener: *const IEwsSimpleOperationListener, destinationFolderId: *const ::nsstring::nsACString, itemIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).MoveItems)(self, listener, destinationFolderId, itemIds)
    }


    /// ```text
    /// /**
    ///    * Copies items on the Exchange server.
    ///    *
    ///    * @param listener - Listener to indicate the success or failure of the copy
    ///    * operation.
    ///    * @param destinationFolderId - The EWS ID of the destination folder.
    ///    * @param itemIds - A list of the EWS IDs of the items to be copied.
    ///    */
    /// ```
    ///

    /// `void copyItems (in IEwsSimpleOperationListener listener, in AUTF8String destinationFolderId, in Array<AUTF8String> itemIds);`
    #[inline]
    pub unsafe fn CopyItems(&self, listener: *const IEwsSimpleOperationListener, destinationFolderId: *const ::nsstring::nsACString, itemIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).CopyItems)(self, listener, destinationFolderId, itemIds)
    }


    /// ```text
    /// /**
    ///    * Moves folders on the Exchange server.
    ///    *
    ///    * @param listener - Listener to indicate the success or failure of the move
    ///    * operation.
    ///    * @param destinationFolderId - The EWS ID of the destination folder.
    ///    * @param itemIds - A list of the EWS IDs of the folders to be moved.
    ///    */
    /// ```
    ///

    /// `void moveFolders (in IEwsSimpleOperationListener listener, in AUTF8String destinationFolderId, in Array<AUTF8String> folderIds);`
    #[inline]
    pub unsafe fn MoveFolders(&self, listener: *const IEwsSimpleOperationListener, destinationFolderId: *const ::nsstring::nsACString, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).MoveFolders)(self, listener, destinationFolderId, folderIds)
    }


    /// ```text
    /// /**
    ///    * Copies folders on the Exchange server.
    ///    *
    ///    * @param listener - Listener to indicate the success or failure of the copy
    ///    *   operation.
    ///    * @param destinationFolderId - The EWS ID of the destination folder.
    ///    * @param itemIds - A list of the EWS IDs of the folders to be copied.
    ///    */
    /// ```
    ///

    /// `void copyFolders (in IEwsSimpleOperationListener listener, in AUTF8String destinationFolderId, in Array<AUTF8String> folderIds);`
    #[inline]
    pub unsafe fn CopyFolders(&self, listener: *const IEwsSimpleOperationListener, destinationFolderId: *const ::nsstring::nsACString, folderIds: *const thin_vec::ThinVec<::nsstring::nsCString>) -> ::nserror::nsresult {
        ((*self.vtable).CopyFolders)(self, listener, destinationFolderId, folderIds)
    }


    /// ```text
    /// /**
    ///    * Mark an item as Junk or not junk.
    ///    *
    ///    * @param listener - Callbacks to indicate the success or failure of the operation.
    ///    * @param itemIds - The EWS IDs for the items to mark as junk or not junk.
    ///    * @param isJunk - Whether to mark as junk or not junk.
    ///    * @param legacyDestinationFolderId - The EWS ID as the folder to use as the junk folder for
    ///    *        older versions of Exchange that do not support the `MarkAsJunk` operation.
    ///    */
    /// ```
    ///

    /// `void markItemsAsJunk (in IEwsSimpleOperationListener listener, in Array<AUTF8String> itemIds, in boolean isJunk, in AUTF8String legacyDestinationFolderId);`
    #[inline]
    pub unsafe fn MarkItemsAsJunk(&self, listener: *const IEwsSimpleOperationListener, itemIds: *const thin_vec::ThinVec<::nsstring::nsCString>, isJunk: bool, legacyDestinationFolderId: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).MarkItemsAsJunk)(self, listener, itemIds, isJunk, legacyDestinationFolderId)
    }


}


/// `interface IEwsFolderListener : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct IEwsFolderListener {
    vtable: &'static IEwsFolderListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for IEwsFolderListener.
unsafe impl XpCom for IEwsFolderListener {
    const IID: nsIID = nsID(0x5dacc994, 0x30e0, 0x42f7,
        [0x94, 0xc8, 0x52, 0x75, 0x66, 0x38, 0xad, 0xd5]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for IEwsFolderListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from IEwsFolderListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait IEwsFolderListenerCoerce {
    /// Cheaply cast a value of this type from a `IEwsFolderListener`.
    fn coerce_from(v: &IEwsFolderListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl IEwsFolderListenerCoerce for IEwsFolderListener {
    #[inline]
    fn coerce_from(v: &IEwsFolderListener) -> &Self {
        v
    }
}

impl IEwsFolderListener {
    /// Cast this `IEwsFolderListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: IEwsFolderListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for IEwsFolderListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> IEwsFolderListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &IEwsFolderListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every IEwsFolderListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct IEwsFolderListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onNewRootFolder (in AUTF8String id); */
    pub OnNewRootFolder: unsafe extern "system" fn (this: *const IEwsFolderListener, id: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void onFolderCreated (in AUTF8String id, in AUTF8String parentId, in AUTF8String name, in unsigned long flags); */
    pub OnFolderCreated: unsafe extern "system" fn (this: *const IEwsFolderListener, id: *const ::nsstring::nsACString, parentId: *const ::nsstring::nsACString, name: *const ::nsstring::nsACString, flags: u32) -> ::nserror::nsresult,

    /* void onFolderUpdated (in AUTF8String id, in AUTF8String parentId, in AUTF8String name); */
    pub OnFolderUpdated: unsafe extern "system" fn (this: *const IEwsFolderListener, id: *const ::nsstring::nsACString, parentId: *const ::nsstring::nsACString, name: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void onFolderDeleted (in AUTF8String id); */
    pub OnFolderDeleted: unsafe extern "system" fn (this: *const IEwsFolderListener, id: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void onSyncStateTokenChanged (in AUTF8String syncStateToken); */
    pub OnSyncStateTokenChanged: unsafe extern "system" fn (this: *const IEwsFolderListener, syncStateToken: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void onSuccess (); */
    pub OnSuccess: unsafe extern "system" fn (this: *const IEwsFolderListener) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl IEwsFolderListener {

    /// ```text
    /// /**
    ///    * Called on the first sync when we have requested and received the EWS ID for
    ///    * the account's root folder.
    ///    *
    ///    * The EWS client is responsible for ensuring this is only called in the first
    ///    * sync.
    ///    *
    ///    * @param id - The root folder's EWS ID.
    ///    */
    /// ```
    ///

    /// `void onNewRootFolder (in AUTF8String id);`
    #[inline]
    pub unsafe fn OnNewRootFolder(&self, id: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).OnNewRootFolder)(self, id)
    }


    /// ```text
    /// /**
    ///    * Called if a folder has been created on the server.
    ///    *
    ///    * This may be called multiple times in a single sync if multiple folders
    ///    * have been created since the last sync.
    ///    *
    ///    * @param id - The new folder's EWS ID.
    ///    * @param parentId - The EWS ID for the new folder's parent folder.
    ///    * @param name - The new folder's name.
    ///    * @param flags - The `nsMsgFolderFlags` for the new folder.
    ///    */
    /// ```
    ///

    /// `void onFolderCreated (in AUTF8String id, in AUTF8String parentId, in AUTF8String name, in unsigned long flags);`
    #[inline]
    pub unsafe fn OnFolderCreated(&self, id: *const ::nsstring::nsACString, parentId: *const ::nsstring::nsACString, name: *const ::nsstring::nsACString, flags: u32) -> ::nserror::nsresult {
        ((*self.vtable).OnFolderCreated)(self, id, parentId, name, flags)
    }


    /// ```text
    /// /**
    ///    * Called if an existing folder has been updated on the server.
    ///    *
    ///    * An update can mean the folder has been either renamed or moved to a new
    ///    * parent.
    ///    *
    ///    * This may be called multiple times in a single sync if multiple folders
    ///    * have been created since the last sync.
    ///    *
    ///    * @param id - The folder's EWS ID.
    ///    * @param parentId - The EWS ID for the folder's parent folder.
    ///    * @param name - The folder's name.
    ///    */
    /// ```
    ///

    /// `void onFolderUpdated (in AUTF8String id, in AUTF8String parentId, in AUTF8String name);`
    #[inline]
    pub unsafe fn OnFolderUpdated(&self, id: *const ::nsstring::nsACString, parentId: *const ::nsstring::nsACString, name: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).OnFolderUpdated)(self, id, parentId, name)
    }


    /// ```text
    /// /**
    ///    * Called if an existing folder has been deleted on the server.
    ///    *
    ///    * This may be called multiple times in a single sync if multiple folders
    ///    * have been created since the last sync.
    ///    *
    ///    * @param id - The folder's EWS ID.
    ///    */
    /// ```
    ///

    /// `void onFolderDeleted (in AUTF8String id);`
    #[inline]
    pub unsafe fn OnFolderDeleted(&self, id: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).OnFolderDeleted)(self, id)
    }


    /// ```text
    /// /**
    ///    * Called after a sync has completed.
    ///    *
    ///    * In this context, a sync having completed does not necessarily mean the
    ///    * client has stopped syncing, because the server might have told it there is
    ///    * more data to sync than what could be included in one sync. In this case,
    ///    * the client will sync again (and call this method again).
    ///    *
    ///    * @param syncStateToken - The new sync state token to use in future syncs.
    ///    */
    /// ```
    ///

    /// `void onSyncStateTokenChanged (in AUTF8String syncStateToken);`
    #[inline]
    pub unsafe fn OnSyncStateTokenChanged(&self, syncStateToken: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).OnSyncStateTokenChanged)(self, syncStateToken)
    }


    /// ```text
    /// /**
    ///    * Called after processing everything there was to sync from the server.
    ///    *
    ///    * Unlike `onSyncStateTokenChanged`, this will only be called after all the
    ///    * necessary sync operations have completed (rather than at the end of each
        ///    * one).
    ///    */
    /// ```
    ///

    /// `void onSuccess ();`
    #[inline]
    pub unsafe fn OnSuccess(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).OnSuccess)(self, )
    }


}


/// `interface IEwsMessageSyncListener : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct IEwsMessageSyncListener {
    vtable: &'static IEwsMessageSyncListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for IEwsMessageSyncListener.
unsafe impl XpCom for IEwsMessageSyncListener {
    const IID: nsIID = nsID(0xdec2ddd5, 0xb5a2, 0x4724,
        [0xbf, 0xc7, 0xe5, 0xde, 0x31, 0x84, 0x0f, 0x76]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for IEwsMessageSyncListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from IEwsMessageSyncListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait IEwsMessageSyncListenerCoerce {
    /// Cheaply cast a value of this type from a `IEwsMessageSyncListener`.
    fn coerce_from(v: &IEwsMessageSyncListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl IEwsMessageSyncListenerCoerce for IEwsMessageSyncListener {
    #[inline]
    fn coerce_from(v: &IEwsMessageSyncListener) -> &Self {
        v
    }
}

impl IEwsMessageSyncListener {
    /// Cast this `IEwsMessageSyncListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: IEwsMessageSyncListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for IEwsMessageSyncListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> IEwsMessageSyncListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &IEwsMessageSyncListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every IEwsMessageSyncListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct IEwsMessageSyncListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* nsIMsgDBHdr onMessageCreated (in AUTF8String ewsId); */
    pub OnMessageCreated: unsafe extern "system" fn (this: *const IEwsMessageSyncListener, ewsId: *const ::nsstring::nsACString, _retval: *mut*const nsIMsgDBHdr) -> ::nserror::nsresult,

    /* nsIMsgDBHdr onMessageUpdated (in AUTF8String ewsId); */
    pub OnMessageUpdated: unsafe extern "system" fn (this: *const IEwsMessageSyncListener, ewsId: *const ::nsstring::nsACString, _retval: *mut*const nsIMsgDBHdr) -> ::nserror::nsresult,

    /* void onReadStatusChanged (in AUTF8String ewsId, in boolean isRead); */
    pub OnReadStatusChanged: unsafe extern "system" fn (this: *const IEwsMessageSyncListener, ewsId: *const ::nsstring::nsACString, isRead: bool) -> ::nserror::nsresult,

    /* void onMessageDeleted (in AUTF8String ewsId); */
    pub OnMessageDeleted: unsafe extern "system" fn (this: *const IEwsMessageSyncListener, ewsId: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void onDetachedHdrPopulated (in nsIMsgDBHdr hdr); */
    pub OnDetachedHdrPopulated: unsafe extern "system" fn (this: *const IEwsMessageSyncListener, hdr: *const nsIMsgDBHdr) -> ::nserror::nsresult,

    /* void onExistingHdrChanged (); */
    pub OnExistingHdrChanged: unsafe extern "system" fn (this: *const IEwsMessageSyncListener) -> ::nserror::nsresult,

    /* void onSyncStateTokenChanged (in AUTF8String syncStateToken); */
    pub OnSyncStateTokenChanged: unsafe extern "system" fn (this: *const IEwsMessageSyncListener, syncStateToken: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void onSyncComplete (); */
    pub OnSyncComplete: unsafe extern "system" fn (this: *const IEwsMessageSyncListener) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl IEwsMessageSyncListener {

    /// ```text
    /// /**
    ///  * Callbacks used when interacting with an EWS server via an `IEwsClient` in the
    ///  * context of synchronizing changes to the message list.
    ///  *
    ///  * These callbacks allow the `IEwsClient` instance to perform local operation on
    ///  * the folder that is being synchronized.
    ///  */
    /// /**
    ///    * Called when a new message has been created on the server.
    ///    *
    ///    * Implementations are expected to check if a database entry already exists
    ///    * for the given EWS ID, and return `NS_ERROR_ILLEGAL_VALUE` if so.
    ///    *
    ///    * @param ewsId - The EWS ID for the new message.
    ///    * @returns A detached database entry for the new message.
    ///    */
    /// ```
    ///

    /// `nsIMsgDBHdr onMessageCreated (in AUTF8String ewsId);`
    #[inline]
    pub unsafe fn OnMessageCreated(&self, ewsId: *const ::nsstring::nsACString, _retval: *mut*const nsIMsgDBHdr) -> ::nserror::nsresult {
        ((*self.vtable).OnMessageCreated)(self, ewsId, _retval)
    }


    /// ```text
    /// /**
    ///    * Called when an existing message has been updated on the server.
    ///    *
    ///    * Implementations are expected to return `NS_ERROR_NOT_AVAILABLE` if no
    ///    * database entry exists for the given EWS ID.
    ///    *
    ///    * @param ewsId - The EWS ID for the updated message.
    ///    * @returns An existing (non-detached) database entry for the message.
    ///    */
    /// ```
    ///

    /// `nsIMsgDBHdr onMessageUpdated (in AUTF8String ewsId);`
    #[inline]
    pub unsafe fn OnMessageUpdated(&self, ewsId: *const ::nsstring::nsACString, _retval: *mut*const nsIMsgDBHdr) -> ::nserror::nsresult {
        ((*self.vtable).OnMessageUpdated)(self, ewsId, _retval)
    }


    /// ```text
    /// /**
    ///    * Called when the read/unread flag was changed for a specific message.
    ///    *
    ///    * When a message is marked as read/unread on the EWS server, the EWS server
    ///    * will represent this either as an `Update` element or `ReadFlagChange`
    ///    * element (presumably for older versions of Exchange Server) when syncing the
    ///    * message list.
    ///    *
    ///    * If the server represents changes to read/unread flags as `ReadFlagChange`,
    ///    * then this method will be called, otherwise only `onMessageUpdated` will be
    ///    * called.
    ///    *
    ///    * @param ewsId - The EWS ID for the updated message.
    ///    * @param IsRead - The new read/unread status for the message.
    ///    */
    /// ```
    ///

    /// `void onReadStatusChanged (in AUTF8String ewsId, in boolean isRead);`
    #[inline]
    pub unsafe fn OnReadStatusChanged(&self, ewsId: *const ::nsstring::nsACString, isRead: bool) -> ::nserror::nsresult {
        ((*self.vtable).OnReadStatusChanged)(self, ewsId, isRead)
    }


    /// ```text
    /// /**
    ///    * Called when an existing message has been deleted on the server.
    ///    *
    ///    * @param ewsId - The EWS ID for the deleted message.
    ///    */
    /// ```
    ///

    /// `void onMessageDeleted (in AUTF8String ewsId);`
    #[inline]
    pub unsafe fn OnMessageDeleted(&self, ewsId: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).OnMessageDeleted)(self, ewsId)
    }


    /// ```text
    /// /**
    ///    * Called when a detached database entry has been populated for a new message
    ///    * and is ready to be persisted.
    ///    *
    ///    * @param hdr - The database entry that was populated.
    ///    */
    /// ```
    ///

    /// `void onDetachedHdrPopulated (in nsIMsgDBHdr hdr);`
    #[inline]
    pub unsafe fn OnDetachedHdrPopulated(&self, hdr: *const nsIMsgDBHdr) -> ::nserror::nsresult {
        ((*self.vtable).OnDetachedHdrPopulated)(self, hdr)
    }


    /// ```text
    /// /**
    ///    * Called when an existing (non-detached) database entry has been changed, and
    ///    * the changes are ready to be persisted (i.e. committed).
    ///    *
    ///    * Since the database entry is already attached to the relevant message
    ///    * database, no argument is necessary here.
    ///    */
    /// ```
    ///

    /// `void onExistingHdrChanged ();`
    #[inline]
    pub unsafe fn OnExistingHdrChanged(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).OnExistingHdrChanged)(self, )
    }


    /// ```text
    /// /**
    ///    * Called after a sync has completed.
    ///    *
    ///    * In this context, a sync having completed does not necessarily mean the
    ///    * client has stopped syncing, because the server might have told it there is
    ///    * more data to sync than what could be included in one sync. In this case,
    ///    * the client will sync again (and call this method again).
    ///    *
    ///    * @param syncStateToken - The new sync state token to use in future syncs.
    ///    */
    /// ```
    ///

    /// `void onSyncStateTokenChanged (in AUTF8String syncStateToken);`
    #[inline]
    pub unsafe fn OnSyncStateTokenChanged(&self, syncStateToken: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).OnSyncStateTokenChanged)(self, syncStateToken)
    }


    /// ```text
    /// /**
    ///    * Called after processing everything there was to sync from the server.
    ///    *
    ///    * Unlike `onSyncStateTokenChanged`, this will only be called after all the
    ///    * necessary sync operations have completed (rather than at the end of each
        ///    * one).
    ///    */
    /// ```
    ///

    /// `void onSyncComplete ();`
    #[inline]
    pub unsafe fn OnSyncComplete(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).OnSyncComplete)(self, )
    }


}


/// `interface IEwsMessageCreateListener : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct IEwsMessageCreateListener {
    vtable: &'static IEwsMessageCreateListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for IEwsMessageCreateListener.
unsafe impl XpCom for IEwsMessageCreateListener {
    const IID: nsIID = nsID(0xff45569f, 0xd618, 0x4bb0,
        [0x96, 0x86, 0x6c, 0xb2, 0x4b, 0x92, 0xb0, 0x2b]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for IEwsMessageCreateListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from IEwsMessageCreateListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait IEwsMessageCreateListenerCoerce {
    /// Cheaply cast a value of this type from a `IEwsMessageCreateListener`.
    fn coerce_from(v: &IEwsMessageCreateListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl IEwsMessageCreateListenerCoerce for IEwsMessageCreateListener {
    #[inline]
    fn coerce_from(v: &IEwsMessageCreateListener) -> &Self {
        v
    }
}

impl IEwsMessageCreateListener {
    /// Cast this `IEwsMessageCreateListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: IEwsMessageCreateListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for IEwsMessageCreateListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> IEwsMessageCreateListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &IEwsMessageCreateListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every IEwsMessageCreateListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct IEwsMessageCreateListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onStopCreate (in nsresult status); */
    pub OnStopCreate: unsafe extern "system" fn (this: *const IEwsMessageCreateListener, status: nserror::nsresult) -> ::nserror::nsresult,

    /* void onNewMessageKey (in nsMsgKey msgKey); */
    pub OnNewMessageKey: unsafe extern "system" fn (this: *const IEwsMessageCreateListener, msgKey: nsMsgKey) -> ::nserror::nsresult,

    /* nsIMsgDBHdr onRemoteCreateSuccessful (in AUTF8String ewsId); */
    pub OnRemoteCreateSuccessful: unsafe extern "system" fn (this: *const IEwsMessageCreateListener, ewsId: *const ::nsstring::nsACString, _retval: *mut*const nsIMsgDBHdr) -> ::nserror::nsresult,

    /* void onHdrPopulated (in nsIMsgDBHdr hdr); */
    pub OnHdrPopulated: unsafe extern "system" fn (this: *const IEwsMessageCreateListener, hdr: *const nsIMsgDBHdr) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl IEwsMessageCreateListener {

    /// ```text
    /// /**
    ///  * A set of callbacks called during the creation of a new message on an Exchange
    ///  * server.
    ///  */
    /// /**
    ///    * Inform consumers that the message creation has finished, both on the server
    ///    * and the relevant local database and message store, with the provided
    ///    * status.
    ///    *
    ///    * This will still be called if `onRemoteCreateSuccessful` is.
    ///    *
    ///    * @param status - The status describing the operation's outcome.
    ///    */
    /// ```
    ///

    /// `void onStopCreate (in nsresult status);`
    #[inline]
    pub unsafe fn OnStopCreate(&self, status: nserror::nsresult) -> ::nserror::nsresult {
        ((*self.vtable).OnStopCreate)(self, status)
    }


    /// ```text
    /// /**
    ///    * Inform consumers of the key for the newly-created message in the local
    ///    * message database.
    ///    *
    ///    * @param msgKey - The key for the new message.
    ///    */
    /// ```
    ///

    /// `void onNewMessageKey (in nsMsgKey msgKey);`
    #[inline]
    pub unsafe fn OnNewMessageKey(&self, msgKey: nsMsgKey) -> ::nserror::nsresult {
        ((*self.vtable).OnNewMessageKey)(self, msgKey)
    }


    /// ```text
    /// /**
    ///    * Signal that the message was correctly created on the server.
    ///    *
    ///    * This does not signal the end of the message creation operation (as the
        ///    * client still has some processing to work through at this point), just the
    ///    * remote part.
    ///    *
    ///    * `nsIMsgDBHdr` is a type quite strongly associated with the message database
    ///    * and storage, and, going forwards, we'll want to decouple these interfaces
    ///    * from local storage management. We use currently use it because we don't
    ///    * have a better way to represent structured headers over the XPCOM boundary,
    ///    * and parsing RFC822 messages is easier in Rust than using the C++ message
    ///    * parser. We should revisit our use of `nsIMsgDBHdr` in client code when the
    ///    * situation improves.
    ///    *
    ///    * @param ewsId - The EWS ID of the new message.
    ///    * @returns A new `nsIMsgDBHdr` object to update with the message's metadata
    ///    *   and to commit to the message database
    ///    */
    /// ```
    ///

    /// `nsIMsgDBHdr onRemoteCreateSuccessful (in AUTF8String ewsId);`
    #[inline]
    pub unsafe fn OnRemoteCreateSuccessful(&self, ewsId: *const ::nsstring::nsACString, _retval: *mut*const nsIMsgDBHdr) -> ::nserror::nsresult {
        ((*self.vtable).OnRemoteCreateSuccessful)(self, ewsId, _retval)
    }


    /// ```text
    /// /**
    ///    * Inform consumers that the provided `nsIMsgDBHdr` has been fully populated
    ///    * and is ready to be persisted.
    ///    *
    ///    * @param hdr - The `nsIMsgDBHdr` that has been populated.
    ///    */
    /// ```
    ///

    /// `void onHdrPopulated (in nsIMsgDBHdr hdr);`
    #[inline]
    pub unsafe fn OnHdrPopulated(&self, hdr: *const nsIMsgDBHdr) -> ::nserror::nsresult {
        ((*self.vtable).OnHdrPopulated)(self, hdr)
    }


}


/// `interface IEwsMessageFetchListener : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct IEwsMessageFetchListener {
    vtable: &'static IEwsMessageFetchListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for IEwsMessageFetchListener.
unsafe impl XpCom for IEwsMessageFetchListener {
    const IID: nsIID = nsID(0x027150b1, 0xd127, 0x41a9,
        [0x89, 0x45, 0x18, 0xf9, 0x37, 0x47, 0x55, 0xb3]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for IEwsMessageFetchListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from IEwsMessageFetchListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait IEwsMessageFetchListenerCoerce {
    /// Cheaply cast a value of this type from a `IEwsMessageFetchListener`.
    fn coerce_from(v: &IEwsMessageFetchListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl IEwsMessageFetchListenerCoerce for IEwsMessageFetchListener {
    #[inline]
    fn coerce_from(v: &IEwsMessageFetchListener) -> &Self {
        v
    }
}

impl IEwsMessageFetchListener {
    /// Cast this `IEwsMessageFetchListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: IEwsMessageFetchListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for IEwsMessageFetchListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> IEwsMessageFetchListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &IEwsMessageFetchListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every IEwsMessageFetchListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct IEwsMessageFetchListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onFetchStart (); */
    pub OnFetchStart: unsafe extern "system" fn (this: *const IEwsMessageFetchListener) -> ::nserror::nsresult,

    /* void onFetchedDataAvailable (in nsIInputStream inputStream); */
    pub OnFetchedDataAvailable: unsafe extern "system" fn (this: *const IEwsMessageFetchListener, inputStream: *const nsIInputStream) -> ::nserror::nsresult,

    /* void onFetchStop (in nsresult status); */
    pub OnFetchStop: unsafe extern "system" fn (this: *const IEwsMessageFetchListener, status: nserror::nsresult) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl IEwsMessageFetchListener {

    /// ```text
    /// /**
    ///  * A listener used when downloading message content.
    ///  *
    ///  * Its shape is loosely based on `nsIStreamListener`, which cannot be used in
    ///  * this instance because we don't always have a request/channel that can be used
    ///  * in method calls when fetching a message's content (and using `nullptr`
        ///  * everywhere is quite ugly and potentially unsafe).
    ///  */
    /// ```
    ///

    /// `void onFetchStart ();`
    #[inline]
    pub unsafe fn OnFetchStart(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).OnFetchStart)(self, )
    }



    /// `void onFetchedDataAvailable (in nsIInputStream inputStream);`
    #[inline]
    pub unsafe fn OnFetchedDataAvailable(&self, inputStream: *const nsIInputStream) -> ::nserror::nsresult {
        ((*self.vtable).OnFetchedDataAvailable)(self, inputStream)
    }



    /// `void onFetchStop (in nsresult status);`
    #[inline]
    pub unsafe fn OnFetchStop(&self, status: nserror::nsresult) -> ::nserror::nsresult {
        ((*self.vtable).OnFetchStop)(self, status)
    }


}


/// `interface IEwsSimpleOperationListener : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct IEwsSimpleOperationListener {
    vtable: &'static IEwsSimpleOperationListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for IEwsSimpleOperationListener.
unsafe impl XpCom for IEwsSimpleOperationListener {
    const IID: nsIID = nsID(0x0217030b, 0xdcad, 0x4289,
        [0x91, 0x4f, 0x48, 0xba, 0xd6, 0x69, 0x3f, 0x2e]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for IEwsSimpleOperationListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from IEwsSimpleOperationListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait IEwsSimpleOperationListenerCoerce {
    /// Cheaply cast a value of this type from a `IEwsSimpleOperationListener`.
    fn coerce_from(v: &IEwsSimpleOperationListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl IEwsSimpleOperationListenerCoerce for IEwsSimpleOperationListener {
    #[inline]
    fn coerce_from(v: &IEwsSimpleOperationListener) -> &Self {
        v
    }
}

impl IEwsSimpleOperationListener {
    /// Cast this `IEwsSimpleOperationListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: IEwsSimpleOperationListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for IEwsSimpleOperationListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> IEwsSimpleOperationListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &IEwsSimpleOperationListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every IEwsSimpleOperationListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct IEwsSimpleOperationListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onOperationSuccess (in Array<AUTF8String> newIds, in boolean useLegacyFallback); */
    pub OnOperationSuccess: unsafe extern "system" fn (this: *const IEwsSimpleOperationListener, newIds: *const thin_vec::ThinVec<::nsstring::nsCString>, useLegacyFallback: bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl IEwsSimpleOperationListener {

    /// ```text
    /// /**
    ///  * A listener for "simple" operations, which only report a success to the
    ///  * consumer.
    ///  */
    /// /**
    ///    * Signals a successful completion of the EWS operation.
    ///    *
    ///    * @param newIds - If the operation involves generating new EWS identifiers
    ///    *   for one or several entities, they are included in this array. Otherwise,
    ///    *   this is an empty array.
    ///    * @param useLegacyFallback - Whether the client has decided the Exchange
    ///    *   server is too old to perform the operation the "normal" way and we need
    ///    *   to fall back to a "legacy" behaviour. What the normal and legacy
    ///    *   behaviours are, and whether there's even a difference in behaviour
    ///    *   depending on the server version, depends on the specific operation.
    ///    */
    /// ```
    ///

    /// `void onOperationSuccess (in Array<AUTF8String> newIds, in boolean useLegacyFallback);`
    #[inline]
    pub unsafe fn OnOperationSuccess(&self, newIds: *const thin_vec::ThinVec<::nsstring::nsCString>, useLegacyFallback: bool) -> ::nserror::nsresult {
        ((*self.vtable).OnOperationSuccess)(self, newIds, useLegacyFallback)
    }


}


/// `interface IEwsFallibleOperationListener : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct IEwsFallibleOperationListener {
    vtable: &'static IEwsFallibleOperationListenerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for IEwsFallibleOperationListener.
unsafe impl XpCom for IEwsFallibleOperationListener {
    const IID: nsIID = nsID(0x50b04351, 0x609c, 0x4650,
        [0xb9, 0x15, 0x81, 0xe2, 0xb8, 0xe2, 0x09, 0xc0]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for IEwsFallibleOperationListener {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from IEwsFallibleOperationListener.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait IEwsFallibleOperationListenerCoerce {
    /// Cheaply cast a value of this type from a `IEwsFallibleOperationListener`.
    fn coerce_from(v: &IEwsFallibleOperationListener) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl IEwsFallibleOperationListenerCoerce for IEwsFallibleOperationListener {
    #[inline]
    fn coerce_from(v: &IEwsFallibleOperationListener) -> &Self {
        v
    }
}

impl IEwsFallibleOperationListener {
    /// Cast this `IEwsFallibleOperationListener` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: IEwsFallibleOperationListenerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for IEwsFallibleOperationListener {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> IEwsFallibleOperationListenerCoerce for T {
    #[inline]
    fn coerce_from(v: &IEwsFallibleOperationListener) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every IEwsFallibleOperationListener
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct IEwsFallibleOperationListenerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* void onOperationFailure (in nsresult status); */
    pub OnOperationFailure: unsafe extern "system" fn (this: *const IEwsFallibleOperationListener, status: nserror::nsresult) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl IEwsFallibleOperationListener {

    /// ```text
    /// /**
    ///  * A listener for operations which failures we want to report to the consumer.
    ///  *
    ///  * This interface will likely not be implemented on its own but be QI'd from an
    ///  * object of a different type (e.g. `IEwsSimpleOperationListener`).
    ///  */
    /// /**
    ///    * Signals an error causing the operation to be aborted.
    ///    *
    ///    * @param status - The status describing the error.
    ///    */
    /// ```
    ///

    /// `void onOperationFailure (in nsresult status);`
    #[inline]
    pub unsafe fn OnOperationFailure(&self, status: nserror::nsresult) -> ::nserror::nsresult {
        ((*self.vtable).OnOperationFailure)(self, status)
    }


}


