
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_bcrypt_rsakey_blob.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject BCRYPT_RSAPUBLIC_BLOB_Type;

static PyTypeObject *BaseObject_Type;

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_get_magic(PyObject *obj, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyLong_FromUnsignedLongLong((uint32_t)(object->magic));
	return py_magic;
}

static int py_BCRYPT_RSAPUBLIC_BLOB_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->magic");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->magic));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->magic = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_get_bit_length(PyObject *obj, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_bit_length;
	py_bit_length = PyLong_FromUnsignedLongLong((uint32_t)(object->bit_length));
	return py_bit_length;
}

static int py_BCRYPT_RSAPUBLIC_BLOB_set_bit_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bit_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bit_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bit_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_get_public_exponent_len(PyObject *obj, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_public_exponent_len;
	py_public_exponent_len = PyLong_FromUnsignedLongLong((uint32_t)(object->public_exponent_len));
	return py_public_exponent_len;
}

static int py_BCRYPT_RSAPUBLIC_BLOB_set_public_exponent_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->public_exponent_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->public_exponent_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->public_exponent_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_get_modulus_len(PyObject *obj, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_modulus_len;
	py_modulus_len = PyLong_FromUnsignedLongLong((uint32_t)(object->modulus_len));
	return py_modulus_len;
}

static int py_BCRYPT_RSAPUBLIC_BLOB_set_modulus_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->modulus_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->modulus_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->modulus_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_get_prime1_len_unused(PyObject *obj, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_prime1_len_unused;
	py_prime1_len_unused = PyLong_FromUnsignedLongLong((uint32_t)(object->prime1_len_unused));
	return py_prime1_len_unused;
}

static int py_BCRYPT_RSAPUBLIC_BLOB_set_prime1_len_unused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->prime1_len_unused");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->prime1_len_unused));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->prime1_len_unused = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_get_prime2_len_unused(PyObject *obj, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_prime2_len_unused;
	py_prime2_len_unused = PyLong_FromUnsignedLongLong((uint32_t)(object->prime2_len_unused));
	return py_prime2_len_unused;
}

static int py_BCRYPT_RSAPUBLIC_BLOB_set_prime2_len_unused(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->prime2_len_unused");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->prime2_len_unused));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->prime2_len_unused = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_get_public_exponent(PyObject *obj, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_public_exponent;
	py_public_exponent = PyList_New(object->public_exponent_len);
	if (py_public_exponent == NULL) {
		return NULL;
	}
	{
		int public_exponent_cntr_0;
		for (public_exponent_cntr_0 = 0; public_exponent_cntr_0 < (object->public_exponent_len); public_exponent_cntr_0++) {
			PyObject *py_public_exponent_0;
			py_public_exponent_0 = PyLong_FromLong((uint16_t)((object->public_exponent)[public_exponent_cntr_0]));
			PyList_SetItem(py_public_exponent, public_exponent_cntr_0, py_public_exponent_0);
		}
	}
	return py_public_exponent;
}

static int py_BCRYPT_RSAPUBLIC_BLOB_set_public_exponent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->public_exponent");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int public_exponent_cntr_0;
		object->public_exponent = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->public_exponent, PyList_GET_SIZE(value));
		if (!object->public_exponent) { return -1; }
		talloc_set_name_const(object->public_exponent, "ARRAY: object->public_exponent");
		for (public_exponent_cntr_0 = 0; public_exponent_cntr_0 < PyList_GET_SIZE(value); public_exponent_cntr_0++) {
			if (PyList_GET_ITEM(value, public_exponent_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->public_exponent)[public_exponent_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->public_exponent)[public_exponent_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, public_exponent_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, public_exponent_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->public_exponent)[public_exponent_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_get_modulus(PyObject *obj, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_modulus;
	py_modulus = PyList_New(object->modulus_len);
	if (py_modulus == NULL) {
		return NULL;
	}
	{
		int modulus_cntr_0;
		for (modulus_cntr_0 = 0; modulus_cntr_0 < (object->modulus_len); modulus_cntr_0++) {
			PyObject *py_modulus_0;
			py_modulus_0 = PyLong_FromLong((uint16_t)((object->modulus)[modulus_cntr_0]));
			PyList_SetItem(py_modulus, modulus_cntr_0, py_modulus_0);
		}
	}
	return py_modulus;
}

static int py_BCRYPT_RSAPUBLIC_BLOB_set_modulus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->modulus");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int modulus_cntr_0;
		object->modulus = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->modulus, PyList_GET_SIZE(value));
		if (!object->modulus) { return -1; }
		talloc_set_name_const(object->modulus, "ARRAY: object->modulus");
		for (modulus_cntr_0 = 0; modulus_cntr_0 < PyList_GET_SIZE(value); modulus_cntr_0++) {
			if (PyList_GET_ITEM(value, modulus_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->modulus)[modulus_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->modulus)[modulus_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, modulus_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, modulus_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->modulus)[modulus_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_BCRYPT_RSAPUBLIC_BLOB_getsetters[] = {
	{
		.name = discard_const_p(char, "magic"),
		.get = py_BCRYPT_RSAPUBLIC_BLOB_get_magic,
		.set = py_BCRYPT_RSAPUBLIC_BLOB_set_magic,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "bit_length"),
		.get = py_BCRYPT_RSAPUBLIC_BLOB_get_bit_length,
		.set = py_BCRYPT_RSAPUBLIC_BLOB_set_bit_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "public_exponent_len"),
		.get = py_BCRYPT_RSAPUBLIC_BLOB_get_public_exponent_len,
		.set = py_BCRYPT_RSAPUBLIC_BLOB_set_public_exponent_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "modulus_len"),
		.get = py_BCRYPT_RSAPUBLIC_BLOB_get_modulus_len,
		.set = py_BCRYPT_RSAPUBLIC_BLOB_set_modulus_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "prime1_len_unused"),
		.get = py_BCRYPT_RSAPUBLIC_BLOB_get_prime1_len_unused,
		.set = py_BCRYPT_RSAPUBLIC_BLOB_set_prime1_len_unused,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "prime2_len_unused"),
		.get = py_BCRYPT_RSAPUBLIC_BLOB_get_prime2_len_unused,
		.set = py_BCRYPT_RSAPUBLIC_BLOB_set_prime2_len_unused,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "public_exponent"),
		.get = py_BCRYPT_RSAPUBLIC_BLOB_get_public_exponent,
		.set = py_BCRYPT_RSAPUBLIC_BLOB_set_public_exponent,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "modulus"),
		.get = py_BCRYPT_RSAPUBLIC_BLOB_get_modulus,
		.set = py_BCRYPT_RSAPUBLIC_BLOB_set_modulus,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct BCRYPT_RSAPUBLIC_BLOB, type);
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_BCRYPT_RSAPUBLIC_BLOB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_BCRYPT_RSAPUBLIC_BLOB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_BCRYPT_RSAPUBLIC_BLOB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_BCRYPT_RSAPUBLIC_BLOB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct BCRYPT_RSAPUBLIC_BLOB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_BCRYPT_RSAPUBLIC_BLOB, "BCRYPT_RSAPUBLIC_BLOB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_BCRYPT_RSAPUBLIC_BLOB, "BCRYPT_RSAPUBLIC_BLOB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_BCRYPT_RSAPUBLIC_BLOB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_BCRYPT_RSAPUBLIC_BLOB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_BCRYPT_RSAPUBLIC_BLOB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_BCRYPT_RSAPUBLIC_BLOB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject BCRYPT_RSAPUBLIC_BLOB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "bcrypt_rsakey_blob.BCRYPT_RSAPUBLIC_BLOB",
	.tp_getset = py_BCRYPT_RSAPUBLIC_BLOB_getsetters,
	.tp_methods = py_BCRYPT_RSAPUBLIC_BLOB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_BCRYPT_RSAPUBLIC_BLOB_new,
};

static PyMethodDef bcrypt_rsakey_blob_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "bcrypt_rsakey_blob",
	.m_doc = "bcrypt_rsakey_blob DCE/RPC",
	.m_size = -1,
	.m_methods = bcrypt_rsakey_blob_methods,
};
MODULE_INIT_FUNC(bcrypt_rsakey_blob)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	BCRYPT_RSAPUBLIC_BLOB_Type.tp_base = BaseObject_Type;
	BCRYPT_RSAPUBLIC_BLOB_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&BCRYPT_RSAPUBLIC_BLOB_Type) < 0)
		goto out;
#ifdef PY_BCRYPT_RSAPUBLIC_BLOB_PATCH
	PY_BCRYPT_RSAPUBLIC_BLOB_PATCH(&BCRYPT_RSAPUBLIC_BLOB_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "BCRYPT_RSAPUBLIC_MAGIC", PyLong_FromUnsignedLongLong(0x31415352));
	Py_INCREF((PyObject *)(void *)&BCRYPT_RSAPUBLIC_BLOB_Type);
	PyModule_AddObject(m, "BCRYPT_RSAPUBLIC_BLOB", (PyObject *)(void *)&BCRYPT_RSAPUBLIC_BLOB_Type);
#ifdef PY_MOD_BCRYPT_RSAKEY_BLOB_PATCH
	PY_MOD_BCRYPT_RSAKEY_BLOB_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	return m;

}
