// components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-params-data.h"
#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-shared-message-ids.h"

#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-import-headers.h"
#include "components/services/storage/privileged/mojom/indexed_db_client_state_checker.mojom-test-utils.h"


namespace storage::mojom {
const char IndexedDBClientStateChecker::Name_[] = "storage.mojom.IndexedDBClientStateChecker";

IndexedDBClientStateChecker::IPCStableHashFunction IndexedDBClientStateChecker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IndexedDBClientStateChecker>(message.name())) {
    case messages::IndexedDBClientStateChecker::kDisallowInactiveClient: {
      return &IndexedDBClientStateChecker::DisallowInactiveClient_Sym::IPCStableHash;
    }
    case messages::IndexedDBClientStateChecker::kMakeClone: {
      return &IndexedDBClientStateChecker::MakeClone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IndexedDBClientStateChecker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IndexedDBClientStateChecker>(message.name())) {
      case messages::IndexedDBClientStateChecker::kDisallowInactiveClient:
            return "Receive storage::mojom::IndexedDBClientStateChecker::DisallowInactiveClient";
      case messages::IndexedDBClientStateChecker::kMakeClone:
            return "Receive storage::mojom::IndexedDBClientStateChecker::MakeClone";
    }
  } else {
    switch (static_cast<messages::IndexedDBClientStateChecker>(message.name())) {
      case messages::IndexedDBClientStateChecker::kDisallowInactiveClient:
            return "Receive reply storage::mojom::IndexedDBClientStateChecker::DisallowInactiveClient";
      case messages::IndexedDBClientStateChecker::kMakeClone:
            return "Receive reply storage::mojom::IndexedDBClientStateChecker::MakeClone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IndexedDBClientStateChecker::DisallowInactiveClient_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::IndexedDBClientStateChecker::DisallowInactiveClient");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IndexedDBClientStateChecker::MakeClone_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::IndexedDBClientStateChecker::MakeClone");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IndexedDBClientStateChecker_DisallowInactiveClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IndexedDBClientStateChecker_DisallowInactiveClient_ForwardToCallback(
      IndexedDBClientStateChecker::DisallowInactiveClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  IndexedDBClientStateChecker_DisallowInactiveClient_ForwardToCallback(const IndexedDBClientStateChecker_DisallowInactiveClient_ForwardToCallback&) = delete;
  IndexedDBClientStateChecker_DisallowInactiveClient_ForwardToCallback& operator=(const IndexedDBClientStateChecker_DisallowInactiveClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IndexedDBClientStateChecker::DisallowInactiveClientCallback callback_;
};

IndexedDBClientStateCheckerProxy::IndexedDBClientStateCheckerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IndexedDBClientStateCheckerProxy::DisallowInactiveClient(
    DisallowInactiveClientReason in_reason, ::mojo::PendingReceiver<IndexedDBClientKeepActive> in_keep_active, DisallowInactiveClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBClientStateChecker::DisallowInactiveClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type DisallowInactiveClientReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_active"), in_keep_active,
                        "<value of type ::mojo::PendingReceiver<IndexedDBClientKeepActive>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBClientStateChecker::kDisallowInactiveClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::storage::mojom::DisallowInactiveClientReason>(
      in_reason, &params->reason);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::IndexedDBClientKeepActiveInterfaceBase>>(
      in_keep_active, &params->keep_active, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBClientStateChecker::Name_);
  message.set_method_name("DisallowInactiveClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IndexedDBClientStateChecker_DisallowInactiveClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IndexedDBClientStateCheckerProxy::MakeClone(
    ::mojo::PendingReceiver<IndexedDBClientStateChecker> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IndexedDBClientStateChecker::MakeClone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<IndexedDBClientStateChecker>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBClientStateChecker::kMakeClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBClientStateChecker_MakeClone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::IndexedDBClientStateCheckerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in IndexedDBClientStateChecker.MakeClone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBClientStateChecker::Name_);
  message.set_method_name("MakeClone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class IndexedDBClientStateChecker_DisallowInactiveClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IndexedDBClientStateChecker::DisallowInactiveClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IndexedDBClientStateChecker_DisallowInactiveClient_ProxyToResponder> proxy(
        new IndexedDBClientStateChecker_DisallowInactiveClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IndexedDBClientStateChecker_DisallowInactiveClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IndexedDBClientStateChecker_DisallowInactiveClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IndexedDBClientStateChecker_DisallowInactiveClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IndexedDBClientStateChecker::DisallowInactiveClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_was_active);
};

bool IndexedDBClientStateChecker_DisallowInactiveClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for IndexedDBClientStateChecker.0
  bool success = true;
  bool p_was_active{};
  IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_was_active = input_data_view.was_active();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IndexedDBClientStateChecker::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_was_active));
  return true;
}

void IndexedDBClientStateChecker_DisallowInactiveClient_ProxyToResponder::Run(
    bool in_was_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IndexedDBClientStateChecker::DisallowInactiveClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("was_active"), in_was_active,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IndexedDBClientStateChecker::kDisallowInactiveClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->was_active = in_was_active;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IndexedDBClientStateChecker::Name_);
  message.set_method_name("DisallowInactiveClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IndexedDBClientStateCheckerStubDispatch::Accept(
    IndexedDBClientStateChecker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IndexedDBClientStateChecker>(message->header()->name)) {
    case messages::IndexedDBClientStateChecker::kDisallowInactiveClient: {
      break;
    }
    case messages::IndexedDBClientStateChecker::kMakeClone: {
      DCHECK(message->is_serialized());
      internal::IndexedDBClientStateChecker_MakeClone_Params_Data* params =
          reinterpret_cast<internal::IndexedDBClientStateChecker_MakeClone_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for IndexedDBClientStateChecker.1
      bool success = true;
      ::mojo::PendingReceiver<IndexedDBClientStateChecker> p_receiver{};
      IndexedDBClientStateChecker_MakeClone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBClientStateChecker::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeClone(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool IndexedDBClientStateCheckerStubDispatch::AcceptWithResponder(
    IndexedDBClientStateChecker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IndexedDBClientStateChecker>(message->header()->name)) {
    case messages::IndexedDBClientStateChecker::kDisallowInactiveClient: {
      internal::IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data* params =
          reinterpret_cast<
              internal::IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for IndexedDBClientStateChecker.0
      bool success = true;
      DisallowInactiveClientReason p_reason{};
      ::mojo::PendingReceiver<IndexedDBClientKeepActive> p_keep_active{};
      IndexedDBClientStateChecker_DisallowInactiveClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success) {
        p_keep_active =
            input_data_view.TakeKeepActive<decltype(p_keep_active)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IndexedDBClientStateChecker::Name_, 0, false);
        return false;
      }
      IndexedDBClientStateChecker::DisallowInactiveClientCallback callback =
          IndexedDBClientStateChecker_DisallowInactiveClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisallowInactiveClient(        
        std::move(p_reason), 
        std::move(p_keep_active), std::move(callback));
      return true;
    }
    case messages::IndexedDBClientStateChecker::kMakeClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIndexedDBClientStateCheckerValidationInfo[] = {
    {base::to_underlying(messages::IndexedDBClientStateChecker::kDisallowInactiveClient),
     { &internal::IndexedDBClientStateChecker_DisallowInactiveClient_Params_Data::Validate,
      &internal::IndexedDBClientStateChecker_DisallowInactiveClient_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IndexedDBClientStateChecker::kMakeClone),
     { &internal::IndexedDBClientStateChecker_MakeClone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool IndexedDBClientStateCheckerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBClientStateChecker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIndexedDBClientStateCheckerValidationInfo);
}

bool IndexedDBClientStateCheckerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBClientStateChecker::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIndexedDBClientStateCheckerValidationInfo);

}
const char IndexedDBClientKeepActive::Name_[] = "storage.mojom.IndexedDBClientKeepActive";

IndexedDBClientKeepActive::IPCStableHashFunction IndexedDBClientKeepActive::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IndexedDBClientKeepActive::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

IndexedDBClientKeepActiveProxy::IndexedDBClientKeepActiveProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool IndexedDBClientKeepActiveStubDispatch::Accept(
    IndexedDBClientKeepActive* impl,
    mojo::Message* message) {
  return false;
}

// static
bool IndexedDBClientKeepActiveStubDispatch::AcceptWithResponder(
    IndexedDBClientKeepActive* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool IndexedDBClientKeepActiveRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IndexedDBClientKeepActive::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, {});
}



}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void IndexedDBClientStateCheckerInterceptorForTesting::DisallowInactiveClient(DisallowInactiveClientReason reason, ::mojo::PendingReceiver<IndexedDBClientKeepActive> keep_active, DisallowInactiveClientCallback callback) {
  GetForwardingInterface()->DisallowInactiveClient(
    std::move(reason)
    , 
    std::move(keep_active)
    , std::move(callback));
}
void IndexedDBClientStateCheckerInterceptorForTesting::MakeClone(::mojo::PendingReceiver<IndexedDBClientStateChecker> receiver) {
  GetForwardingInterface()->MakeClone(
    std::move(receiver)
    );
}
IndexedDBClientStateCheckerAsyncWaiter::IndexedDBClientStateCheckerAsyncWaiter(
    IndexedDBClientStateChecker* proxy) : proxy_(proxy) {}

IndexedDBClientStateCheckerAsyncWaiter::~IndexedDBClientStateCheckerAsyncWaiter() = default;

void IndexedDBClientStateCheckerAsyncWaiter::DisallowInactiveClient(
    DisallowInactiveClientReason reason, ::mojo::PendingReceiver<IndexedDBClientKeepActive> keep_active, bool* out_was_active) {
  base::RunLoop loop;
  proxy_->DisallowInactiveClient(
      std::move(reason),
      std::move(keep_active),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_was_active
,
             bool was_active) {*out_was_active = std::move(was_active);
            loop->Quit();
          },
          &loop,
          out_was_active));
  loop.Run();
}

bool IndexedDBClientStateCheckerAsyncWaiter::DisallowInactiveClient(
    DisallowInactiveClientReason reason, ::mojo::PendingReceiver<IndexedDBClientKeepActive> keep_active) {
  bool async_wait_result;
  DisallowInactiveClient(std::move(reason),std::move(keep_active),&async_wait_result);
  return async_wait_result;
}




IndexedDBClientKeepActiveAsyncWaiter::IndexedDBClientKeepActiveAsyncWaiter(
    IndexedDBClientKeepActive* proxy) : proxy_(proxy) {}

IndexedDBClientKeepActiveAsyncWaiter::~IndexedDBClientKeepActiveAsyncWaiter() = default;






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif