{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The ATK interface implemented for a cell inside a two-dimentional t'GI.Atk.Interfaces.Table.Table'
-- 
-- Being t'GI.Atk.Interfaces.Table.Table' a component which present elements ordered via rows
-- and columns, an t'GI.Atk.Interfaces.TableCell.TableCell' is the interface which each of those
-- elements, so \"cells\" should implement.
-- 
-- See [iface/@atkTable@/]

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Interfaces.TableCell
    ( 

-- * Exported types
    TableCell(..)                           ,
    IsTableCell                             ,
    toTableCell                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addRelationship]("GI.Atk.Objects.Object#g:method:addRelationship"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [initialize]("GI.Atk.Objects.Object#g:method:initialize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [notifyStateChange]("GI.Atk.Objects.Object#g:method:notifyStateChange"), [peekParent]("GI.Atk.Objects.Object#g:method:peekParent"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refAccessibleChild]("GI.Atk.Objects.Object#g:method:refAccessibleChild"), [refRelationSet]("GI.Atk.Objects.Object#g:method:refRelationSet"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [refStateSet]("GI.Atk.Objects.Object#g:method:refStateSet"), [removePropertyChangeHandler]("GI.Atk.Objects.Object#g:method:removePropertyChangeHandler"), [removeRelationship]("GI.Atk.Objects.Object#g:method:removeRelationship"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleId]("GI.Atk.Objects.Object#g:method:getAccessibleId"), [getAttributes]("GI.Atk.Objects.Object#g:method:getAttributes"), [getColumnHeaderCells]("GI.Atk.Interfaces.TableCell#g:method:getColumnHeaderCells"), [getColumnSpan]("GI.Atk.Interfaces.TableCell#g:method:getColumnSpan"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDescription]("GI.Atk.Objects.Object#g:method:getDescription"), [getHelpText]("GI.Atk.Objects.Object#g:method:getHelpText"), [getIndexInParent]("GI.Atk.Objects.Object#g:method:getIndexInParent"), [getLayer]("GI.Atk.Objects.Object#g:method:getLayer"), [getMdiZorder]("GI.Atk.Objects.Object#g:method:getMdiZorder"), [getNAccessibleChildren]("GI.Atk.Objects.Object#g:method:getNAccessibleChildren"), [getName]("GI.Atk.Objects.Object#g:method:getName"), [getObjectLocale]("GI.Atk.Objects.Object#g:method:getObjectLocale"), [getParent]("GI.Atk.Objects.Object#g:method:getParent"), [getPosition]("GI.Atk.Interfaces.TableCell#g:method:getPosition"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRole]("GI.Atk.Objects.Object#g:method:getRole"), [getRowColumnSpan]("GI.Atk.Interfaces.TableCell#g:method:getRowColumnSpan"), [getRowHeaderCells]("GI.Atk.Interfaces.TableCell#g:method:getRowHeaderCells"), [getRowSpan]("GI.Atk.Interfaces.TableCell#g:method:getRowSpan"), [getTable]("GI.Atk.Interfaces.TableCell#g:method:getTable").
-- 
-- ==== Setters
-- [setAccessibleId]("GI.Atk.Objects.Object#g:method:setAccessibleId"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDescription]("GI.Atk.Objects.Object#g:method:setDescription"), [setHelpText]("GI.Atk.Objects.Object#g:method:setHelpText"), [setName]("GI.Atk.Objects.Object#g:method:setName"), [setParent]("GI.Atk.Objects.Object#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRole]("GI.Atk.Objects.Object#g:method:setRole").

#if defined(ENABLE_OVERLOADING)
    ResolveTableCellMethod                  ,
#endif

-- ** getColumnHeaderCells #method:getColumnHeaderCells#

#if defined(ENABLE_OVERLOADING)
    TableCellGetColumnHeaderCellsMethodInfo ,
#endif
    tableCellGetColumnHeaderCells           ,


-- ** getColumnSpan #method:getColumnSpan#

#if defined(ENABLE_OVERLOADING)
    TableCellGetColumnSpanMethodInfo        ,
#endif
    tableCellGetColumnSpan                  ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    TableCellGetPositionMethodInfo          ,
#endif
    tableCellGetPosition                    ,


-- ** getRowColumnSpan #method:getRowColumnSpan#

#if defined(ENABLE_OVERLOADING)
    TableCellGetRowColumnSpanMethodInfo     ,
#endif
    tableCellGetRowColumnSpan               ,


-- ** getRowHeaderCells #method:getRowHeaderCells#

#if defined(ENABLE_OVERLOADING)
    TableCellGetRowHeaderCellsMethodInfo    ,
#endif
    tableCellGetRowHeaderCells              ,


-- ** getRowSpan #method:getRowSpan#

#if defined(ENABLE_OVERLOADING)
    TableCellGetRowSpanMethodInfo           ,
#endif
    tableCellGetRowSpan                     ,


-- ** getTable #method:getTable#

#if defined(ENABLE_OVERLOADING)
    TableCellGetTableMethodInfo             ,
#endif
    tableCellGetTable                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface TableCell 
-- | Memory-managed wrapper type.
newtype TableCell = TableCell (SP.ManagedPtr TableCell)
    deriving (Eq)

instance SP.ManagedPtrNewtype TableCell where
    toManagedPtr (TableCell p) = p

foreign import ccall "atk_table_cell_get_type"
    c_atk_table_cell_get_type :: IO B.Types.GType

instance B.Types.TypedObject TableCell where
    glibType = c_atk_table_cell_get_type

instance B.Types.GObject TableCell

-- | Type class for types which can be safely cast to t'TableCell', for instance with `toTableCell`.
class (SP.GObject o, O.IsDescendantOf TableCell o) => IsTableCell o
instance (SP.GObject o, O.IsDescendantOf TableCell o) => IsTableCell o

instance O.HasParentTypes TableCell
type instance O.ParentTypes TableCell = '[Atk.Object.Object, GObject.Object.Object]

-- | Cast to t'TableCell', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTableCell :: (MIO.MonadIO m, IsTableCell o) => o -> m TableCell
toTableCell = MIO.liftIO . B.ManagedPtr.unsafeCastTo TableCell

-- | Convert t'TableCell' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TableCell) where
    gvalueGType_ = c_atk_table_cell_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TableCell)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TableCell)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TableCell ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TableCell
type instance O.AttributeList TableCell = TableCellAttributeList
type TableCellAttributeList = ('[ '("accessibleComponentLayer", Atk.Object.ObjectAccessibleComponentLayerPropertyInfo), '("accessibleComponentMdiZorder", Atk.Object.ObjectAccessibleComponentMdiZorderPropertyInfo), '("accessibleDescription", Atk.Object.ObjectAccessibleDescriptionPropertyInfo), '("accessibleHelpText", Atk.Object.ObjectAccessibleHelpTextPropertyInfo), '("accessibleHypertextNlinks", Atk.Object.ObjectAccessibleHypertextNlinksPropertyInfo), '("accessibleId", Atk.Object.ObjectAccessibleIdPropertyInfo), '("accessibleName", Atk.Object.ObjectAccessibleNamePropertyInfo), '("accessibleParent", Atk.Object.ObjectAccessibleParentPropertyInfo), '("accessibleRole", Atk.Object.ObjectAccessibleRolePropertyInfo), '("accessibleTableCaption", Atk.Object.ObjectAccessibleTableCaptionPropertyInfo), '("accessibleTableCaptionObject", Atk.Object.ObjectAccessibleTableCaptionObjectPropertyInfo), '("accessibleTableColumnDescription", Atk.Object.ObjectAccessibleTableColumnDescriptionPropertyInfo), '("accessibleTableColumnHeader", Atk.Object.ObjectAccessibleTableColumnHeaderPropertyInfo), '("accessibleTableRowDescription", Atk.Object.ObjectAccessibleTableRowDescriptionPropertyInfo), '("accessibleTableRowHeader", Atk.Object.ObjectAccessibleTableRowHeaderPropertyInfo), '("accessibleTableSummary", Atk.Object.ObjectAccessibleTableSummaryPropertyInfo), '("accessibleValue", Atk.Object.ObjectAccessibleValuePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveTableCellMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTableCellMethod "addRelationship" o = Atk.Object.ObjectAddRelationshipMethodInfo
    ResolveTableCellMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTableCellMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTableCellMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTableCellMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTableCellMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTableCellMethod "initialize" o = Atk.Object.ObjectInitializeMethodInfo
    ResolveTableCellMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTableCellMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTableCellMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTableCellMethod "notifyStateChange" o = Atk.Object.ObjectNotifyStateChangeMethodInfo
    ResolveTableCellMethod "peekParent" o = Atk.Object.ObjectPeekParentMethodInfo
    ResolveTableCellMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTableCellMethod "refAccessibleChild" o = Atk.Object.ObjectRefAccessibleChildMethodInfo
    ResolveTableCellMethod "refRelationSet" o = Atk.Object.ObjectRefRelationSetMethodInfo
    ResolveTableCellMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTableCellMethod "refStateSet" o = Atk.Object.ObjectRefStateSetMethodInfo
    ResolveTableCellMethod "removePropertyChangeHandler" o = Atk.Object.ObjectRemovePropertyChangeHandlerMethodInfo
    ResolveTableCellMethod "removeRelationship" o = Atk.Object.ObjectRemoveRelationshipMethodInfo
    ResolveTableCellMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTableCellMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTableCellMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTableCellMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTableCellMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTableCellMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTableCellMethod "getAccessibleId" o = Atk.Object.ObjectGetAccessibleIdMethodInfo
    ResolveTableCellMethod "getAttributes" o = Atk.Object.ObjectGetAttributesMethodInfo
    ResolveTableCellMethod "getColumnHeaderCells" o = TableCellGetColumnHeaderCellsMethodInfo
    ResolveTableCellMethod "getColumnSpan" o = TableCellGetColumnSpanMethodInfo
    ResolveTableCellMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTableCellMethod "getDescription" o = Atk.Object.ObjectGetDescriptionMethodInfo
    ResolveTableCellMethod "getHelpText" o = Atk.Object.ObjectGetHelpTextMethodInfo
    ResolveTableCellMethod "getIndexInParent" o = Atk.Object.ObjectGetIndexInParentMethodInfo
    ResolveTableCellMethod "getLayer" o = Atk.Object.ObjectGetLayerMethodInfo
    ResolveTableCellMethod "getMdiZorder" o = Atk.Object.ObjectGetMdiZorderMethodInfo
    ResolveTableCellMethod "getNAccessibleChildren" o = Atk.Object.ObjectGetNAccessibleChildrenMethodInfo
    ResolveTableCellMethod "getName" o = Atk.Object.ObjectGetNameMethodInfo
    ResolveTableCellMethod "getObjectLocale" o = Atk.Object.ObjectGetObjectLocaleMethodInfo
    ResolveTableCellMethod "getParent" o = Atk.Object.ObjectGetParentMethodInfo
    ResolveTableCellMethod "getPosition" o = TableCellGetPositionMethodInfo
    ResolveTableCellMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTableCellMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTableCellMethod "getRole" o = Atk.Object.ObjectGetRoleMethodInfo
    ResolveTableCellMethod "getRowColumnSpan" o = TableCellGetRowColumnSpanMethodInfo
    ResolveTableCellMethod "getRowHeaderCells" o = TableCellGetRowHeaderCellsMethodInfo
    ResolveTableCellMethod "getRowSpan" o = TableCellGetRowSpanMethodInfo
    ResolveTableCellMethod "getTable" o = TableCellGetTableMethodInfo
    ResolveTableCellMethod "setAccessibleId" o = Atk.Object.ObjectSetAccessibleIdMethodInfo
    ResolveTableCellMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTableCellMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTableCellMethod "setDescription" o = Atk.Object.ObjectSetDescriptionMethodInfo
    ResolveTableCellMethod "setHelpText" o = Atk.Object.ObjectSetHelpTextMethodInfo
    ResolveTableCellMethod "setName" o = Atk.Object.ObjectSetNameMethodInfo
    ResolveTableCellMethod "setParent" o = Atk.Object.ObjectSetParentMethodInfo
    ResolveTableCellMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTableCellMethod "setRole" o = Atk.Object.ObjectSetRoleMethodInfo
    ResolveTableCellMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTableCellMethod t TableCell, O.OverloadedMethod info TableCell p) => OL.IsLabel t (TableCell -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTableCellMethod t TableCell, O.OverloadedMethod info TableCell p, R.HasField t TableCell p) => R.HasField t TableCell p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTableCellMethod t TableCell, O.OverloadedMethodInfo info TableCell) => OL.IsLabel t (O.MethodProxy info TableCell) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method TableCell::get_column_header_cells
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "TableCell" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkTableCellIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TPtrArray
--                  (TInterface Name { namespace = "Atk" , name = "Object" }))
-- throws : False
-- Skip return : False

foreign import ccall "atk_table_cell_get_column_header_cells" atk_table_cell_get_column_header_cells :: 
    Ptr TableCell ->                        -- cell : TInterface (Name {namespace = "Atk", name = "TableCell"})
    IO (Ptr (GPtrArray (Ptr Atk.Object.Object)))

-- | Returns the column headers as an array of cell accessibles.
-- 
-- /Since: 2.12/
tableCellGetColumnHeaderCells ::
    (B.CallStack.HasCallStack, MonadIO m, IsTableCell a) =>
    a
    -- ^ /@cell@/: a GObject instance that implements AtkTableCellIface
    -> m [Atk.Object.Object]
    -- ^ __Returns:__ a GPtrArray of AtkObjects
    -- representing the column header cells.
tableCellGetColumnHeaderCells cell = liftIO $ do
    cell' <- unsafeManagedPtrCastPtr cell
    result <- atk_table_cell_get_column_header_cells cell'
    checkUnexpectedReturnNULL "tableCellGetColumnHeaderCells" result
    result' <- unpackGPtrArray result
    result'' <- mapM (wrapObject Atk.Object.Object) result'
    unrefPtrArray result
    touchManagedPtr cell
    return result''

#if defined(ENABLE_OVERLOADING)
data TableCellGetColumnHeaderCellsMethodInfo
instance (signature ~ (m [Atk.Object.Object]), MonadIO m, IsTableCell a) => O.OverloadedMethod TableCellGetColumnHeaderCellsMethodInfo a signature where
    overloadedMethod = tableCellGetColumnHeaderCells

instance O.OverloadedMethodInfo TableCellGetColumnHeaderCellsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.TableCell.tableCellGetColumnHeaderCells",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-TableCell.html#v:tableCellGetColumnHeaderCells"
        })


#endif

-- method TableCell::get_column_span
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "TableCell" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkTableCellIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_table_cell_get_column_span" atk_table_cell_get_column_span :: 
    Ptr TableCell ->                        -- cell : TInterface (Name {namespace = "Atk", name = "TableCell"})
    IO Int32

-- | Returns the number of columns occupied by this cell accessible.
-- 
-- /Since: 2.12/
tableCellGetColumnSpan ::
    (B.CallStack.HasCallStack, MonadIO m, IsTableCell a) =>
    a
    -- ^ /@cell@/: a GObject instance that implements AtkTableCellIface
    -> m Int32
    -- ^ __Returns:__ a gint representing the number of columns occupied by this cell,
    -- or 0 if the cell does not implement this method.
tableCellGetColumnSpan cell = liftIO $ do
    cell' <- unsafeManagedPtrCastPtr cell
    result <- atk_table_cell_get_column_span cell'
    touchManagedPtr cell
    return result

#if defined(ENABLE_OVERLOADING)
data TableCellGetColumnSpanMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTableCell a) => O.OverloadedMethod TableCellGetColumnSpanMethodInfo a signature where
    overloadedMethod = tableCellGetColumnSpan

instance O.OverloadedMethodInfo TableCellGetColumnSpanMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.TableCell.tableCellGetColumnSpan",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-TableCell.html#v:tableCellGetColumnSpan"
        })


#endif

-- method TableCell::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "TableCell" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkTableCellIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row of the given cell."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the column of the given cell."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_table_cell_get_position" atk_table_cell_get_position :: 
    Ptr TableCell ->                        -- cell : TInterface (Name {namespace = "Atk", name = "TableCell"})
    Ptr Int32 ->                            -- row : TBasicType TInt
    Ptr Int32 ->                            -- column : TBasicType TInt
    IO CInt

-- | Retrieves the tabular position of this cell.
-- 
-- /Since: 2.12/
tableCellGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsTableCell a) =>
    a
    -- ^ /@cell@/: a GObject instance that implements AtkTableCellIface
    -> m ((Bool, Int32, Int32))
    -- ^ __Returns:__ TRUE if successful; FALSE otherwise.
tableCellGetPosition cell = liftIO $ do
    cell' <- unsafeManagedPtrCastPtr cell
    row <- allocMem :: IO (Ptr Int32)
    column <- allocMem :: IO (Ptr Int32)
    result <- atk_table_cell_get_position cell' row column
    let result' = (/= 0) result
    row' <- peek row
    column' <- peek column
    touchManagedPtr cell
    freeMem row
    freeMem column
    return (result', row', column')

#if defined(ENABLE_OVERLOADING)
data TableCellGetPositionMethodInfo
instance (signature ~ (m ((Bool, Int32, Int32))), MonadIO m, IsTableCell a) => O.OverloadedMethod TableCellGetPositionMethodInfo a signature where
    overloadedMethod = tableCellGetPosition

instance O.OverloadedMethodInfo TableCellGetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.TableCell.tableCellGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-TableCell.html#v:tableCellGetPosition"
        })


#endif

-- method TableCell::get_row_column_span
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "TableCell" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkTableCellIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row index of the given cell."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "column"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the column index of the given cell."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "row_span"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of rows occupied by this cell."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "column_span"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of columns occupied by this cell."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "atk_table_cell_get_row_column_span" atk_table_cell_get_row_column_span :: 
    Ptr TableCell ->                        -- cell : TInterface (Name {namespace = "Atk", name = "TableCell"})
    Ptr Int32 ->                            -- row : TBasicType TInt
    Ptr Int32 ->                            -- column : TBasicType TInt
    Ptr Int32 ->                            -- row_span : TBasicType TInt
    Ptr Int32 ->                            -- column_span : TBasicType TInt
    IO CInt

-- | Gets the row and column indexes and span of this cell accessible.
-- 
-- Note: If the object does not implement this function, then, by default, atk
-- will implement this function by calling get_row_span and get_column_span
-- on the object.
-- 
-- /Since: 2.12/
tableCellGetRowColumnSpan ::
    (B.CallStack.HasCallStack, MonadIO m, IsTableCell a) =>
    a
    -- ^ /@cell@/: a GObject instance that implements AtkTableCellIface
    -> m ((Bool, Int32, Int32, Int32, Int32))
    -- ^ __Returns:__ TRUE if successful; FALSE otherwise.
tableCellGetRowColumnSpan cell = liftIO $ do
    cell' <- unsafeManagedPtrCastPtr cell
    row <- allocMem :: IO (Ptr Int32)
    column <- allocMem :: IO (Ptr Int32)
    rowSpan <- allocMem :: IO (Ptr Int32)
    columnSpan <- allocMem :: IO (Ptr Int32)
    result <- atk_table_cell_get_row_column_span cell' row column rowSpan columnSpan
    let result' = (/= 0) result
    row' <- peek row
    column' <- peek column
    rowSpan' <- peek rowSpan
    columnSpan' <- peek columnSpan
    touchManagedPtr cell
    freeMem row
    freeMem column
    freeMem rowSpan
    freeMem columnSpan
    return (result', row', column', rowSpan', columnSpan')

#if defined(ENABLE_OVERLOADING)
data TableCellGetRowColumnSpanMethodInfo
instance (signature ~ (m ((Bool, Int32, Int32, Int32, Int32))), MonadIO m, IsTableCell a) => O.OverloadedMethod TableCellGetRowColumnSpanMethodInfo a signature where
    overloadedMethod = tableCellGetRowColumnSpan

instance O.OverloadedMethodInfo TableCellGetRowColumnSpanMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.TableCell.tableCellGetRowColumnSpan",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-TableCell.html#v:tableCellGetRowColumnSpan"
        })


#endif

-- method TableCell::get_row_header_cells
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "TableCell" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkTableCellIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TPtrArray
--                  (TInterface Name { namespace = "Atk" , name = "Object" }))
-- throws : False
-- Skip return : False

foreign import ccall "atk_table_cell_get_row_header_cells" atk_table_cell_get_row_header_cells :: 
    Ptr TableCell ->                        -- cell : TInterface (Name {namespace = "Atk", name = "TableCell"})
    IO (Ptr (GPtrArray (Ptr Atk.Object.Object)))

-- | Returns the row headers as an array of cell accessibles.
-- 
-- /Since: 2.12/
tableCellGetRowHeaderCells ::
    (B.CallStack.HasCallStack, MonadIO m, IsTableCell a) =>
    a
    -- ^ /@cell@/: a GObject instance that implements AtkTableCellIface
    -> m [Atk.Object.Object]
    -- ^ __Returns:__ a GPtrArray of AtkObjects
    -- representing the row header cells.
tableCellGetRowHeaderCells cell = liftIO $ do
    cell' <- unsafeManagedPtrCastPtr cell
    result <- atk_table_cell_get_row_header_cells cell'
    checkUnexpectedReturnNULL "tableCellGetRowHeaderCells" result
    result' <- unpackGPtrArray result
    result'' <- mapM (wrapObject Atk.Object.Object) result'
    unrefPtrArray result
    touchManagedPtr cell
    return result''

#if defined(ENABLE_OVERLOADING)
data TableCellGetRowHeaderCellsMethodInfo
instance (signature ~ (m [Atk.Object.Object]), MonadIO m, IsTableCell a) => O.OverloadedMethod TableCellGetRowHeaderCellsMethodInfo a signature where
    overloadedMethod = tableCellGetRowHeaderCells

instance O.OverloadedMethodInfo TableCellGetRowHeaderCellsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.TableCell.tableCellGetRowHeaderCells",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-TableCell.html#v:tableCellGetRowHeaderCells"
        })


#endif

-- method TableCell::get_row_span
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "TableCell" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkTableCellIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "atk_table_cell_get_row_span" atk_table_cell_get_row_span :: 
    Ptr TableCell ->                        -- cell : TInterface (Name {namespace = "Atk", name = "TableCell"})
    IO Int32

-- | Returns the number of rows occupied by this cell accessible.
-- 
-- /Since: 2.12/
tableCellGetRowSpan ::
    (B.CallStack.HasCallStack, MonadIO m, IsTableCell a) =>
    a
    -- ^ /@cell@/: a GObject instance that implements AtkTableCellIface
    -> m Int32
    -- ^ __Returns:__ a gint representing the number of rows occupied by this cell,
    -- or 0 if the cell does not implement this method.
tableCellGetRowSpan cell = liftIO $ do
    cell' <- unsafeManagedPtrCastPtr cell
    result <- atk_table_cell_get_row_span cell'
    touchManagedPtr cell
    return result

#if defined(ENABLE_OVERLOADING)
data TableCellGetRowSpanMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTableCell a) => O.OverloadedMethod TableCellGetRowSpanMethodInfo a signature where
    overloadedMethod = tableCellGetRowSpan

instance O.OverloadedMethodInfo TableCellGetRowSpanMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.TableCell.tableCellGetRowSpan",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-TableCell.html#v:tableCellGetRowSpan"
        })


#endif

-- method TableCell::get_table
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "cell"
--           , argType =
--               TInterface Name { namespace = "Atk" , name = "TableCell" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a GObject instance that implements AtkTableCellIface"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_table_cell_get_table" atk_table_cell_get_table :: 
    Ptr TableCell ->                        -- cell : TInterface (Name {namespace = "Atk", name = "TableCell"})
    IO (Ptr Atk.Object.Object)

-- | Returns a reference to the accessible of the containing table.
-- 
-- /Since: 2.12/
tableCellGetTable ::
    (B.CallStack.HasCallStack, MonadIO m, IsTableCell a) =>
    a
    -- ^ /@cell@/: a GObject instance that implements AtkTableCellIface
    -> m Atk.Object.Object
    -- ^ __Returns:__ the atk object for the containing table.
tableCellGetTable cell = liftIO $ do
    cell' <- unsafeManagedPtrCastPtr cell
    result <- atk_table_cell_get_table cell'
    checkUnexpectedReturnNULL "tableCellGetTable" result
    result' <- (wrapObject Atk.Object.Object) result
    touchManagedPtr cell
    return result'

#if defined(ENABLE_OVERLOADING)
data TableCellGetTableMethodInfo
instance (signature ~ (m Atk.Object.Object), MonadIO m, IsTableCell a) => O.OverloadedMethod TableCellGetTableMethodInfo a signature where
    overloadedMethod = tableCellGetTable

instance O.OverloadedMethodInfo TableCellGetTableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Atk.Interfaces.TableCell.tableCellGetTable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-atk-2.0.28/docs/GI-Atk-Interfaces-TableCell.html#v:tableCellGetTable"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TableCell = TableCellSignalList
type TableCellSignalList = ('[ '("activeDescendantChanged", Atk.Object.ObjectActiveDescendantChangedSignalInfo), '("announcement", Atk.Object.ObjectAnnouncementSignalInfo), '("attributeChanged", Atk.Object.ObjectAttributeChangedSignalInfo), '("childrenChanged", Atk.Object.ObjectChildrenChangedSignalInfo), '("focusEvent", Atk.Object.ObjectFocusEventSignalInfo), '("notification", Atk.Object.ObjectNotificationSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("propertyChange", Atk.Object.ObjectPropertyChangeSignalInfo), '("stateChange", Atk.Object.ObjectStateChangeSignalInfo), '("visibleDataChanged", Atk.Object.ObjectVisibleDataChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif


