#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_FREEDESKTOP_NOTIFY_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_FREEDESKTOP_NOTIFY_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-freedesktop-notify", _FreeDesktopNotify_)

static void*
__fcitx_FreeDesktopNotify_function_Show(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxNotify*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(uint32_t, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg4, _args.args[4]);
    FCITX_DEF_CAST_FROM_PTR(const FcitxFreedesktopNotifyAction*, arg5, _args.args[5]);
    FCITX_DEF_CAST_FROM_PTR(int32_t, arg6, _args.args[6]);
    FCITX_DEF_CAST_FROM_PTR(FcitxFreedesktopNotifyActionCallback, arg7, _args.args[7]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg8, _args.args[8]);
    FCITX_DEF_CAST_FROM_PTR(FcitxDestroyNotify, arg9, _args.args[9]);
    FcitxNotify* self = __self;
    FCITX_UNUSED(self);
    uint32_t res = (FcitxNotifySendNotification(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9));
    FCITX_RETURN_AS_PTR(uint32_t, res);
}

static void*
__fcitx_FreeDesktopNotify_function_Close(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxNotify*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(uint32_t, arg0, _args.args[0]);
    FcitxNotify* self = __self;
    FCITX_UNUSED(self);
    FcitxNotifyCloseNotification(self, arg0);
    return NULL;
}

static void*
__fcitx_FreeDesktopNotify_function_ShowTip(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxNotify*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(int32_t, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg4, _args.args[4]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg5, _args.args[5]);
    FcitxNotify* self = __self;
    FCITX_UNUSED(self);
    FcitxNotifyShowTip(self, arg0, arg1, arg2, arg3, arg4, arg5);
    return NULL;
}

static void*
__fcitx_FreeDesktopNotify_function_ShowSimple(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxNotify*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(int32_t, arg4, _args.args[4]);
    FcitxNotify* self = __self;
    FCITX_UNUSED(self);
    uint32_t res = (FcitxNotifySendNotification((self), (arg0), 0, (arg1), (arg2), (arg3), NULL, (arg4), NULL, NULL, NULL));
    FCITX_RETURN_AS_PTR(uint32_t, res);
}

static void*
__fcitx_FreeDesktopNotify_function_ShowTipFmt(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxNotify*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(int32_t, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg4, _args.args[4]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg5, _args.args[5]);
    FCITX_DEF_CAST_FROM_PTR(va_list*, arg6, _args.args[6]);
    FcitxNotify* self = __self;
    FCITX_UNUSED(self);
    FcitxNotifyShowTipFmtV(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    return NULL;
}

static void*
__fcitx_FreeDesktopNotify_function_ShowAddonTip(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxNotify*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg3, _args.args[3]);
    FcitxNotify* self = __self;
    FCITX_UNUSED(self);
    FcitxNotifyShowAddonTip(self, arg0, arg1, arg2, arg3);
    return NULL;
}

static void
FcitxFreeDesktopNotifyAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_FreeDesktopNotify_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_FreeDesktopNotify_addon_functions_table[] = {
        __fcitx_FreeDesktopNotify_function_Show,
        __fcitx_FreeDesktopNotify_function_Close,
        __fcitx_FreeDesktopNotify_function_ShowTip,
        __fcitx_FreeDesktopNotify_function_ShowSimple,
        __fcitx_FreeDesktopNotify_function_ShowTipFmt,
        __fcitx_FreeDesktopNotify_function_ShowAddonTip,
    };
    for (i = 0;i < 6;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_FreeDesktopNotify_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
