#ifndef SBK_PASSWORDBACKENDWRAPPER_H
#define SBK_PASSWORDBACKENDWRAPPER_H

#include <passwordbackends/passwordbackend.h>


// Argument includes
#include <QList>
#include <QString>
#include <QStringList>
#include <passwordmanager.h>
#include <qurl.h>
#include <qwidget.h>
#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

class PasswordBackendWrapper : public PasswordBackend
{
public:
    PasswordBackendWrapper();
    PasswordBackendWrapper(const PasswordBackendWrapper &) = delete;
    PasswordBackendWrapper& operator=(const PasswordBackendWrapper &) = delete;
    PasswordBackendWrapper(PasswordBackendWrapper &&) = delete;
    PasswordBackendWrapper& operator=(PasswordBackendWrapper &&) = delete;
    ~PasswordBackendWrapper() override;

    void addEntry(const ::PasswordEntry & entry) override;
    static void sbk_o_addEntry(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::PasswordEntry & entry);
    ::QList<PasswordEntry> getAllEntries() override;
    static ::QList<PasswordEntry> sbk_o_getAllEntries(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    ::QList<PasswordEntry> getEntries(const ::QUrl & url) override;
    static ::QList<PasswordEntry> sbk_o_getEntries(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & url);
    ::QStringList getUsernames(const ::QUrl & url) override;
    static ::QStringList sbk_o_getUsernames(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & url);
    bool hasSettings() const override;
    ::QString name() const override;
    void removeAll() override;
    void removeEntry(const ::PasswordEntry & entry) override;
    void setActive(bool active) override;
    void showSettings(::QWidget * parent) override;
    bool updateEntry(const ::PasswordEntry & entry) override;
    static bool sbk_o_updateEntry(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::PasswordEntry & entry);
    void updateLastUsed(::PasswordEntry & entry) override;
    static void sbk_o_updateLastUsed(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::PasswordEntry & entry);
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 12> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_PASSWORDBACKENDWRAPPER_H
