/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __FUTEXCTN_BPF_SKEL_H__
#define __FUTEXCTN_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct futexctn_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *start;
		struct bpf_map *stackmap;
		struct bpf_map *hists;
		struct bpf_map *rodata;
		struct bpf_map *bss;
	} maps;
	struct {
		struct bpf_program *futex_enter;
		struct bpf_program *futex_exit;
	} progs;
	struct {
		struct bpf_link *futex_enter;
		struct bpf_link *futex_exit;
	} links;
	struct futexctn_bpf__rodata {
		bool targ_summary;
		bool targ_ms;
		char __pad0[6];
		__u64 targ_lock;
		pid_t targ_pid;
		pid_t targ_tid;
	} *rodata;
	struct futexctn_bpf__bss {
	} *bss;

#ifdef __cplusplus
	static inline struct futexctn_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct futexctn_bpf *open_and_load();
	static inline int load(struct futexctn_bpf *skel);
	static inline int attach(struct futexctn_bpf *skel);
	static inline void detach(struct futexctn_bpf *skel);
	static inline void destroy(struct futexctn_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
futexctn_bpf__destroy(struct futexctn_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
futexctn_bpf__create_skeleton(struct futexctn_bpf *obj);

static inline struct futexctn_bpf *
futexctn_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct futexctn_bpf *obj;
	int err;

	obj = (struct futexctn_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = futexctn_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	futexctn_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct futexctn_bpf *
futexctn_bpf__open(void)
{
	return futexctn_bpf__open_opts(NULL);
}

static inline int
futexctn_bpf__load(struct futexctn_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct futexctn_bpf *
futexctn_bpf__open_and_load(void)
{
	struct futexctn_bpf *obj;
	int err;

	obj = futexctn_bpf__open();
	if (!obj)
		return NULL;
	err = futexctn_bpf__load(obj);
	if (err) {
		futexctn_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
futexctn_bpf__attach(struct futexctn_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
futexctn_bpf__detach(struct futexctn_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *futexctn_bpf__elf_bytes(size_t *sz);

static inline int
futexctn_bpf__create_skeleton(struct futexctn_bpf *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "futexctn_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 5;
	s->map_skel_sz = sizeof(*s->maps);
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt, s->map_skel_sz);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	s->maps[0].name = "start";
	s->maps[0].map = &obj->maps.start;

	s->maps[1].name = "stackmap";
	s->maps[1].map = &obj->maps.stackmap;

	s->maps[2].name = "hists";
	s->maps[2].map = &obj->maps.hists;

	s->maps[3].name = "futexctn.rodata";
	s->maps[3].map = &obj->maps.rodata;
	s->maps[3].mmaped = (void **)&obj->rodata;

	s->maps[4].name = "futexctn.bss";
	s->maps[4].map = &obj->maps.bss;
	s->maps[4].mmaped = (void **)&obj->bss;

	/* programs */
	s->prog_cnt = 2;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "futex_enter";
	s->progs[0].prog = &obj->progs.futex_enter;
	s->progs[0].link = &obj->links.futex_enter;

	s->progs[1].name = "futex_exit";
	s->progs[1].prog = &obj->progs.futex_exit;
	s->progs[1].link = &obj->links.futex_exit;

	s->data = (void *)futexctn_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *futexctn_bpf__elf_bytes(size_t *sz)
{
	*sz = 11360;
	return (const void *)"\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x20\x28\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x11\0\
\x01\0\xbf\x16\0\0\0\0\0\0\x79\x61\x18\0\0\0\0\0\x18\x02\0\0\x7f\xfe\xff\xff\0\
\0\0\0\0\0\0\0\x5f\x21\0\0\0\0\0\0\x55\x01\x24\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\
\x7b\x0a\xe8\xff\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x12\0\0\0\0\0\
\0\x16\x02\x06\0\0\0\0\0\xbf\x02\0\0\0\0\0\0\x77\x02\0\0\x20\0\0\0\x61\x11\0\0\
\0\0\0\0\x67\x01\0\0\x20\0\0\0\xc7\x01\0\0\x20\0\0\0\x5d\x12\x18\0\0\0\0\0\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x61\x12\0\0\0\0\0\0\x16\x02\x02\0\0\0\0\0\x61\
\x11\0\0\0\0\0\0\x5e\x01\x12\0\0\0\0\0\x79\x61\x10\0\0\0\0\0\x7b\x1a\xf8\xff\0\
\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x79\x23\0\0\0\0\0\0\x15\x03\x02\0\0\
\0\0\0\x79\x22\0\0\0\0\0\0\x5d\x12\x0a\0\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\
\xf0\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe8\xff\xff\xff\xbf\xa3\0\0\0\
\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\
\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xbf\x17\0\
\0\0\0\0\0\xb7\x01\0\0\0\0\0\0\x7b\x1a\xf0\xff\0\0\0\0\x7b\x1a\xe8\xff\0\0\0\0\
\x7b\x1a\xe0\xff\0\0\0\0\x85\0\0\0\x05\0\0\0\xbf\x06\0\0\0\0\0\0\x85\0\0\0\x0e\
\0\0\0\x7b\x0a\xf8\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xf8\xff\xff\xff\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x92\0\0\0\0\0\
\x79\x71\x10\0\0\0\0\0\x18\x02\0\0\0\0\0\x80\0\0\0\0\0\0\0\0\x5f\x21\0\0\0\0\0\
\0\x55\x01\x88\0\0\0\0\0\x79\x01\0\0\0\0\0\0\x1f\x16\0\0\0\0\0\0\xc5\x06\x85\0\
\0\0\0\0\x79\xa1\xf8\xff\0\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\x79\x02\x08\0\0\0\0\0\
\x7b\x2a\xe8\xff\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x22\0\0\0\0\0\
\0\x56\x02\x07\0\0\0\0\0\xbf\x71\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xb7\x03\0\0\0\x01\0\0\x85\0\0\0\x1b\0\0\0\x63\x0a\xf0\xff\0\0\0\0\x05\0\x02\
\0\0\0\0\0\x77\x01\0\0\x20\0\0\0\x7b\x1a\xe0\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\
\x07\x02\0\0\xe0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\
\0\0\0\xbf\x01\0\0\0\0\0\0\x55\x01\x11\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\
\0\xe0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x03\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\xb7\x04\0\0\x01\0\0\0\x85\0\0\0\x02\0\0\0\x16\0\x01\0\0\0\0\0\x56\
\0\x63\0\xef\xff\xff\xff\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xe0\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\xbf\x01\0\0\0\0\0\0\x15\
\x01\x5c\0\0\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x71\x22\0\0\0\0\0\0\x56\
\x02\x02\0\x01\0\0\0\x37\x06\0\0\x40\x42\x0f\0\x05\0\x01\0\0\0\0\0\x37\x06\0\0\
\xe8\x03\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\xad\x26\x1f\0\0\0\0\0\xb4\
\x03\0\0\x01\0\0\0\x18\x04\0\0\xff\xff\xff\xff\0\0\0\0\xff\xff\0\0\xb4\x02\0\0\
\x01\0\0\0\x2d\x46\x01\0\0\0\0\0\xb4\x02\0\0\0\0\0\0\x64\x02\0\0\x04\0\0\0\xbf\
\x64\0\0\0\0\0\0\x77\x04\0\0\x20\0\0\0\x7c\x24\0\0\0\0\0\0\xb4\x05\0\0\x01\0\0\
\0\x26\x04\x01\0\xff\0\0\0\xb4\x05\0\0\0\0\0\0\x64\x05\0\0\x03\0\0\0\x7c\x54\0\
\0\0\0\0\0\xb4\0\0\0\x01\0\0\0\x26\x04\x01\0\x0f\0\0\0\xb4\0\0\0\0\0\0\0\x64\0\
\0\0\x02\0\0\0\x7c\x04\0\0\0\0\0\0\x26\x04\x01\0\x03\0\0\0\xb4\x03\0\0\0\0\0\0\
\x64\x03\0\0\x01\0\0\0\x7c\x34\0\0\0\0\0\0\x74\x04\0\0\x01\0\0\0\x4c\x42\0\0\0\
\0\0\0\x4c\x52\0\0\0\0\0\0\x4c\x02\0\0\0\0\0\0\x4c\x32\0\0\0\0\0\0\x04\x02\0\0\
\x20\0\0\0\x05\0\x1a\0\0\0\0\0\xb4\x03\0\0\x01\0\0\0\xb4\x02\0\0\x01\0\0\0\x25\
\x06\x01\0\xff\xff\0\0\xb4\x02\0\0\0\0\0\0\x64\x02\0\0\x04\0\0\0\xbc\x64\0\0\0\
\0\0\0\x7c\x24\0\0\0\0\0\0\xb4\x05\0\0\x01\0\0\0\x26\x04\x01\0\xff\0\0\0\xb4\
\x05\0\0\0\0\0\0\x64\x05\0\0\x03\0\0\0\x7c\x54\0\0\0\0\0\0\xb4\0\0\0\x01\0\0\0\
\x26\x04\x01\0\x0f\0\0\0\xb4\0\0\0\0\0\0\0\x64\0\0\0\x02\0\0\0\x7c\x04\0\0\0\0\
\0\0\x26\x04\x01\0\x03\0\0\0\xb4\x03\0\0\0\0\0\0\x64\x03\0\0\x01\0\0\0\x7c\x34\
\0\0\0\0\0\0\x74\x04\0\0\x01\0\0\0\x4c\x42\0\0\0\0\0\0\x4c\x52\0\0\0\0\0\0\x4c\
\x02\0\0\0\0\0\0\x4c\x32\0\0\0\0\0\0\xa6\x02\x01\0\x23\0\0\0\xb4\x02\0\0\x23\0\
\0\0\x67\x02\0\0\x02\0\0\0\xbf\x13\0\0\0\0\0\0\x0f\x23\0\0\0\0\0\0\xb4\x02\0\0\
\x01\0\0\0\xc3\x23\0\0\x01\0\0\0\xb7\x02\0\0\x01\0\0\0\xdb\x21\xa0\0\x01\0\0\0\
\xbf\x62\0\0\0\0\0\0\xdb\x21\xa8\0\x01\0\0\0\xb7\x02\0\0\0\0\0\0\xb7\0\0\0\0\0\
\0\0\xdb\x01\xb0\0\x41\0\0\0\xbf\x03\0\0\0\0\0\0\x07\x03\0\0\xff\xff\xff\xff\
\xad\x63\x01\0\0\0\0\0\xdb\x61\xb0\0\xf1\0\0\0\xdb\x21\xb8\0\x41\0\0\0\x3d\x62\
\x02\0\0\0\0\0\xbf\x20\0\0\0\0\0\0\xdb\x61\xb8\0\xf1\0\0\0\x07\x01\0\0\x90\0\0\
\0\xb4\x02\0\0\x10\0\0\0\x85\0\0\0\x10\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\
\xf8\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x03\0\0\0\xb4\0\
\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x47\x50\x4c\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\xd0\x05\0\0\xd0\x05\0\0\xed\
\x09\0\0\0\0\0\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\
\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x01\0\0\0\x05\0\0\0\0\0\0\x01\
\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\
\0\0\0\x04\0\0\0\0\x28\0\0\0\0\0\0\0\0\0\x02\x08\0\0\0\x19\0\0\0\0\0\0\x08\x09\
\0\0\0\x1d\0\0\0\0\0\0\x08\x0a\0\0\0\x23\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\x02\x0c\0\0\0\x36\0\0\0\x02\0\0\x04\x10\0\0\0\x3c\0\0\0\x08\0\0\0\
\0\0\0\0\x3f\0\0\0\x08\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x45\0\0\0\
\x01\0\0\0\0\0\0\0\x4a\0\0\0\x05\0\0\0\x40\0\0\0\x56\0\0\0\x07\0\0\0\x80\0\0\0\
\x5a\0\0\0\x0b\0\0\0\xc0\0\0\0\x60\0\0\0\0\0\0\x0e\x0d\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\x02\x10\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x07\0\0\0\0\
\0\0\0\0\0\0\x02\x12\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x04\0\
\0\0\0\0\0\0\x02\0\0\x04\x10\0\0\0\x45\0\0\0\x0f\0\0\0\0\0\0\0\x66\0\0\0\x11\0\
\0\0\x40\0\0\0\x6f\0\0\0\0\0\0\x0e\x13\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\x02\x16\0\
\0\0\x78\0\0\0\x03\0\0\x04\x18\0\0\0\x81\0\0\0\x09\0\0\0\0\0\0\0\x3f\0\0\0\x09\
\0\0\0\x40\0\0\0\x8a\0\0\0\x02\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\x02\x18\0\0\0\x98\
\0\0\0\x06\0\0\x04\xc0\0\0\0\x9d\0\0\0\x1b\0\0\0\0\0\0\0\xa3\0\0\0\x1d\0\0\0\
\x80\x04\0\0\xa8\0\0\0\x09\0\0\0\0\x05\0\0\xb2\0\0\0\x09\0\0\0\x40\x05\0\0\xc0\
\0\0\0\x09\0\0\0\x80\x05\0\0\xc4\0\0\0\x09\0\0\0\xc0\x05\0\0\xc8\0\0\0\0\0\0\
\x08\x1a\0\0\0\xce\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\
\0\x19\0\0\0\x04\0\0\0\x24\0\0\0\xdb\0\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\
\0\0\0\0\0\x03\0\0\0\0\x1c\0\0\0\x04\0\0\0\x10\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\
\0\0\x45\0\0\0\x01\0\0\0\0\0\0\0\x4a\0\0\0\x05\0\0\0\x40\0\0\0\x56\0\0\0\x15\0\
\0\0\x80\0\0\0\x5a\0\0\0\x17\0\0\0\xc0\0\0\0\xe0\0\0\0\0\0\0\x0e\x1e\0\0\0\x01\
\0\0\0\0\0\0\0\0\0\0\x02\x21\0\0\0\xe6\0\0\0\x03\0\0\x04\x10\0\0\0\xfa\0\0\0\
\x22\0\0\0\0\0\0\0\xfe\0\0\0\x02\0\0\0\x40\0\0\0\x01\x01\0\0\x26\0\0\0\x80\0\0\
\0\x06\x01\0\0\x04\0\0\x04\x08\0\0\0\x45\0\0\0\x23\0\0\0\0\0\0\0\x12\x01\0\0\
\x24\0\0\0\x10\0\0\0\x18\x01\0\0\x24\0\0\0\x18\0\0\0\x26\x01\0\0\x02\0\0\0\x20\
\0\0\0\x2a\x01\0\0\0\0\0\x01\x02\0\0\0\x10\0\0\0\x39\x01\0\0\0\0\0\x01\x01\0\0\
\0\x08\0\0\0\x47\x01\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\
\0\x25\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x55\x01\0\0\x20\0\
\0\0\x59\x01\0\0\x01\0\0\x0c\x27\0\0\0\0\0\0\0\0\0\0\x02\x2a\0\0\0\x3a\x03\0\0\
\x03\0\0\x04\x18\0\0\0\xfa\0\0\0\x22\0\0\0\0\0\0\0\xfe\0\0\0\x02\0\0\0\x40\0\0\
\0\x4d\x03\0\0\x2b\0\0\0\x80\0\0\0\x51\x03\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\x01\
\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x55\x01\0\0\x29\0\0\0\x56\x03\0\0\x01\0\0\x0c\
\x2c\0\0\0\0\0\0\0\0\0\0\x0a\x2f\0\0\0\0\0\0\0\0\0\0\x09\x30\0\0\0\x6c\x09\0\0\
\0\0\0\x08\x31\0\0\0\x71\x09\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x04\x77\x09\0\0\0\
\0\0\x0e\x2e\0\0\0\x01\0\0\0\x84\x09\0\0\0\0\0\x0e\x2e\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\x0a\x35\0\0\0\0\0\0\0\0\0\0\x09\x09\0\0\0\x8c\x09\0\0\0\0\0\x0e\x34\0\0\
\0\x01\0\0\0\0\0\0\0\0\0\0\x0a\x38\0\0\0\0\0\0\0\0\0\0\x09\x39\0\0\0\x96\x09\0\
\0\0\0\0\x08\x3a\0\0\0\x9c\x09\0\0\0\0\0\x08\x02\0\0\0\xab\x09\0\0\0\0\0\x0e\
\x37\0\0\0\x01\0\0\0\xb4\x09\0\0\0\0\0\x0e\x37\0\0\0\x01\0\0\0\xbd\x09\0\0\0\0\
\0\x0e\x18\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x1c\0\0\0\x04\0\0\0\x04\0\0\
\0\xca\x09\0\0\0\0\0\x0e\x3e\0\0\0\x01\0\0\0\xd2\x09\0\0\x01\0\0\x0f\0\0\0\0\
\x3d\0\0\0\0\0\0\0\xc0\0\0\0\xd7\x09\0\0\x03\0\0\x0f\0\0\0\0\x0e\0\0\0\0\0\0\0\
\x20\0\0\0\x14\0\0\0\0\0\0\0\x10\0\0\0\x1f\0\0\0\0\0\0\0\x20\0\0\0\xdd\x09\0\0\
\x05\0\0\x0f\0\0\0\0\x32\0\0\0\0\0\0\0\x01\0\0\0\x33\0\0\0\0\0\0\0\x01\0\0\0\
\x36\0\0\0\0\0\0\0\x08\0\0\0\x3b\0\0\0\0\0\0\0\x04\0\0\0\x3c\0\0\0\0\0\0\0\x04\
\0\0\0\xe5\x09\0\0\x01\0\0\x0f\0\0\0\0\x3f\0\0\0\0\0\0\0\x04\0\0\0\0\x69\x6e\
\x74\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\
\x5f\0\x75\x36\x34\0\x5f\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\
\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x76\x61\x6c\x5f\x74\0\x74\x73\0\x75\x61\
\x64\x64\x72\0\x74\x79\x70\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\
\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\x73\x74\x61\x72\x74\0\x6b\x65\x79\x5f\x73\
\x69\x7a\x65\0\x73\x74\x61\x63\x6b\x6d\x61\x70\0\x68\x69\x73\x74\x5f\x6b\x65\
\x79\0\x70\x69\x64\x5f\x74\x67\x69\x64\0\x75\x73\x65\x72\x5f\x73\x74\x61\x63\
\x6b\x5f\x69\x64\0\x68\x69\x73\x74\0\x73\x6c\x6f\x74\x73\0\x63\x6f\x6d\x6d\0\
\x63\x6f\x6e\x74\x65\x6e\x64\x65\x64\0\x74\x6f\x74\x61\x6c\x5f\x65\x6c\x61\x70\
\x73\x65\x64\0\x6d\x69\x6e\0\x6d\x61\x78\0\x5f\x5f\x75\x33\x32\0\x75\x6e\x73\
\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x63\x68\x61\x72\0\x68\x69\x73\x74\x73\0\
\x73\x79\x73\x63\x61\x6c\x6c\x5f\x74\x72\x61\x63\x65\x5f\x65\x6e\x74\x65\x72\0\
\x65\x6e\x74\0\x6e\x72\0\x61\x72\x67\x73\0\x74\x72\x61\x63\x65\x5f\x65\x6e\x74\
\x72\x79\0\x66\x6c\x61\x67\x73\0\x70\x72\x65\x65\x6d\x70\x74\x5f\x63\x6f\x75\
\x6e\x74\0\x70\x69\x64\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x73\x68\x6f\x72\
\x74\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x63\x68\x61\x72\0\x75\x6e\x73\x69\
\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\0\x63\x74\x78\0\x66\x75\x74\x65\x78\x5f\
\x65\x6e\x74\x65\x72\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\
\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x5f\x66\x75\x74\
\x65\x78\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\
\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x66\x75\x74\x65\
\x78\x63\x74\x6e\x2e\x62\x70\x66\x2e\x63\0\x69\x6e\x74\x20\x66\x75\x74\x65\x78\
\x5f\x65\x6e\x74\x65\x72\x28\x73\x74\x72\x75\x63\x74\x20\x73\x79\x73\x63\x61\
\x6c\x6c\x5f\x74\x72\x61\x63\x65\x5f\x65\x6e\x74\x65\x72\x20\x2a\x63\x74\x78\
\x29\0\x30\x3a\x32\x3a\x31\0\x09\x69\x66\x20\x28\x28\x28\x69\x6e\x74\x29\x63\
\x74\x78\x2d\x3e\x61\x72\x67\x73\x5b\x31\x5d\x20\x26\x20\x46\x55\x54\x45\x58\
\x5f\x43\x4d\x44\x5f\x4d\x41\x53\x4b\x29\x20\x21\x3d\x20\x46\x55\x54\x45\x58\
\x5f\x57\x41\x49\x54\x29\0\x09\x70\x69\x64\x5f\x74\x67\x69\x64\x20\x3d\x20\x62\
\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\x5f\
\x74\x67\x69\x64\x28\x29\x3b\0\x09\x69\x66\x20\x28\x74\x61\x72\x67\x5f\x70\x69\
\x64\x20\x26\x26\x20\x74\x61\x72\x67\x5f\x70\x69\x64\x20\x21\x3d\x20\x70\x69\
\x64\x5f\x74\x67\x69\x64\x20\x3e\x3e\x20\x33\x32\x29\0\x09\x69\x66\x20\x28\x74\
\x61\x72\x67\x5f\x74\x69\x64\x20\x26\x26\x20\x74\x61\x72\x67\x5f\x74\x69\x64\
\x20\x21\x3d\x20\x74\x69\x64\x29\0\x30\x3a\x32\x3a\x30\0\x09\x76\x2e\x75\x61\
\x64\x64\x72\x20\x3d\x20\x63\x74\x78\x2d\x3e\x61\x72\x67\x73\x5b\x30\x5d\x3b\0\
\x09\x69\x66\x20\x28\x74\x61\x72\x67\x5f\x6c\x6f\x63\x6b\x20\x26\x26\x20\x74\
\x61\x72\x67\x5f\x6c\x6f\x63\x6b\x20\x21\x3d\x20\x76\x2e\x75\x61\x64\x64\x72\
\x29\0\x09\x76\x2e\x74\x73\x20\x3d\x20\x62\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\
\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\
\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x2c\x20\
\x26\x70\x69\x64\x5f\x74\x67\x69\x64\x2c\x20\x26\x76\x2c\x20\x42\x50\x46\x5f\
\x41\x4e\x59\x29\x3b\0\x7d\0\x73\x79\x73\x63\x61\x6c\x6c\x5f\x74\x72\x61\x63\
\x65\x5f\x65\x78\x69\x74\0\x72\x65\x74\0\x6c\x6f\x6e\x67\0\x66\x75\x74\x65\x78\
\x5f\x65\x78\x69\x74\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x73\x79\x73\
\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x78\x69\x74\x5f\x66\x75\x74\x65\
\x78\0\x69\x6e\x74\x20\x66\x75\x74\x65\x78\x5f\x65\x78\x69\x74\x28\x73\x74\x72\
\x75\x63\x74\x20\x73\x79\x73\x63\x61\x6c\x6c\x5f\x74\x72\x61\x63\x65\x5f\x65\
\x78\x69\x74\x20\x2a\x63\x74\x78\x29\0\x09\x73\x74\x72\x75\x63\x74\x20\x68\x69\
\x73\x74\x5f\x6b\x65\x79\x20\x68\x6b\x65\x79\x20\x3d\x20\x7b\x7d\x3b\0\x09\x74\
\x73\x20\x3d\x20\x62\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\
\x73\x28\x29\x3b\0\x09\x76\x70\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\
\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x2c\x20\
\x26\x70\x69\x64\x5f\x74\x67\x69\x64\x29\x3b\0\x09\x69\x66\x20\x28\x21\x76\x70\
\x29\0\x30\x3a\x32\0\x09\x69\x66\x20\x28\x28\x69\x6e\x74\x29\x63\x74\x78\x2d\
\x3e\x72\x65\x74\x20\x3c\x20\x30\x29\0\x09\x64\x65\x6c\x74\x61\x20\x3d\x20\x28\
\x73\x36\x34\x29\x28\x74\x73\x20\x2d\x20\x76\x70\x2d\x3e\x74\x73\x29\x3b\0\x09\
\x69\x66\x20\x28\x64\x65\x6c\x74\x61\x20\x3c\x20\x30\x29\0\x09\x68\x6b\x65\x79\
\x2e\x70\x69\x64\x5f\x74\x67\x69\x64\x20\x3d\x20\x70\x69\x64\x5f\x74\x67\x69\
\x64\x3b\0\x09\x68\x6b\x65\x79\x2e\x75\x61\x64\x64\x72\x20\x3d\x20\x76\x70\x2d\
\x3e\x75\x61\x64\x64\x72\x3b\0\x09\x69\x66\x20\x28\x21\x74\x61\x72\x67\x5f\x73\
\x75\x6d\x6d\x61\x72\x79\x29\0\x09\x09\x68\x6b\x65\x79\x2e\x75\x73\x65\x72\x5f\
\x73\x74\x61\x63\x6b\x5f\x69\x64\x20\x3d\x20\x62\x70\x66\x5f\x67\x65\x74\x5f\
\x73\x74\x61\x63\x6b\x69\x64\x28\x63\x74\x78\x2c\x20\x26\x73\x74\x61\x63\x6b\
\x6d\x61\x70\x2c\x20\x42\x50\x46\x5f\x46\x5f\x55\x53\x45\x52\x5f\x53\x54\x41\
\x43\x4b\x29\x3b\0\x09\x09\x68\x6b\x65\x79\x2e\x70\x69\x64\x5f\x74\x67\x69\x64\
\x20\x3e\x3e\x3d\x20\x33\x32\x3b\0\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\
\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\
\x73\x2f\x2e\x2f\x6d\x61\x70\x73\x2e\x62\x70\x66\x2e\x68\0\x09\x76\x61\x6c\x20\
\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\
\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\x29\x3b\0\x09\x69\x66\x20\x28\x76\
\x61\x6c\x29\0\x09\x65\x72\x72\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\
\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\x28\x6d\x61\x70\x2c\x20\x6b\x65\x79\
\x2c\x20\x69\x6e\x69\x74\x2c\x20\x42\x50\x46\x5f\x4e\x4f\x45\x58\x49\x53\x54\
\x29\x3b\0\x09\x69\x66\x20\x28\x65\x72\x72\x20\x26\x26\x20\x65\x72\x72\x20\x21\
\x3d\x20\x2d\x45\x45\x58\x49\x53\x54\x29\0\x09\x72\x65\x74\x75\x72\x6e\x20\x62\
\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\x6c\x65\x6d\x28\
\x6d\x61\x70\x2c\x20\x6b\x65\x79\x29\x3b\0\x09\x69\x66\x20\x28\x21\x68\x69\x73\
\x74\x70\x29\0\x09\x69\x66\x20\x28\x74\x61\x72\x67\x5f\x6d\x73\x29\0\x09\x09\
\x64\x65\x6c\x74\x61\x20\x2f\x3d\x20\x31\x30\x30\x30\x30\x30\x30\x55\x3b\0\x09\
\x09\x64\x65\x6c\x74\x61\x20\x2f\x3d\x20\x31\x30\x30\x30\x55\x3b\0\x2f\x62\x75\
\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\x62\
\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x2e\x2f\x62\x69\x74\x73\x2e\x62\x70\
\x66\x2e\x68\0\x09\x69\x66\x20\x28\x68\x69\x29\0\x09\x75\x33\x32\x20\x68\x69\
\x20\x3d\x20\x76\x20\x3e\x3e\x20\x33\x32\x3b\0\x09\x72\x20\x3d\x20\x28\x76\x20\
\x3e\x20\x30\x78\x46\x46\x46\x46\x29\x20\x3c\x3c\x20\x34\x3b\x20\x76\x20\x3e\
\x3e\x3d\x20\x72\x3b\0\x09\x73\x68\x69\x66\x74\x20\x3d\x20\x28\x76\x20\x3e\x20\
\x30\x78\x46\x46\x29\x20\x3c\x3c\x20\x33\x3b\x20\x76\x20\x3e\x3e\x3d\x20\x73\
\x68\x69\x66\x74\x3b\x20\x72\x20\x7c\x3d\x20\x73\x68\x69\x66\x74\x3b\0\x09\x73\
\x68\x69\x66\x74\x20\x3d\x20\x28\x76\x20\x3e\x20\x30\x78\x46\x29\x20\x3c\x3c\
\x20\x32\x3b\x20\x76\x20\x3e\x3e\x3d\x20\x73\x68\x69\x66\x74\x3b\x20\x72\x20\
\x7c\x3d\x20\x73\x68\x69\x66\x74\x3b\0\x09\x73\x68\x69\x66\x74\x20\x3d\x20\x28\
\x76\x20\x3e\x20\x30\x78\x33\x29\x20\x3c\x3c\x20\x31\x3b\x20\x76\x20\x3e\x3e\
\x3d\x20\x73\x68\x69\x66\x74\x3b\x20\x72\x20\x7c\x3d\x20\x73\x68\x69\x66\x74\
\x3b\0\x09\x72\x20\x7c\x3d\x20\x28\x76\x20\x3e\x3e\x20\x31\x29\x3b\0\x09\x09\
\x72\x65\x74\x75\x72\x6e\x20\x6c\x6f\x67\x32\x28\x68\x69\x29\x20\x2b\x20\x33\
\x32\x3b\0\x09\x09\x72\x65\x74\x75\x72\x6e\x20\x6c\x6f\x67\x32\x28\x76\x29\x3b\
\0\x09\x69\x66\x20\x28\x73\x6c\x6f\x74\x20\x3e\x3d\x20\x4d\x41\x58\x5f\x53\x4c\
\x4f\x54\x53\x29\0\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\
\x6e\x64\x5f\x61\x64\x64\x28\x26\x68\x69\x73\x74\x70\x2d\x3e\x73\x6c\x6f\x74\
\x73\x5b\x73\x6c\x6f\x74\x5d\x2c\x20\x31\x29\x3b\0\x09\x5f\x5f\x73\x79\x6e\x63\
\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\x68\x69\x73\
\x74\x70\x2d\x3e\x63\x6f\x6e\x74\x65\x6e\x64\x65\x64\x2c\x20\x31\x29\x3b\0\x09\
\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\
\x64\x28\x26\x68\x69\x73\x74\x70\x2d\x3e\x74\x6f\x74\x61\x6c\x5f\x65\x6c\x61\
\x70\x73\x65\x64\x2c\x20\x64\x65\x6c\x74\x61\x29\x3b\0\x09\x6d\x69\x6e\x20\x3d\
\x20\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\
\x64\x64\x28\x26\x68\x69\x73\x74\x70\x2d\x3e\x6d\x69\x6e\x2c\x20\x30\x29\x3b\0\
\x09\x69\x66\x20\x28\x21\x6d\x69\x6e\x20\x7c\x7c\x20\x6d\x69\x6e\x20\x3e\x20\
\x64\x65\x6c\x74\x61\x29\0\x09\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x76\x61\x6c\x5f\
\x63\x6f\x6d\x70\x61\x72\x65\x5f\x61\x6e\x64\x5f\x73\x77\x61\x70\x28\x26\x68\
\x69\x73\x74\x70\x2d\x3e\x6d\x69\x6e\x2c\x20\x6d\x69\x6e\x2c\x20\x64\x65\x6c\
\x74\x61\x29\x3b\0\x09\x6d\x61\x78\x20\x3d\x20\x5f\x5f\x73\x79\x6e\x63\x5f\x66\
\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\x68\x69\x73\x74\x70\
\x2d\x3e\x6d\x61\x78\x2c\x20\x30\x29\x3b\0\x09\x69\x66\x20\x28\x6d\x61\x78\x20\
\x3c\x20\x64\x65\x6c\x74\x61\x29\0\x09\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x76\x61\
\x6c\x5f\x63\x6f\x6d\x70\x61\x72\x65\x5f\x61\x6e\x64\x5f\x73\x77\x61\x70\x28\
\x26\x68\x69\x73\x74\x70\x2d\x3e\x6d\x61\x78\x2c\x20\x6d\x61\x78\x2c\x20\x64\
\x65\x6c\x74\x61\x29\x3b\0\x09\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\
\x65\x6e\x74\x5f\x63\x6f\x6d\x6d\x28\x26\x68\x69\x73\x74\x70\x2d\x3e\x63\x6f\
\x6d\x6d\x2c\x20\x73\x69\x7a\x65\x6f\x66\x28\x68\x69\x73\x74\x70\x2d\x3e\x63\
\x6f\x6d\x6d\x29\x29\x3b\0\x09\x62\x70\x66\x5f\x6d\x61\x70\x5f\x64\x65\x6c\x65\
\x74\x65\x5f\x65\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x2c\x20\x26\x70\x69\
\x64\x5f\x74\x67\x69\x64\x29\x3b\0\x62\x6f\x6f\x6c\0\x5f\x42\x6f\x6f\x6c\0\x74\
\x61\x72\x67\x5f\x73\x75\x6d\x6d\x61\x72\x79\0\x74\x61\x72\x67\x5f\x6d\x73\0\
\x74\x61\x72\x67\x5f\x6c\x6f\x63\x6b\0\x70\x69\x64\x5f\x74\0\x5f\x5f\x6b\x65\
\x72\x6e\x65\x6c\x5f\x70\x69\x64\x5f\x74\0\x74\x61\x72\x67\x5f\x70\x69\x64\0\
\x74\x61\x72\x67\x5f\x74\x69\x64\0\x69\x6e\x69\x74\x69\x61\x6c\x5f\x68\x69\x73\
\x74\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x62\x73\x73\0\x2e\x6d\x61\x70\x73\0\
\x2e\x72\x6f\x64\x61\x74\x61\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\0\0\x9f\xeb\x01\
\0\x20\0\0\0\0\0\0\0\x24\0\0\0\x24\0\0\0\x24\x06\0\0\x48\x06\0\0\x44\0\0\0\x08\
\0\0\0\x65\x01\0\0\x01\0\0\0\0\0\0\0\x28\0\0\0\x61\x03\0\0\x01\0\0\0\0\0\0\0\
\x2d\0\0\0\x10\0\0\0\x65\x01\0\0\x18\0\0\0\0\0\0\0\x89\x01\0\0\xb8\x01\0\0\0\
\xd0\0\0\x08\0\0\0\x89\x01\0\0\xef\x01\0\0\x0c\xe8\0\0\x20\0\0\0\x89\x01\0\0\
\xef\x01\0\0\x2b\xe8\0\0\x30\0\0\0\x89\x01\0\0\x28\x02\0\0\x0d\xf4\0\0\x38\0\0\
\0\x89\x01\0\0\x28\x02\0\0\x0b\xf4\0\0\x40\0\0\0\x89\x01\0\0\x50\x02\0\0\x06\
\xfc\0\0\x58\0\0\0\x89\x01\0\0\x50\x02\0\0\x0f\xfc\0\0\x60\0\0\0\x89\x01\0\0\
\x50\x02\0\0\x27\xfc\0\0\x70\0\0\0\x89\x01\0\0\x50\x02\0\0\x12\xfc\0\0\x88\0\0\
\0\x89\x01\0\0\x50\x02\0\0\x0f\xfc\0\0\x90\0\0\0\x89\x01\0\0\x7d\x02\0\0\x06\
\x04\x01\0\xa8\0\0\0\x89\x01\0\0\x7d\x02\0\0\x0f\x04\x01\0\xb0\0\0\0\x89\x01\0\
\0\x7d\x02\0\0\x12\x04\x01\0\xb8\0\0\0\x89\x01\0\0\x7d\x02\0\0\x0f\x04\x01\0\
\xc0\0\0\0\x89\x01\0\0\xa5\x02\0\0\x0c\x0c\x01\0\xc8\0\0\0\x89\x01\0\0\xa5\x02\
\0\0\x0a\x0c\x01\0\xd0\0\0\0\x89\x01\0\0\xbe\x02\0\0\x06\x10\x01\0\xe8\0\0\0\
\x89\x01\0\0\xbe\x02\0\0\x10\x10\x01\0\xf0\0\0\0\x89\x01\0\0\xbe\x02\0\0\x13\
\x10\x01\0\xf8\0\0\0\x89\x01\0\0\xbe\x02\0\0\x10\x10\x01\0\0\x01\0\0\x89\x01\0\
\0\xe6\x02\0\0\x09\x18\x01\0\x08\x01\0\0\x89\x01\0\0\xe6\x02\0\0\x07\x18\x01\0\
\x30\x01\0\0\x89\x01\0\0\x02\x03\0\0\x02\x1c\x01\0\x50\x01\0\0\x89\x01\0\0\x38\
\x03\0\0\x01\x24\x01\0\x61\x03\0\0\x49\0\0\0\0\0\0\0\x89\x01\0\0\x84\x03\0\0\0\
\x30\x01\0\x10\0\0\0\x89\x01\0\0\xb3\x03\0\0\x12\x3c\x01\0\x28\0\0\0\x89\x01\0\
\0\xcf\x03\0\0\x07\x50\x01\0\x38\0\0\0\x89\x01\0\0\x28\x02\0\0\x0d\x54\x01\0\
\x40\0\0\0\x89\x01\0\0\x28\x02\0\0\x0b\x54\x01\0\x58\0\0\0\x89\x01\0\0\xe9\x03\
\0\0\x07\x58\x01\0\x70\0\0\0\x89\x01\0\0\x17\x04\0\0\x06\x5c\x01\0\x78\0\0\0\
\x89\x01\0\0\x25\x04\0\0\x10\x64\x01\0\x90\0\0\0\x89\x01\0\0\x25\x04\0\0\x14\
\x64\x01\0\xa0\0\0\0\x89\x01\0\0\x3d\x04\0\0\x19\x70\x01\0\xa8\0\0\0\x89\x01\0\
\0\x3d\x04\0\0\x13\x70\x01\0\xb0\0\0\0\x89\x01\0\0\x5a\x04\0\0\x0c\x74\x01\0\
\xb8\0\0\0\x89\x01\0\0\x6a\x04\0\0\x12\x80\x01\0\xc0\0\0\0\x89\x01\0\0\x6a\x04\
\0\0\x10\x80\x01\0\xc8\0\0\0\x89\x01\0\0\x85\x04\0\0\x13\x84\x01\0\xd0\0\0\0\
\x89\x01\0\0\x85\x04\0\0\x0d\x84\x01\0\xd8\0\0\0\x89\x01\0\0\x9e\x04\0\0\x07\
\x88\x01\0\xf0\0\0\0\x89\x01\0\0\x9e\x04\0\0\x06\x88\x01\0\xf8\0\0\0\x89\x01\0\
\0\xb2\x04\0\0\x18\x8c\x01\0\x20\x01\0\0\x89\x01\0\0\xb2\x04\0\0\x16\x8c\x01\0\
\x28\x01\0\0\x89\x01\0\0\xb2\x04\0\0\x03\x8c\x01\0\x30\x01\0\0\x89\x01\0\0\xfc\
\x04\0\0\x11\x94\x01\0\x50\x01\0\0\x14\x05\0\0\x41\x05\0\0\x08\x7c\0\0\x70\x01\
\0\0\x14\x05\0\0\x67\x05\0\0\x06\x80\0\0\x88\x01\0\0\x14\x05\0\0\x71\x05\0\0\
\x08\x8c\0\0\xb8\x01\0\0\x14\x05\0\0\xaa\x05\0\0\x0a\x90\0\0\xd8\x01\0\0\x14\
\x05\0\0\xc6\x05\0\0\x09\x9c\0\0\xf8\x01\0\0\x89\x01\0\0\xed\x05\0\0\x06\xa0\
\x01\0\0\x02\0\0\x89\x01\0\0\xfa\x05\0\0\x06\xac\x01\0\x20\x02\0\0\x89\x01\0\0\
\x08\x06\0\0\x09\xb0\x01\0\x28\x02\0\0\x89\x01\0\0\x08\x06\0\0\x03\xb0\x01\0\
\x30\x02\0\0\x89\x01\0\0\x1d\x06\0\0\x09\xb8\x01\0\x48\x02\0\0\x2f\x06\0\0\x5c\
\x06\0\0\x06\x64\0\0\x70\x02\0\0\x2f\x06\0\0\x65\x06\0\0\x0d\x5c\0\0\x80\x02\0\
\0\x2f\x06\0\0\x78\x06\0\0\x13\x30\0\0\x88\x02\0\0\x2f\x06\0\0\x65\x06\0\0\x0d\
\x5c\0\0\x98\x02\0\0\x2f\x06\0\0\x78\x06\0\0\x1b\x30\0\0\xb8\x02\0\0\x2f\x06\0\
\0\x99\x06\0\0\x15\x34\0\0\xc0\x02\0\0\x2f\x06\0\0\x99\x06\0\0\x1d\x34\0\0\xe0\
\x02\0\0\x2f\x06\0\0\xcc\x06\0\0\x14\x38\0\0\xe8\x02\0\0\x2f\x06\0\0\xcc\x06\0\
\0\x1c\x38\0\0\0\x03\0\0\x2f\x06\0\0\xfe\x06\0\0\x14\x3c\0\0\x08\x03\0\0\x2f\
\x06\0\0\xfe\x06\0\0\x1c\x3c\0\0\x10\x03\0\0\x2f\x06\0\0\x30\x07\0\0\x0a\x40\0\
\0\x18\x03\0\0\x2f\x06\0\0\x30\x07\0\0\x04\x40\0\0\x38\x03\0\0\x2f\x06\0\0\x40\
\x07\0\0\x13\x68\0\0\x40\x03\0\0\x2f\x06\0\0\x40\x07\0\0\x03\x68\0\0\x58\x03\0\
\0\x2f\x06\0\0\x58\x07\0\0\x0f\x70\0\0\x68\x03\0\0\x2f\x06\0\0\x78\x06\0\0\x13\
\x30\0\0\x70\x03\0\0\x2f\x06\0\0\x78\x06\0\0\x1b\x30\0\0\x98\x03\0\0\x2f\x06\0\
\0\x99\x06\0\0\x15\x34\0\0\xa0\x03\0\0\x2f\x06\0\0\x99\x06\0\0\x1d\x34\0\0\xc0\
\x03\0\0\x2f\x06\0\0\xcc\x06\0\0\x14\x38\0\0\xc8\x03\0\0\x2f\x06\0\0\xcc\x06\0\
\0\x1c\x38\0\0\xe0\x03\0\0\x2f\x06\0\0\xfe\x06\0\0\x14\x3c\0\0\xe8\x03\0\0\x2f\
\x06\0\0\xfe\x06\0\0\x1c\x3c\0\0\xf0\x03\0\0\x2f\x06\0\0\x30\x07\0\0\x0a\x40\0\
\0\xf8\x03\0\0\x2f\x06\0\0\x30\x07\0\0\x04\x40\0\0\x18\x04\0\0\x89\x01\0\0\x6a\
\x07\0\0\x0b\xc4\x01\0\x28\x04\0\0\x89\x01\0\0\x82\x07\0\0\x18\xcc\x01\0\x48\
\x04\0\0\x89\x01\0\0\x82\x07\0\0\x02\xcc\x01\0\x58\x04\0\0\x89\x01\0\0\xb1\x07\
\0\0\x02\xd0\x01\0\x60\x04\0\0\x89\x01\0\0\xde\x07\0\0\x02\xd4\x01\0\x78\x04\0\
\0\x89\x01\0\0\x13\x08\0\0\x08\xd8\x01\0\x88\x04\0\0\x89\x01\0\0\x40\x08\0\0\
\x0b\xdc\x01\0\xa0\x04\0\0\x89\x01\0\0\x5a\x08\0\0\x03\xe0\x01\0\xa8\x04\0\0\
\x89\x01\0\0\x92\x08\0\0\x08\xe4\x01\0\xb0\x04\0\0\x89\x01\0\0\xbf\x08\0\0\x0a\
\xe8\x01\0\xb8\x04\0\0\x89\x01\0\0\xd1\x08\0\0\x03\xec\x01\0\xc8\x04\0\0\x89\
\x01\0\0\x09\x09\0\0\x1f\xf0\x01\0\xd0\x04\0\0\x89\x01\0\0\x09\x09\0\0\x02\xf0\
\x01\0\xf0\x04\0\0\x89\x01\0\0\x43\x09\0\0\x02\xfc\x01\0\x08\x05\0\0\x89\x01\0\
\0\x38\x03\0\0\x01\x04\x02\0\x10\0\0\0\x65\x01\0\0\x02\0\0\0\x08\0\0\0\x21\0\0\
\0\xe9\x01\0\0\0\0\0\0\xc0\0\0\0\x21\0\0\0\x9f\x02\0\0\0\0\0\0\x61\x03\0\0\x01\
\0\0\0\x78\0\0\0\x2a\0\0\0\x21\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x03\0\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\0\0\0\x01\0\x09\0\0\0\0\0\0\0\
\0\0\xc0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa7\
\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\x60\x01\0\0\0\0\0\0\xe5\0\0\0\x11\0\x07\0\
\x10\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\xdc\0\0\0\x11\0\x07\0\x14\0\0\0\0\0\0\0\
\x04\0\0\0\0\0\0\0\xbc\0\0\0\x11\0\x07\0\x08\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\
\x7d\0\0\0\x11\0\x08\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x83\0\0\0\x12\0\x05\0\
\0\0\0\0\0\0\0\0\x18\x05\0\0\0\0\0\0\x01\0\0\0\x11\0\x07\0\0\0\0\0\0\0\0\0\x01\
\0\0\0\0\0\0\0\xb3\0\0\0\x11\0\x08\0\x20\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x8e\0\
\0\0\x11\0\x08\0\x30\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x9f\0\0\0\x11\0\x07\0\x01\
\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\x0f\x01\0\0\x11\0\x0a\0\0\0\0\0\0\0\0\0\x04\0\
\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x90\0\0\0\0\0\0\0\x01\0\0\0\
\x07\0\0\0\xd0\0\0\0\0\0\0\0\x01\0\0\0\x08\0\0\0\x30\x01\0\0\0\0\0\0\x01\0\0\0\
\x09\0\0\0\x58\0\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\xd8\0\0\0\0\0\0\0\x01\0\0\0\
\x0b\0\0\0\0\x01\0\0\0\0\0\0\x01\0\0\0\x0c\0\0\0\x50\x01\0\0\0\0\0\0\x01\0\0\0\
\x0d\0\0\0\x88\x01\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\x98\x01\0\0\0\0\0\0\x01\0\0\
\0\x04\0\0\0\xd8\x01\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\0\x02\0\0\0\0\0\0\x01\0\0\
\0\x0e\0\0\0\xf0\x04\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x50\x05\0\0\0\0\0\0\x04\0\
\0\0\x04\0\0\0\x68\x05\0\0\0\0\0\0\x04\0\0\0\x09\0\0\0\x74\x05\0\0\0\0\0\0\x04\
\0\0\0\x0c\0\0\0\x80\x05\0\0\0\0\0\0\x04\0\0\0\x0d\0\0\0\x98\x05\0\0\0\0\0\0\
\x03\0\0\0\x0b\0\0\0\xa4\x05\0\0\0\0\0\0\x03\0\0\0\x0e\0\0\0\xb0\x05\0\0\0\0\0\
\0\x03\0\0\0\x08\0\0\0\xbc\x05\0\0\0\0\0\0\x03\0\0\0\x06\0\0\0\xc8\x05\0\0\0\0\
\0\0\x03\0\0\0\x07\0\0\0\xe0\x05\0\0\0\0\0\0\x04\0\0\0\x0f\0\0\0\x2c\0\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x50\0\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x60\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x80\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xa0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xf0\0\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x10\x01\0\0\0\0\0\0\
\x04\0\0\0\x01\0\0\0\x20\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x30\x01\0\0\0\0\0\
\0\x04\0\0\0\x01\0\0\0\x40\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x50\x01\0\0\0\0\
\0\0\x04\0\0\0\x01\0\0\0\x60\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x70\x01\0\0\0\
\0\0\0\x04\0\0\0\x01\0\0\0\x80\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x90\x01\0\0\
\0\0\0\0\x04\0\0\0\x01\0\0\0\xa0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xb0\x01\0\
\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xd8\x01\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe8\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xf8\
\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x08\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x18\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\x38\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\
\0\0\x58\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\x02\0\0\0\0\0\0\x04\0\0\0\x02\
\0\0\0\x78\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x88\x02\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\x98\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa8\x02\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\xb8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc8\x02\0\0\0\0\0\0\x04\0\
\0\0\x02\0\0\0\xd8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe8\x02\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\xf8\x02\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x08\x03\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x18\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x03\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\x38\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x03\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\x58\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\x03\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\x78\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x88\x03\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\x98\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa8\x03\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb8\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc8\x03\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd8\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe8\
\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xf8\x03\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\x08\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x18\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\x28\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x38\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\
\0\0\x48\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x04\0\0\0\0\0\0\x04\0\0\0\x02\
\0\0\0\x68\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\x04\0\0\0\0\0\0\x04\0\0\0\
\x02\0\0\0\x88\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x98\x04\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\xa8\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb8\x04\0\0\0\0\0\0\x04\0\
\0\0\x02\0\0\0\xc8\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd8\x04\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\xe8\x04\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xf8\x04\0\0\0\0\0\0\
\x04\0\0\0\x02\0\0\0\x08\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x18\x05\0\0\0\0\0\
\0\x04\0\0\0\x02\0\0\0\x28\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x38\x05\0\0\0\0\
\0\0\x04\0\0\0\x02\0\0\0\x48\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x58\x05\0\0\0\
\0\0\0\x04\0\0\0\x02\0\0\0\x68\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x78\x05\0\0\
\0\0\0\0\x04\0\0\0\x02\0\0\0\x88\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x98\x05\0\
\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xa8\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xb8\x05\
\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xc8\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xd8\
\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\xe8\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\
\xf8\x05\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x08\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\x18\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\
\0\0\x38\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x06\0\0\0\0\0\0\x04\0\0\0\x02\
\0\0\0\x58\x06\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x74\x06\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x84\x06\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x9c\x06\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\x0f\x14\x15\x18\x12\x10\x11\x13\x16\x17\x04\x19\0\x74\x61\x72\x67\
\x5f\x73\x75\x6d\x6d\x61\x72\x79\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\
\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x78\
\x69\x74\x5f\x66\x75\x74\x65\x78\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\
\x69\x6e\x74\x2f\x73\x79\x73\x63\x61\x6c\x6c\x73\x2f\x73\x79\x73\x5f\x65\x6e\
\x74\x65\x72\x5f\x66\x75\x74\x65\x78\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\
\x2e\x42\x54\x46\x2e\x65\x78\x74\0\x69\x6e\x69\x74\x69\x61\x6c\x5f\x68\x69\x73\
\x74\0\x73\x74\x61\x72\x74\0\x66\x75\x74\x65\x78\x5f\x65\x78\x69\x74\0\x68\x69\
\x73\x74\x73\0\x2e\x62\x73\x73\0\x2e\x6d\x61\x70\x73\0\x74\x61\x72\x67\x5f\x6d\
\x73\0\x66\x75\x74\x65\x78\x5f\x65\x6e\x74\x65\x72\0\x73\x74\x61\x63\x6b\x6d\
\x61\x70\0\x74\x61\x72\x67\x5f\x6c\x6f\x63\x6b\0\x2e\x6c\x6c\x76\x6d\x5f\x61\
\x64\x64\x72\x73\x69\x67\0\x6c\x69\x63\x65\x6e\x73\x65\0\x74\x61\x72\x67\x5f\
\x74\x69\x64\0\x74\x61\x72\x67\x5f\x70\x69\x64\0\x2e\x73\x74\x72\x74\x61\x62\0\
\x2e\x73\x79\x6d\x74\x61\x62\0\x2e\x72\x6f\x64\x61\x74\x61\0\x2e\x72\x65\x6c\
\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xee\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x04\x27\0\0\0\0\0\0\x17\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x5d\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x39\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x60\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x35\0\0\0\
\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x28\x1f\0\0\0\0\0\0\x40\0\0\0\0\0\
\0\0\x10\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x12\0\0\0\x01\0\0\
\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\x01\0\0\0\0\0\0\x18\x05\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0e\0\0\0\x09\0\0\0\x40\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x68\x1f\0\0\0\0\0\0\x90\0\0\0\0\0\0\0\x10\0\0\0\x05\0\
\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xfe\0\0\0\x01\0\0\0\x02\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xb8\x06\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x99\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xd0\x06\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x94\0\0\0\x08\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x07\0\0\
\0\0\0\0\xc0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xd4\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x07\0\0\0\0\0\0\x04\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0a\x01\0\0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x24\x07\0\0\0\0\0\0\xd5\x0f\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x06\x01\0\0\x09\0\0\0\
\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf8\x1f\0\0\0\0\0\0\xa0\0\0\0\0\0\0\0\x10\0\
\0\0\x0b\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x67\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xfc\x16\0\0\0\0\0\0\xac\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x63\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x98\x20\0\0\0\0\0\0\x60\x06\0\0\0\0\0\0\x10\0\0\0\x0d\0\0\0\x08\0\
\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xc6\0\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\0\
\0\0\0\0\0\0\xf8\x26\0\0\0\0\0\0\x0c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xf6\0\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa8\
\x1d\0\0\0\0\0\0\x80\x01\0\0\0\0\0\0\x01\0\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x18\
\0\0\0\0\0\0\0";
}

#ifdef __cplusplus
struct futexctn_bpf *futexctn_bpf::open(const struct bpf_object_open_opts *opts) { return futexctn_bpf__open_opts(opts); }
struct futexctn_bpf *futexctn_bpf::open_and_load() { return futexctn_bpf__open_and_load(); }
int futexctn_bpf::load(struct futexctn_bpf *skel) { return futexctn_bpf__load(skel); }
int futexctn_bpf::attach(struct futexctn_bpf *skel) { return futexctn_bpf__attach(skel); }
void futexctn_bpf::detach(struct futexctn_bpf *skel) { futexctn_bpf__detach(skel); }
void futexctn_bpf::destroy(struct futexctn_bpf *skel) { futexctn_bpf__destroy(skel); }
const void *futexctn_bpf::elf_bytes(size_t *sz) { return futexctn_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
futexctn_bpf__assert(struct futexctn_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->rodata->targ_summary) == 1, "unexpected size of 'targ_summary'");
	_Static_assert(sizeof(s->rodata->targ_ms) == 1, "unexpected size of 'targ_ms'");
	_Static_assert(sizeof(s->rodata->targ_lock) == 8, "unexpected size of 'targ_lock'");
	_Static_assert(sizeof(s->rodata->targ_pid) == 4, "unexpected size of 'targ_pid'");
	_Static_assert(sizeof(s->rodata->targ_tid) == 4, "unexpected size of 'targ_tid'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __FUTEXCTN_BPF_SKEL_H__ */
