/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import org.graalvm.visualvm.lib.jfluid.results.memory.LivenessMemoryResultsDiff;
import org.graalvm.visualvm.lib.jfluid.results.memory.LivenessMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.ui.components.table.ClassNameTableCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.CustomBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.DiffBarCellRenderer;
import org.graalvm.visualvm.lib.ui.components.table.LabelTableCellRenderer;
import org.graalvm.visualvm.lib.ui.memory.MemoryResUserActionsHandler;
import org.graalvm.visualvm.lib.ui.memory.SnapshotLivenessResultsPanel;

public class DiffLivenessResultsPanel
extends SnapshotLivenessResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM = messages.getString("SnapshotLivenessResultsPanel_GoSourcePopupItem");
    private JMenuItem popupShowSource;
    private JPopupMenu popup;
    private LivenessMemoryResultsDiff diff;

    public DiffLivenessResultsPanel(LivenessMemoryResultsSnapshot snapshot, MemoryResUserActionsHandler actionsHandler, int allocTrackEvery) {
        super(snapshot, actionsHandler, allocTrackEvery);
        this.diff = (LivenessMemoryResultsDiff)snapshot;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupShowSource && this.popupShowSource != null) {
            this.performDefaultAction(-1);
        }
    }

    @Override
    protected CustomBarCellRenderer getBarCellRenderer() {
        return new DiffBarCellRenderer(this.diff.getMinTrackedLiveObjectsSizeDiff(), this.diff.getMaxTrackedLiveObjectsSizeDiff());
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            if (GoToSource.isAvailable()) {
                Font boldfont = this.popup.getFont().deriveFont(1);
                this.popupShowSource = new JMenuItem();
                this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM);
                this.popupShowSource.setFont(boldfont);
                this.popup.add(this.popupShowSource);
                this.popupShowSource.addActionListener(this);
            }
        }
        return this.popup;
    }

    @Override
    protected Object computeValueAt(int row, int col) {
        int index = (Integer)this.filteredToFullIndexes.get(row);
        switch (col) {
            case 0: {
                return this.sortedClassNames[index];
            }
            case 1: {
                return new Long(this.trackedLiveObjectsSize[index]);
            }
            case 2: {
                return (this.trackedLiveObjectsSize[index] > 0L ? "+" : "") + this.intFormat.format(this.trackedLiveObjectsSize[index]) + " B";
            }
            case 3: {
                return (this.nTrackedLiveObjects[index] > 0 ? "+" : "") + this.intFormat.format(this.nTrackedLiveObjects[index]);
            }
            case 4: {
                return (this.nTrackedAllocObjects[index] > 0L ? "+" : "") + this.intFormat.format(this.nTrackedAllocObjects[index]);
            }
            case 5: {
                if (this.avgObjectAge[index] == 0.0f) {
                    return "0.0";
                }
                return (this.avgObjectAge[index] > 0.0f ? "+" : "-") + StringUtils.floatPerCentToString((float)Math.abs(this.avgObjectAge[index]));
            }
            case 6: {
                return (this.maxSurvGen[index] > 0 ? "+" : "") + this.intFormat.format(this.maxSurvGen[index]);
            }
            case 7: {
                return (this.nTotalAllocObjects[index] > 0 ? "+" : "") + this.intFormat.format(this.nTotalAllocObjects[index]);
            }
        }
        return null;
    }

    @Override
    protected void initColumnsData() {
        super.initColumnsData();
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer, labelTableCellRenderer};
    }

    @Override
    protected void initDataUponResultsFetch() {
        super.initDataUponResultsFetch();
        if (this.barRenderer != null) {
            this.barRenderer.setMinimum(this.diff.getMinTrackedLiveObjectsSizeDiff());
            this.barRenderer.setMaximum(this.diff.getMaxTrackedLiveObjectsSizeDiff());
        }
    }

    @Override
    protected boolean passesValueFilter(int i) {
        return true;
    }

    @Override
    protected void performDefaultAction(int classId) {
        String className = null;
        int selectedRow = this.resTable.getSelectedRow();
        if (selectedRow != -1) {
            className = this.resTable.getValueAt(selectedRow, 0).toString().replace("[]", "");
        }
        if (className != null) {
            this.actionsHandler.showSourceForMethod(className, null, null);
        }
    }

    @Override
    protected boolean truncateZeroItems() {
        return false;
    }
}

