/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.netbeans;

import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class JavaDetailsProvider
extends DetailsProvider.Basic {
    private static final String FO_INDEXABLE = "org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable";
    private static final String INDEXABLE = "org.netbeans.modules.parsing.spi.indexing.Indexable";
    private static final String CLASSPATH_ENTRY = "org.netbeans.api.java.classpath.ClassPath$Entry";
    private long lastHeapId;
    private String lastSeparator;

    public JavaDetailsProvider() {
        super(FO_INDEXABLE, INDEXABLE, CLASSPATH_ENTRY);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable": {
                String root = DetailsUtils.getInstanceFieldString(instance, "root");
                String relpath = DetailsUtils.getInstanceFieldString(instance, "relativePath");
                if (root == null || relpath == null) break;
                Heap heap = instance.getJavaClass().getHeap();
                return root.concat(this.getFileSeparator(heap)).concat(relpath);
            }
            case "org.netbeans.modules.parsing.spi.indexing.Indexable": {
                return DetailsUtils.getInstanceFieldString(instance, "delegate");
            }
            case "org.netbeans.api.java.classpath.ClassPath$Entry": {
                return DetailsUtils.getInstanceFieldString(instance, "url");
            }
        }
        return null;
    }

    private String getFileSeparator(Heap heap) {
        if (this.lastHeapId != (long)System.identityHashCode(heap)) {
            this.lastSeparator = heap.getSystemProperties().getProperty("file.separator", "/");
            this.lastHeapId = System.identityHashCode(heap);
        }
        return this.lastSeparator;
    }
}

