/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_2;

import org.mozilla.interfaces.nsIException;
import org.mozilla.interfaces.nsIExceptionManager;
import org.mozilla.interfaces.nsIExceptionService;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;
import org.virtualbox_7_2.IVirtualBoxErrorInfo;

public class VBoxException
extends RuntimeException {
    private int resultCode;
    private IVirtualBoxErrorInfo errorInfo;

    public VBoxException(String string) {
        super(string);
        this.resultCode = -1;
        this.errorInfo = null;
    }

    public VBoxException(String string, Throwable throwable) {
        super(string, throwable);
        if (throwable instanceof XPCOMException) {
            this.resultCode = (int)((XPCOMException)throwable).errorcode;
            try {
                Mozilla mozilla = Mozilla.getInstance();
                nsIServiceManager nsIServiceManager2 = mozilla.getServiceManager();
                nsIExceptionService nsIExceptionService2 = (nsIExceptionService)nsIServiceManager2.getServiceByContractID("@mozilla.org/exceptionservice;1", "{35a88f54-f267-4414-92a7-191f6454ab52}");
                nsIExceptionManager nsIExceptionManager2 = nsIExceptionService2.getCurrentExceptionManager();
                nsIException nsIException2 = nsIExceptionManager2.getCurrentException();
                this.errorInfo = new IVirtualBoxErrorInfo((org.mozilla.interfaces.IVirtualBoxErrorInfo)nsIException2.queryInterface("{c1bcc6d5-7966-481d-ab0b-d0ed73e28135}"));
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                this.errorInfo = null;
            }
        } else {
            this.resultCode = -1;
        }
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public IVirtualBoxErrorInfo getVirtualBoxErrorInfo() {
        return this.errorInfo;
    }
}

