/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.PT;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;

public class V3000Rdr {
    private MolReader mr;
    private String line;
    private BS bsXx;
    private Map<String, String[]> userData;

    V3000Rdr set(AtomSetCollectionReader mr) {
        this.mr = (MolReader)mr;
        return this;
    }

    void readAtomsAndBonds(String[] tokens) throws Exception {
        int ac = this.mr.parseIntStr(tokens[3]);
        this.readAtoms(ac);
        this.mr.asc.setModelInfoForSet("dimension", this.mr.is2D ? "2D" : "3D", this.mr.asc.iSet);
        this.readBonds(this.mr.parseIntStr(tokens[4]));
        this.readUserData(ac);
    }

    private void readAtoms(int ac) throws Exception {
        this.mr.discardLinesUntilContains("BEGIN ATOM");
        for (int i = 0; i < ac; ++i) {
            this.rdContinuation();
            String[] tokens = PT.getTokens(this.line);
            int iAtom = this.mr.parseIntStr(tokens[2]);
            String elementSymbol = tokens[3];
            if (elementSymbol.equals("*")) continue;
            int pt = 3;
            if (elementSymbol.charAt(0) == '\"') {
                while (!tokens[pt].endsWith("\"")) {
                    ++pt;
                }
            }
            float x = this.mr.parseFloatStr(tokens[++pt]);
            float y = this.mr.parseFloatStr(tokens[++pt]);
            float z = this.mr.parseFloatStr(tokens[++pt]);
            int charge = 0;
            int isotope = 0;
            for (int j = ++pt; j < tokens.length; ++j) {
                String s = tokens[j].toUpperCase();
                if (s.startsWith("CHG=")) {
                    charge = this.mr.parseIntAt(tokens[j], 4);
                    continue;
                }
                if (!s.startsWith("MASS=")) continue;
                isotope = this.mr.parseIntAt(tokens[j], 5);
            }
            if (isotope > 1 && elementSymbol.equals("H")) {
                isotope = 1 - isotope;
            }
            Atom a = this.mr.addMolAtom(iAtom, isotope, elementSymbol, charge, x, y, z);
            a.elementNumber = (short)JmolAdapter.getElementNumber(elementSymbol);
            if (a.elementNumber != 0) continue;
            System.err.println("V3000: Could not read elementSymbol for " + this.line);
            if (this.bsXx == null) {
                this.bsXx = new BS();
            }
            this.bsXx.set(a.index);
        }
        this.mr.discardLinesUntilContains("END ATOM");
    }

    private void readBonds(int bondCount) throws Exception {
        this.mr.discardLinesUntilContains("BEGIN BOND");
        if (bondCount == 0) {
            this.mr.asc.setNoAutoBond();
        }
        for (int i = 0; i < bondCount; ++i) {
            int stereo = 0;
            this.rdContinuation();
            String[] tokens = PT.getTokens(this.line);
            int order = this.mr.parseIntStr(tokens[3]);
            String iAtom1 = tokens[4];
            String iAtom2 = tokens[5];
            String cfg = this.getField("CFG");
            if (cfg == null) {
                String endpts = this.getField("ENDPTS");
                if (endpts != null && this.line.indexOf("ATTACH=ALL") >= 0) {
                    tokens = PT.getTokens(endpts);
                    int n = this.mr.parseIntStr(tokens[0]);
                    int o = this.mr.fixOrder(order, 0);
                    for (int k = 1; k <= n; ++k) {
                        Bond b = this.mr.asc.addNewBondFromNames(iAtom1, tokens[k], o);
                        if (this.bsXx == null) continue;
                        this.bsXx.clear(b.atomIndex1);
                        this.bsXx.clear(b.atomIndex2);
                    }
                }
            } else {
                stereo = this.mr.parseIntStr(cfg);
            }
            Bond b = this.mr.addMolBond(iAtom1, iAtom2, order, stereo);
            if (this.bsXx == null) continue;
            this.bsXx.clear(b.atomIndex1);
            this.bsXx.clear(b.atomIndex2);
        }
        if (this.bsXx != null && !this.bsXx.isEmpty()) {
            if (this.mr.bsDeleted == null) {
                this.mr.bsDeleted = new BS();
            }
            this.mr.bsDeleted.or(this.bsXx);
        }
        this.mr.discardLinesUntilContains("END BOND");
    }

    private void readUserData(int ac) throws Exception {
        this.userData = null;
        String pc = null;
        while (!this.rd().contains("END CTAB")) {
            if (!this.line.contains("BEGIN SGROUP")) continue;
            while (!this.rdContinuation().contains("END SGROUP")) {
                boolean isPartial;
                String data;
                String name;
                String atoms;
                if (this.userData == null) {
                    this.userData = new Hashtable<String, String[]>();
                }
                if ((atoms = this.getField("ATOMS")) == null || (name = this.getField("FIELDNAME")) == null || (data = this.getField("FIELDDATA")) == null) continue;
                boolean bl = isPartial = (name = name.toLowerCase()).indexOf("partial") >= 0;
                if (isPartial) {
                    if (pc == null) {
                        pc = name;
                    } else if (!pc.equals(name)) {
                        isPartial = false;
                    }
                }
                if (isPartial) {
                    Atom[] at = this.mr.asc.atoms;
                    int n = this.mr.asc.ac;
                    for (int i = this.mr.asc.getLastAtomSetAtomIndex(); i < n; ++i) {
                        at[i].partialCharge = 0.0f;
                    }
                }
                String[] a = null;
                float f = 0.0f;
                if (isPartial) {
                    f = this.mr.parseFloatStr(data);
                } else {
                    a = this.userData.get(name);
                    if (a == null) {
                        a = new String[ac];
                        this.userData.put(name, a);
                    }
                }
                try {
                    String[] tokens = PT.getTokens(atoms);
                    int i = tokens.length;
                    while (--i >= 1) {
                        String atom = tokens[i];
                        if (isPartial) {
                            this.mr.asc.getAtomFromName((String)atom).partialCharge = f;
                            continue;
                        }
                        a[this.mr.parseIntStr((String)atom) - 1] = data;
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        if (this.userData == null) {
            return;
        }
        for (String key : this.userData.keySet()) {
            String[] a = this.userData.get(key);
            float[] f = new float[a.length];
            for (int i = 0; i < a.length; ++i) {
                f[i] = a[i] == null ? 0.0f : this.mr.parseFloatStr(a[i]);
            }
            this.mr.asc.setAtomProperties(key, f, -1, false);
        }
    }

    private String getField(String key) {
        int pt = this.line.indexOf(key + "=");
        if (pt < 0) {
            return null;
        }
        char term = ' ';
        switch (this.line.charAt(pt += key.length() + 1)) {
            case '\"': {
                term = '\"';
                break;
            }
            case '(': {
                term = ')';
                break;
            }
            case '+': {
                break;
            }
            default: {
                --pt;
            }
        }
        return this.line.substring(pt + 1, (this.line + term).indexOf(term, pt + 1));
    }

    private String rd() throws Exception {
        this.line = this.mr.rd();
        return this.line;
    }

    private String rdContinuation() throws Exception {
        this.rd();
        while (this.line.endsWith("-")) {
            this.line = this.line.substring(0, this.line.length() - 1) + this.rd().substring(7);
        }
        return this.line;
    }
}

