/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.info;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DB2XMLString
implements DBSObject {
    private DB2DataSource dataSource;
    private Integer stringId;
    private String string;
    private String stringUTF8;

    public DB2XMLString(DB2DataSource dataSource, ResultSet dbResult) {
        this.dataSource = dataSource;
        this.stringId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"STRINGID");
        this.string = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STRING");
        this.stringUTF8 = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STRING_UTF8");
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return false;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.stringId.toString();
    }

    @Property(viewable=true, order=2)
    public String getString() {
        return this.string;
    }

    @Property(viewable=false, order=3)
    public String getStringUTF8() {
        return this.stringUTF8;
    }
}

