/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.UsageMarker;

public class AnnotationUsageMarker
extends SimplifiedVisitor
implements AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor,
ConstantVisitor,
ClassVisitor,
MemberVisitor {
    private final UsageMarker usageMarker;
    private boolean attributeUsed;
    private boolean annotationUsed;
    private boolean allClassesUsed;
    private boolean methodUsed;

    public AnnotationUsageMarker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        this.attributeUsed = false;
        annotationsAttribute.annotationsAccept(clazz, this);
        if (this.attributeUsed) {
            this.usageMarker.markAsUsed(annotationsAttribute);
            this.markConstant(clazz, annotationsAttribute.u2attributeNameIndex);
        }
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        this.attributeUsed = false;
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
        if (this.attributeUsed) {
            this.usageMarker.markAsUsed(parameterAnnotationsAttribute);
            this.markConstant(clazz, parameterAnnotationsAttribute.u2attributeNameIndex);
        }
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
        this.usageMarker.markAsUsed(annotationDefaultAttribute);
        this.markConstant(clazz, annotationDefaultAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        if (this.isReferencedClassUsed(annotation)) {
            this.usageMarker.markAsUsed(annotation);
            this.markConstant(clazz, annotation.u2typeIndex);
            annotation.elementValuesAccept(clazz, this);
            this.annotationUsed = true;
            this.attributeUsed = true;
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        if (this.isReferencedMethodUsed(constantElementValue)) {
            this.usageMarker.markAsUsed(constantElementValue);
            this.markConstant(clazz, constantElementValue.u2elementNameIndex);
            this.markConstant(clazz, constantElementValue.u2constantValueIndex);
        }
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        if (this.isReferencedMethodUsed(enumConstantElementValue)) {
            this.allClassesUsed = true;
            enumConstantElementValue.referencedClassesAccept(this);
            if (this.allClassesUsed) {
                this.usageMarker.markAsUsed(enumConstantElementValue);
                this.markConstant(clazz, enumConstantElementValue.u2elementNameIndex);
                this.markConstant(clazz, enumConstantElementValue.u2typeNameIndex);
                this.markConstant(clazz, enumConstantElementValue.u2constantNameIndex);
            }
        }
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        if (this.isReferencedMethodUsed(classElementValue)) {
            this.usageMarker.markAsUsed(classElementValue);
            this.markConstant(clazz, classElementValue.u2elementNameIndex);
            this.markConstant(clazz, classElementValue.u2classInfoIndex);
            classElementValue.referencedClassesAccept(this.usageMarker);
        }
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        if (this.isReferencedMethodUsed(annotationElementValue)) {
            boolean oldAnnotationUsed = this.annotationUsed;
            this.annotationUsed = false;
            annotationElementValue.annotationAccept(clazz, this);
            if (this.annotationUsed) {
                this.usageMarker.markAsUsed(annotationElementValue);
                this.markConstant(clazz, annotationElementValue.u2elementNameIndex);
            }
            this.annotationUsed = oldAnnotationUsed;
        }
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        if (this.isReferencedMethodUsed(arrayElementValue)) {
            arrayElementValue.elementValuesAccept(clazz, annotation, this);
            this.usageMarker.markAsUsed(arrayElementValue);
            this.markConstant(clazz, arrayElementValue.u2elementNameIndex);
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.usageMarker.markAsUsed(constant);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (!this.usageMarker.isUsed(classConstant)) {
            this.allClassesUsed = true;
            classConstant.referencedClassAccept(this);
            if (this.allClassesUsed) {
                this.usageMarker.markAsUsed(classConstant);
                this.markConstant(clazz, classConstant.u2nameIndex);
            }
        }
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.allClassesUsed &= this.usageMarker.isUsed(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.methodUsed = this.usageMarker.isUsed(programMethod);
    }

    @Override
    public void visitLibraryMethod(LibraryClass LibraryClass2, LibraryMethod libraryMethod) {
    }

    private boolean isReferencedClassUsed(Annotation annotation) {
        this.allClassesUsed = true;
        annotation.referencedClassAccept(this);
        return this.allClassesUsed;
    }

    private boolean isReferencedMethodUsed(ElementValue elementValue) {
        this.methodUsed = true;
        elementValue.referencedMethodAccept(this);
        return this.methodUsed;
    }

    private void markConstant(Clazz clazz, int index) {
        if (index > 0) {
            clazz.constantPoolEntryAccept(index, this);
        }
    }
}

