// ClientServer wrapper for vtkPVRenderViewDataDeliveryManager object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPVRenderViewDataDeliveryManager.h"
#include "vtkSystemIncludes.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkPVRenderViewDataDeliveryManagerClientServerNewCommand(void* /*ctx*/)
{
  return vtkPVRenderViewDataDeliveryManager::New();
}


static int vtkPVRenderViewDataDeliveryManagerCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkPVRenderViewDataDeliveryManager *op = vtkPVRenderViewDataDeliveryManager::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkPVRenderViewDataDeliveryManager.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkPVRenderViewDataDeliveryManager  *temp20;
      {
      temp20 = vtkPVRenderViewDataDeliveryManager::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkPVRenderViewDataDeliveryManager::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkPVRenderViewDataDeliveryManager  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkPVRenderViewDataDeliveryManager::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkPVRenderViewDataDeliveryManager  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkPVRenderViewDataDeliveryManager::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetDeliverToAllProcesses",method) && msg.GetNumberOfArguments(0) == 6)
    {
    vtkPVDataRepresentation  *temp0;
    bool   temp1;
    bool   temp2;
    int      temp3;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->SetDeliverToAllProcesses(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("SetDeliverToClientAndRenderingProcesses",method) && msg.GetNumberOfArguments(0) == 7)
    {
    vtkPVDataRepresentation  *temp0;
    bool   temp1;
    bool   temp2;
    bool   temp3;
    int      temp4;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2) &&
      msg.GetArgument(0, 5, &temp3) &&
      msg.GetArgument(0, 6, &temp4))
      {
      op->SetDeliverToClientAndRenderingProcesses(temp0,temp1,temp2,temp3,temp4);
      return 1;
      }
    }
  if (!strcmp("SetRedistributionMode",method) && msg.GetNumberOfArguments(0) == 5)
    {
    vtkPVDataRepresentation  *temp0;
    int      temp1;
    int      temp2;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2))
      {
      op->SetRedistributionMode(temp0,temp1,temp2);
      return 1;
      }
    }
  if (!strcmp("SetRedistributionModeToSplitBoundaryCells",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkPVDataRepresentation  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetRedistributionModeToSplitBoundaryCells(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("SetRedistributionModeToDuplicateBoundaryCells",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkPVDataRepresentation  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetRedistributionModeToDuplicateBoundaryCells(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("SetRedistributionModeToUniquelyAssignBoundaryCells",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkPVDataRepresentation  *temp0;
    int      temp1;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1))
      {
      op->SetRedistributionModeToUniquelyAssignBoundaryCells(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("RedistributeDataForOrderedCompositing",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->RedistributeDataForOrderedCompositing(temp0);
      return 1;
      }
    }
  if (!strcmp("ClearRedistributedData",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->ClearRedistributedData(temp0);
      return 1;
      }
    }
  if (!strcmp("SetOrderedCompositingConfiguration",method) && msg.GetNumberOfArguments(0) == 6)
    {
    vtkPVDataRepresentation  *temp0;
    int      temp1;
    vtkClientServerStreamDataArg<double > temp2(msg, 0, 4);
    int      temp3;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1) &&
      temp2 &&
      msg.GetArgument(0, 5, &temp3))
      {
      op->SetOrderedCompositingConfiguration(temp0,temp1,temp2,temp3);
      return 1;
      }
    }
  if (!strcmp("SetStreamable",method) && msg.GetNumberOfArguments(0) == 5)
    {
    vtkPVDataRepresentation  *temp0;
    bool   temp1;
    int      temp2;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1) &&
      msg.GetArgument(0, 4, &temp2))
      {
      op->SetStreamable(temp0,temp1,temp2);
      return 1;
      }
    }
  if (!strcmp("SetNextStreamedPiece",method) && msg.GetNumberOfArguments(0) == 5)
    {
    vtkPVDataRepresentation  *temp0;
    vtkDataObject  *temp1;
    int      temp2;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      vtkClientServerStreamGetArgumentObject(msg, 0, 3, &temp1, "vtkDataObject") &&
      msg.GetArgument(0, 4, &temp2))
      {
      op->SetNextStreamedPiece(temp0,temp1,temp2);
      return 1;
      }
    }
  if (!strcmp("GetCurrentStreamedPiece",method) && msg.GetNumberOfArguments(0) == 4)
    {
    vtkPVDataRepresentation  *temp0;
    int      temp1;
    vtkDataObject  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkPVDataRepresentation") &&
      msg.GetArgument(0, 3, &temp1))
      {
      temp20 = (op)->GetCurrentStreamedPiece(temp0,temp1);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("ClearStreamedPieces",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->ClearStreamedPieces();
      return 1;
      }
    }
  if (!strcmp("DeliverStreamedPieces",method) && msg.GetNumberOfArguments(0) == 4)
    {
    unsigned int      temp0;
    vtkClientServerStreamDataArg<unsigned int    > temp1(msg, 0, 3);
    if(msg.GetArgument(0, 2, &temp0) &&
      temp1)
      {
      op->DeliverStreamedPieces(temp0,temp1);
      return 1;
      }
    }
  if (!strcmp("GetUseRedistributedDataAsDeliveredData",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetUseRedistributedDataAsDeliveredData();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetUseRedistributedDataAsDeliveredData",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetUseRedistributedDataAsDeliveredData(temp0);
      return 1;
      }
    }
  if (!strcmp("GetDeliveredDataKey",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetDeliveredDataKey(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }

  {
    const char* commandName = "vtkPVDataDeliveryManager";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkPVRenderViewDataDeliveryManager, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkPVRenderViewDataDeliveryManager_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkPVRenderViewDataDeliveryManager", vtkPVRenderViewDataDeliveryManagerClientServerNewCommand);
    csi->AddCommandFunction("vtkPVRenderViewDataDeliveryManager", vtkPVRenderViewDataDeliveryManagerCommand);
    }
}
}
