/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.degrade;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.ExceptionCircuitBreaker;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.ResponseTimeCircuitBreaker;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DegradeRuleManager {
    private static volatile Map<String, List<CircuitBreaker>> circuitBreakers = new HashMap<String, List<CircuitBreaker>>();
    private static volatile Map<String, Set<DegradeRule>> ruleMap = new HashMap<String, Set<DegradeRule>>();
    private static final RulePropertyListener LISTENER = new RulePropertyListener();
    private static SentinelProperty<List<DegradeRule>> currentProperty = new DynamicSentinelProperty<List<DegradeRule>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<DegradeRule>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        RulePropertyListener rulePropertyListener = LISTENER;
        synchronized (rulePropertyListener) {
            RecordLog.info("[DegradeRuleManager] Registering new property to degrade rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    static List<CircuitBreaker> getCircuitBreakers(String resourceName) {
        return circuitBreakers.get(resourceName);
    }

    public static boolean hasConfig(String resource) {
        if (resource == null) {
            return false;
        }
        return circuitBreakers.containsKey(resource);
    }

    public static List<DegradeRule> getRules() {
        ArrayList<DegradeRule> rules = new ArrayList<DegradeRule>();
        for (Map.Entry<String, Set<DegradeRule>> entry : ruleMap.entrySet()) {
            rules.addAll((Collection<DegradeRule>)entry.getValue());
        }
        return rules;
    }

    public static Set<DegradeRule> getRulesOfResource(String resource) {
        AssertUtil.assertNotBlank(resource, "resource name cannot be blank");
        return ruleMap.get(resource);
    }

    public static void loadRules(List<DegradeRule> rules) {
        try {
            currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.error("[DegradeRuleManager] Unexpected error when loading degrade rules", e);
        }
    }

    public static boolean setRulesForResource(String resourceName, Set<DegradeRule> rules) {
        AssertUtil.notEmpty(resourceName, "resourceName cannot be empty");
        try {
            HashMap<String, Set<DegradeRule>> newRuleMap = new HashMap<String, Set<DegradeRule>>(ruleMap);
            if (rules == null) {
                newRuleMap.remove(resourceName);
            } else {
                HashSet<DegradeRule> newSet = new HashSet<DegradeRule>();
                for (DegradeRule rule : rules) {
                    if (!DegradeRuleManager.isValidRule(rule) || !resourceName.equals(rule.getResource())) continue;
                    newSet.add(rule);
                }
                newRuleMap.put(resourceName, newSet);
            }
            ArrayList allRules = new ArrayList();
            for (Set set : newRuleMap.values()) {
                allRules.addAll(set);
            }
            return currentProperty.updateValue(allRules);
        }
        catch (Throwable e) {
            RecordLog.error("[DegradeRuleManager] Unexpected error when setting circuit breaking rules for resource: " + resourceName, e);
            return false;
        }
    }

    private static CircuitBreaker getExistingSameCbOrNew(DegradeRule rule) {
        List<CircuitBreaker> cbs = DegradeRuleManager.getCircuitBreakers(rule.getResource());
        if (cbs == null || cbs.isEmpty()) {
            return DegradeRuleManager.newCircuitBreakerFrom(rule);
        }
        for (CircuitBreaker cb : cbs) {
            if (!rule.equals(cb.getRule())) continue;
            return cb;
        }
        return DegradeRuleManager.newCircuitBreakerFrom(rule);
    }

    private static CircuitBreaker newCircuitBreakerFrom(DegradeRule rule) {
        switch (rule.getGrade()) {
            case 0: {
                return new ResponseTimeCircuitBreaker(rule);
            }
            case 1: 
            case 2: {
                return new ExceptionCircuitBreaker(rule);
            }
        }
        return null;
    }

    public static boolean isValidRule(DegradeRule rule) {
        boolean baseValid;
        boolean bl = baseValid = rule != null && !StringUtil.isBlank(rule.getResource()) && rule.getCount() >= 0.0 && rule.getTimeWindow() > 0;
        if (!baseValid) {
            return false;
        }
        if (rule.getMinRequestAmount() <= 0 || rule.getStatIntervalMs() <= 0) {
            return false;
        }
        switch (rule.getGrade()) {
            case 0: {
                return rule.getSlowRatioThreshold() >= 0.0 && rule.getSlowRatioThreshold() <= 1.0;
            }
            case 1: {
                return rule.getCount() <= 1.0;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static class RulePropertyListener
    implements PropertyListener<List<DegradeRule>> {
        private RulePropertyListener() {
        }

        private synchronized void reloadFrom(List<DegradeRule> list) {
            Map<String, List<CircuitBreaker>> cbs = this.buildCircuitBreakers(list);
            HashMap rm = new HashMap(cbs.size());
            for (Map.Entry<String, List<CircuitBreaker>> e : cbs.entrySet()) {
                assert (e.getValue() != null && !e.getValue().isEmpty());
                HashSet<DegradeRule> rules = new HashSet<DegradeRule>(e.getValue().size());
                for (CircuitBreaker cb : e.getValue()) {
                    rules.add(cb.getRule());
                }
                rm.put(e.getKey(), rules);
            }
            circuitBreakers = cbs;
            ruleMap = rm;
        }

        @Override
        public void configUpdate(List<DegradeRule> conf) {
            this.reloadFrom(conf);
            RecordLog.info("[DegradeRuleManager] Degrade rules has been updated to: {}", ruleMap);
        }

        @Override
        public void configLoad(List<DegradeRule> conf) {
            this.reloadFrom(conf);
            RecordLog.info("[DegradeRuleManager] Degrade rules loaded: {}", ruleMap);
        }

        private Map<String, List<CircuitBreaker>> buildCircuitBreakers(List<DegradeRule> list) {
            HashMap<String, List<CircuitBreaker>> cbMap = new HashMap<String, List<CircuitBreaker>>(8);
            if (list == null || list.isEmpty()) {
                return cbMap;
            }
            for (DegradeRule rule : list) {
                CircuitBreaker cb;
                if (!DegradeRuleManager.isValidRule(rule)) {
                    RecordLog.warn("[DegradeRuleManager] Ignoring invalid rule when loading new rules: {}", rule);
                    continue;
                }
                if (StringUtil.isBlank(rule.getLimitApp())) {
                    rule.setLimitApp("default");
                }
                if ((cb = DegradeRuleManager.getExistingSameCbOrNew(rule)) == null) {
                    RecordLog.warn("[DegradeRuleManager] Unknown circuit breaking strategy, ignoring: {}", rule);
                    continue;
                }
                String resourceName = rule.getResource();
                ArrayList<CircuitBreaker> cbList = (ArrayList<CircuitBreaker>)cbMap.get(resourceName);
                if (cbList == null) {
                    cbList = new ArrayList<CircuitBreaker>();
                    cbMap.put(resourceName, cbList);
                }
                cbList.add(cb);
            }
            return cbMap;
        }
    }
}

