/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static boolean isIPAddr(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            return false;
        }
        try {
            String[] tokens = ipAddress.split("\\.");
            if (tokens.length != 4) {
                return false;
            }
            for (String token : tokens) {
                int i = Integer.parseInt(token);
                if (i >= 0 && i <= 255) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getLocalMachineIP() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String ipAddress;
                    InetAddress address = addresses.nextElement();
                    if (address.isLinkLocalAddress() || address.getHostAddress() == null || (ipAddress = address.getHostAddress()).equals("127.0.0.1") || !NetworkUtils.isIPAddr(ipAddress)) continue;
                    return ipAddress;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }
}

