/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_ruleset;

import co.elastic.clients.elasticsearch.query_ruleset.QueryRuleActions;
import co.elastic.clients.elasticsearch.query_ruleset.QueryRuleCriteria;
import co.elastic.clients.elasticsearch.query_ruleset.QueryRuleType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class QueryRule
implements JsonpSerializable {
    private final String ruleId;
    private final QueryRuleType type;
    private final List<QueryRuleCriteria> criteria;
    private final QueryRuleActions actions;
    public static final JsonpDeserializer<QueryRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRule::setupQueryRuleDeserializer);

    private QueryRule(Builder builder) {
        this.ruleId = ApiTypeHelper.requireNonNull(builder.ruleId, this, "ruleId");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.criteria = ApiTypeHelper.unmodifiableRequired(builder.criteria, (Object)this, "criteria");
        this.actions = ApiTypeHelper.requireNonNull(builder.actions, this, "actions");
    }

    public static QueryRule of(Function<Builder, ObjectBuilder<QueryRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final QueryRuleType type() {
        return this.type;
    }

    public final List<QueryRuleCriteria> criteria() {
        return this.criteria;
    }

    public final QueryRuleActions actions() {
        return this.actions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rule_id");
        generator.write(this.ruleId);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.criteria)) {
            generator.writeKey("criteria");
            generator.writeStartArray();
            for (QueryRuleCriteria item0 : this.criteria) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("actions");
        this.actions.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryRuleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ruleId, JsonpDeserializer.stringDeserializer(), "rule_id");
        op.add(Builder::type, QueryRuleType._DESERIALIZER, "type");
        op.add(Builder::criteria, JsonpDeserializer.arrayDeserializer(QueryRuleCriteria._DESERIALIZER), "criteria");
        op.add(Builder::actions, QueryRuleActions._DESERIALIZER, "actions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryRule> {
        private String ruleId;
        private QueryRuleType type;
        private List<QueryRuleCriteria> criteria;
        private QueryRuleActions actions;

        public final Builder ruleId(String value) {
            this.ruleId = value;
            return this;
        }

        public final Builder type(QueryRuleType value) {
            this.type = value;
            return this;
        }

        public final Builder criteria(List<QueryRuleCriteria> list) {
            this.criteria = Builder._listAddAll(this.criteria, list);
            return this;
        }

        public final Builder criteria(QueryRuleCriteria value, QueryRuleCriteria ... values) {
            this.criteria = Builder._listAdd(this.criteria, value, values);
            return this;
        }

        public final Builder criteria(Function<QueryRuleCriteria.Builder, ObjectBuilder<QueryRuleCriteria>> fn) {
            return this.criteria(fn.apply(new QueryRuleCriteria.Builder()).build(), new QueryRuleCriteria[0]);
        }

        public final Builder actions(QueryRuleActions value) {
            this.actions = value;
            return this;
        }

        public final Builder actions(Function<QueryRuleActions.Builder, ObjectBuilder<QueryRuleActions>> fn) {
            return this.actions(fn.apply(new QueryRuleActions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRule build() {
            this._checkSingleUse();
            return new QueryRule(this);
        }
    }
}

