/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.ScaleRuleMapper;
import org.apache.shenyu.admin.model.dto.ScaleRuleDTO;
import org.apache.shenyu.admin.model.entity.ScaleRuleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ScaleRuleQuery;
import org.apache.shenyu.admin.model.vo.ScaleRuleVO;
import org.apache.shenyu.admin.scale.monitor.subject.cache.ScaleRuleCache;
import org.apache.shenyu.admin.service.ScaleRuleService;
import org.apache.shenyu.common.utils.ListUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScaleRuleServiceImpl
implements ScaleRuleService {
    private final ScaleRuleMapper scaleRuleMapper;
    private final ScaleRuleCache scaleRuleCache;

    public ScaleRuleServiceImpl(ScaleRuleMapper scaleRuleMapper, ScaleRuleCache scaleRuleCache) {
        this.scaleRuleMapper = scaleRuleMapper;
        this.scaleRuleCache = scaleRuleCache;
    }

    @Override
    public List<ScaleRuleVO> selectAll() {
        return ListUtil.map(this.scaleRuleMapper.selectAll(), ScaleRuleVO::buildScaleRuleVO);
    }

    @Override
    @Pageable
    public CommonPager<ScaleRuleVO> listByPage(ScaleRuleQuery scaleRuleQuery) {
        return PageResultUtils.result(scaleRuleQuery.getPageParameter(), () -> this.scaleRuleMapper.selectByQuery(scaleRuleQuery).stream().map(ScaleRuleVO::buildScaleRuleVO).collect(Collectors.toList()));
    }

    @Override
    public ScaleRuleVO findById(String id) {
        return ScaleRuleVO.buildScaleRuleVO(this.scaleRuleMapper.selectByPrimaryKey(id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(ScaleRuleDTO scaleRuleDTO) {
        return ScaleRuleService.super.createOrUpdate(scaleRuleDTO);
    }

    @Override
    public int create(ScaleRuleDTO scaleRuleDTO) {
        ScaleRuleDO scaleRuleDO = ScaleRuleDO.buildScaleRuleDO(scaleRuleDTO);
        int rows = this.scaleRuleMapper.insertSelective(scaleRuleDO);
        if (rows > 0) {
            this.scaleRuleCache.addOrUpdateRuleToCache(ScaleRuleDO.buildScaleRuleDO(scaleRuleDTO));
        }
        return rows;
    }

    @Override
    public int update(ScaleRuleDTO scaleRuleDTO) {
        ScaleRuleDO after = ScaleRuleDO.buildScaleRuleDO(scaleRuleDTO);
        int rows = this.scaleRuleMapper.updateByPrimaryKey(after);
        if (rows > 0) {
            this.scaleRuleCache.addOrUpdateRuleToCache(ScaleRuleDO.buildScaleRuleDO(scaleRuleDTO));
        }
        return rows;
    }

    @Override
    public int delete(List<String> ids) {
        int rows = this.scaleRuleMapper.delete(ids);
        if (rows > 0) {
            this.scaleRuleCache.removeRulesFromCache(ids);
        }
        return rows;
    }
}

