/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation;

import java.util.Map;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.InvocationRuntimeType;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.provider.consumer.ReferenceConfig;
import org.springframework.core.env.Environment;

public final class InvocationFactory {
    private InvocationFactory() {
    }

    public static Invocation forConsumer(ReferenceConfig referenceConfig, OperationMeta operationMeta, InvocationRuntimeType invocationRuntimeType, Map<String, Object> swaggerArguments) {
        Invocation invocation = new Invocation(referenceConfig, operationMeta, invocationRuntimeType, swaggerArguments);
        return InvocationFactory.setSrcMicroservice(invocation);
    }

    public static Invocation setSrcMicroservice(Invocation invocation) {
        invocation.addContext("x-cse-src-microservice", BootStrapProperties.readServiceName((Environment)SCBEngine.getInstance().getEnvironment()));
        if (InvocationFactory.addSourceServiceId()) {
            invocation.addContext("x-src-serviceId", SCBEngine.getInstance().getRegistrationManager().getServiceId("sc-registration"));
        }
        if (InvocationFactory.addSourceInstanceId()) {
            invocation.addContext("x-src-instanceId", SCBEngine.getInstance().getRegistrationManager().getInstanceId("sc-registration"));
        }
        return invocation;
    }

    public static boolean addSourceServiceId() {
        return (Boolean)SCBEngine.getInstance().getEnvironment().getProperty("servicecomb.context.source.serviceId", Boolean.TYPE, (Object)true);
    }

    public static boolean addSourceInstanceId() {
        return (Boolean)SCBEngine.getInstance().getEnvironment().getProperty("servicecomb.context.source.instanceId", Boolean.TYPE, (Object)true);
    }

    public static Invocation forProvider(Endpoint endpoint, OperationMeta operationMeta, Map<String, Object> swaggerArguments) {
        SCBEngine.getInstance().ensureStatusUp();
        return new Invocation(endpoint, operationMeta, swaggerArguments);
    }
}

