/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.annotation;

import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;
import org.apache.servicecomb.swagger.generator.springmvc.processor.annotation.SpringmvcParameterAnnotationsProcessor;
import org.springframework.web.bind.annotation.RequestParam;

public class RequestParamParameterProcessor
extends SpringmvcParameterAnnotationsProcessor<RequestParam> {
    public Type getProcessType() {
        return RequestParam.class;
    }

    public String getParameterName(RequestParam annotation) {
        String value = annotation.value();
        if (value.isEmpty()) {
            value = annotation.name();
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return value;
        }
        return null;
    }

    public void process(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, ParameterGenerator parameterGenerator, RequestParam annotation) {
        parameterGenerator.setHttpParameterType(HttpParameterType.QUERY);
        if (StringUtils.isNotEmpty((CharSequence)this.getParameterName(annotation))) {
            parameterGenerator.getParameterGeneratorContext().setParameterName(this.getParameterName(annotation));
        }
        parameterGenerator.getParameterGeneratorContext().setRequired(Boolean.valueOf(annotation.required()));
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(annotation.defaultValue())) {
            parameterGenerator.getParameterGeneratorContext().setDefaultValue((Object)annotation.defaultValue());
            parameterGenerator.getParameterGeneratorContext().setRequired(Boolean.valueOf(false));
        }
    }
}

