/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.invocation.timeout;

import com.google.common.base.Ticker;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.invocation.InvocationTimeoutStrategy;
import org.springframework.stereotype.Component;

@Component
public class ProcessingTimeStrategy
implements InvocationTimeoutStrategy {
    public static final String NAME = "processing-time";
    public static final String CHAIN_START_TIME = "x-scb-process-chain-start";
    public static final String CHAIN_PROCESSING = "x-scb-processing-time";
    private Ticker ticker = Ticker.systemTicker();

    public ProcessingTimeStrategy setTicker(Ticker ticker) {
        this.ticker = ticker;
        return this;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void start(Invocation invocation) {
        this.initProcessChainStart(invocation);
        this.initChainProcessing(invocation);
    }

    private void initProcessChainStart(Invocation invocation) {
        if (invocation.getLocalContext(CHAIN_START_TIME) != null) {
            return;
        }
        invocation.addLocalContext(CHAIN_START_TIME, invocation.getInvocationStageTrace().getStart());
    }

    private void initChainProcessing(Invocation invocation) {
        if (invocation.getLocalContext(CHAIN_PROCESSING) != null) {
            return;
        }
        String contextChainProcessing = invocation.getContext(CHAIN_PROCESSING);
        long chainProcessingTime = NumberUtils.toLong((String)contextChainProcessing, (long)0L);
        invocation.addLocalContext(CHAIN_PROCESSING, chainProcessingTime);
    }

    @Override
    public void beforeSendRequest(Invocation invocation) {
        InvocationTimeoutStrategy.super.beforeSendRequest(invocation);
        long processingTime = this.calculateElapsedNanoTime(invocation);
        invocation.addContext(CHAIN_PROCESSING, Long.toString(processingTime));
    }

    @Override
    public long calculateElapsedNanoTime(Invocation invocation) {
        long chainStartTime = (Long)invocation.getLocalContext(CHAIN_START_TIME);
        long previousProcessingTime = (Long)invocation.getLocalContext(CHAIN_PROCESSING);
        return this.ticker.read() - chainStartTime + previousProcessingTime;
    }
}

