/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.definition.path;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathRegExp {
    private static final String DEFAULT_REG_EXP = "[^/]+?";
    private static final byte NAME_READ = 2;
    private static final byte NAME_READ_READY = 3;
    private static final byte NAME_READ_START = 1;
    private static final byte REGEXP_READ = 12;
    private static final byte REGEXP_READ_READY = 13;
    private static final byte REGEXP_READ_START = 11;
    public static final String SLASH = "/";
    protected int staticCharCount;
    protected int groupCount;
    protected int groupWithRegExpCount = 0;
    protected final Pattern pattern;
    protected final List<String> varNames = new ArrayList<String>();

    public static String ensureEndWithSlash(String path) {
        if (path.endsWith(SLASH)) {
            return path;
        }
        return path + SLASH;
    }

    public PathRegExp(String path) throws Exception {
        int pathLength = path.length();
        StringBuilder pathPattern = new StringBuilder();
        block5: for (int i = 0; i < pathLength; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '{': {
                    i = this.processGroup(path, i, pathPattern);
                    ++this.groupCount;
                    continue block5;
                }
                case '}': {
                    throw new Exception("'}' is only allowed as end of a variable name in \"" + path + "\"");
                }
                case ';': {
                    throw new Exception("matrix parameters are not allowed in \"" + path + "\"");
                }
                default: {
                    pathPattern.append(c);
                    ++this.staticCharCount;
                }
            }
        }
        if (pathPattern.length() > 0 && pathPattern.charAt(pathPattern.length() - 1) != '/') {
            pathPattern.append('/');
        }
        pathPattern.append("(.*)");
        this.pattern = Pattern.compile(pathPattern.toString());
    }

    protected int processGroup(String path, int braceIndex, StringBuilder pathPattern) throws Exception {
        pathPattern.append('(');
        int pathLength = path.length();
        StringBuilder varName = new StringBuilder();
        StringBuilder regExp = new StringBuilder();
        int state = 1;
        block6: for (int i = braceIndex + 1; i < pathLength; ++i) {
            char c = path.charAt(i);
            switch (c) {
                case '{': {
                    throw new Exception("A variable must not contain an extra '{' in \"" + path + "\"");
                }
                case '\t': 
                case ' ': {
                    state = this.processLineBreak(state);
                    continue block6;
                }
                case ':': {
                    state = this.processColon(path, braceIndex, state);
                    continue block6;
                }
                case '}': {
                    this.processBrace(path, pathPattern, varName, regExp, state);
                    return i;
                }
                default: {
                    state = this.processDefault(path, varName, regExp, state, i, c);
                }
            }
        }
        throw new Exception("No '}' found after '{' at position " + braceIndex + " of \"" + path + "\"");
    }

    private int processDefault(String path, StringBuilder varName, StringBuilder regExp, int state, int i, char c) throws Exception {
        if (state == 1) {
            state = 2;
            varName.append(c);
        } else if (state == 2) {
            varName.append(c);
        } else if (state == 11) {
            state = 12;
            regExp.append(c);
        } else if (state == 12) {
            regExp.append(c);
        } else {
            throw new Exception("Invalid character found at position " + i + " of \"" + path + "\"");
        }
        return state;
    }

    private void processBrace(String path, StringBuilder pathPattern, StringBuilder varName, StringBuilder regExp, int state) throws Exception {
        if (state == 1) {
            throw new Exception("The template variable name '{}' is not allowed in \"" + path + "\"");
        }
        if (state == 12 || state == 13) {
            pathPattern.append((CharSequence)regExp);
            if (!regExp.toString().equals(DEFAULT_REG_EXP)) {
                ++this.groupWithRegExpCount;
            }
        } else {
            pathPattern.append(DEFAULT_REG_EXP);
        }
        pathPattern.append(')');
        this.varNames.add(varName.toString());
    }

    private int processColon(String path, int braceIndex, int state) throws Exception {
        if (state == 1) {
            throw new Exception("The variable name at position must not be null at " + braceIndex + " of \"" + path + "\"");
        }
        if (state == 2 || state == 3) {
            state = 11;
        }
        return state;
    }

    private int processLineBreak(int state) {
        if (state == 2) {
            state = 3;
        } else if (state == 12) {
            state = 13;
        }
        return state;
    }

    public String match(String path, Map<String, String> varValues) {
        Matcher matcher = this.pattern.matcher(path);
        if (!matcher.matches()) {
            return null;
        }
        for (int i = 1; i < matcher.groupCount(); ++i) {
            varValues.put(this.varNames.get(i - 1), matcher.group(i));
        }
        return matcher.group(matcher.groupCount());
    }

    public String toString() {
        return this.pattern.pattern();
    }

    public boolean isStaticPath() {
        return this.groupCount == 0;
    }

    public int getStaticCharCount() {
        return this.staticCharCount;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public int getGroupWithRegExpCount() {
        return this.groupWithRegExpCount;
    }
}

