/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHttpServerLifecycle
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHttpServerLifecycle.class);

    private void assertAlive(HttpServer server) {
        TestHttpServerLifecycle.assertTrue((String)"Server is not alive", (boolean)server.isAlive());
        this.assertToStringContains(server, " - alive");
    }

    private void assertNotLive(HttpServer server) {
        TestHttpServerLifecycle.assertTrue((String)"Server should not be live", (!server.isAlive() ? 1 : 0) != 0);
        this.assertToStringContains(server, " - not live");
    }

    @Ignore(value="Hangs on occasion; see HBASE-14430")
    @Test
    public void testCreatedServerIsNotAlive() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
    }

    @Ignore(value="Hangs on occasion; see HBASE-14430")
    @Test
    public void testStopUnstartedServer() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createTestServer();
        TestHttpServerLifecycle.stop(server);
    }

    @Ignore(value="Hangs on occasion; see HBASE-14430")
    @Test
    public void testStartedServerIsAlive() throws Throwable {
        HttpServer server = null;
        server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
        server.start();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
    }

    private void assertToStringContains(HttpServer server, String text) {
        String description = server.toString();
        TestHttpServerLifecycle.assertTrue((String)("Did not find \"" + text + "\" in \"" + description + "\""), (boolean)description.contains(text));
    }

    @Ignore(value="Hangs on occasion; see HBASE-14430")
    @Test
    public void testStoppedServerIsNotAlive() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createAndStartTestServer();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
    }

    @Ignore(value="Hangs on occasion; see HBASE-14430")
    @Test
    public void testStoppingTwiceServerIsAllowed() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createAndStartTestServer();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
    }

    @Ignore(value="Hangs on occasion; see HBASE-14430")
    @Test
    public void testWepAppContextAfterServerStop() throws Throwable {
        HttpServer server = null;
        String key = "test.attribute.key";
        String value = "test.attribute.value";
        server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
        server.start();
        server.setAttribute(key, (Object)value);
        this.assertAlive(server);
        TestHttpServerLifecycle.assertEquals((Object)value, (Object)server.getAttribute(key));
        TestHttpServerLifecycle.stop(server);
        TestHttpServerLifecycle.assertNull((String)"Server context should have cleared", (Object)server.getAttribute(key));
    }
}

