/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class DoubleColModuloDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public DoubleColModuloDoubleColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public DoubleColModuloDoubleColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector1 = (DoubleColumnVector)batch.cols[this.colNum1];
        DoubleColumnVector inputColVector2 = (DoubleColumnVector)batch.cols[this.colNum2];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        double[] vector1 = inputColVector1.vector;
        double[] vector2 = inputColVector2.vector;
        double[] outputVector = outputColVector.vector;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        boolean hasDivBy0 = false;
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            double denom = vector2[0];
            outputVector[0] = vector1[0] % denom;
            hasDivBy0 = hasDivBy0 || denom == 0.0;
        } else if (inputColVector1.isRepeating) {
            double vector1Value = vector1[0];
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    double denom = vector2[i];
                    outputVector[i] = vector1Value % denom;
                    hasDivBy0 = hasDivBy0 || denom == 0.0;
                }
            } else {
                int i;
                for (i = 0; i != n; ++i) {
                    outputVector[i] = vector1Value % vector2[i];
                }
                for (i = 0; i != n; ++i) {
                    hasDivBy0 = hasDivBy0 || vector2[i] == 0.0;
                }
            }
        } else if (inputColVector2.isRepeating) {
            double vector2Value = vector2[0];
            if (vector2Value == 0.0) {
                outputColVector.noNulls = false;
                outputColVector.isRepeating = true;
                outputColVector.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] % vector2Value;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] % vector2Value;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                double denom = vector2[i];
                outputVector[i] = vector1[i] % denom;
                hasDivBy0 = hasDivBy0 || denom == 0.0;
            }
        } else {
            int i;
            for (i = 0; i != n; ++i) {
                outputVector[i] = vector1[i] % vector2[i];
            }
            for (i = 0; i != n; ++i) {
                hasDivBy0 = hasDivBy0 || vector2[i] == 0.0;
            }
        }
        if (!hasDivBy0) {
            NullUtil.setNullDataEntriesDouble(outputColVector, batch.selectedInUse, sel, n);
        } else {
            NullUtil.setNullAndDivBy0DataEntriesDouble(outputColVector, batch.selectedInUse, sel, n, inputColVector2);
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

