/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

@Description(name="count", value="_FUNC_(expr) - Returns the merged sum value of expr (vectorized, type: long)")
public class VectorUDAFCountMerge
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;

    public VectorUDAFCountMerge() {
    }

    public VectorUDAFCountMerge(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        this.init();
    }

    private void init() {
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        LongColumnVector inputVector = (LongColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        long[] vector = inputVector.vector;
        if (inputVector.noNulls) {
            if (inputVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize);
            }
        } else if (inputVector.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsRepeatingSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize, batch.selected, inputVector.isNull);
            } else {
                this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector[0], batchSize, inputVector.isNull);
            }
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, batch.selected, inputVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, vector, batchSize, inputVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg;
            Aggregation aggregation = myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            aggregation.value = aggregation.value + value;
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg;
            Aggregation aggregation = myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            aggregation.value = aggregation.value + values[selection[i]];
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg;
            Aggregation aggregation = myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            aggregation.value = aggregation.value + values[i];
        }
    }

    private void iterateHasNullsRepeatingSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize, int[] selection, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg;
            Aggregation aggregation = myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            aggregation.value = aggregation.value + value;
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long value, int batchSize, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg;
            Aggregation aggregation = myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            aggregation.value = aggregation.value + value;
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize, int[] selection, boolean[] isNull) {
        for (int j = 0; j < batchSize; ++j) {
            Aggregation myagg;
            int i = selection[j];
            if (isNull[i]) continue;
            Aggregation aggregation = myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, j);
            aggregation.value = aggregation.value + values[i];
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, long[] values, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg;
            if (isNull[i]) continue;
            Aggregation aggregation = myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            aggregation.value = aggregation.value + values[i];
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        LongColumnVector inputVector = (LongColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        long[] vector = inputVector.vector;
        if (inputVector.isRepeating) {
            if (inputVector.noNulls || !inputVector.isNull[0]) {
                Aggregation aggregation = myagg;
                aggregation.value = aggregation.value + vector[0] * (long)batchSize;
            }
            return;
        }
        if (!batch.selectedInUse && inputVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, vector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull);
        } else if (inputVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, vector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, vector, batchSize, inputVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            Aggregation aggregation = myagg;
            aggregation.value = aggregation.value + vector[i];
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation aggregation = myagg;
            aggregation.value = aggregation.value + vector[selected[i]];
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, long[] vector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation aggregation = myagg;
            aggregation.value = aggregation.value + vector[i];
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, long[] vector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation aggregation = myagg;
            aggregation.value = aggregation.value + vector[i];
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((long)(model.object() + model.primitive2() + model.primitive1()), (long)model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("count") && inputColVectorType == ColumnVector.Type.LONG && outputColVectorType == ColumnVector.Type.LONG && (mode == GenericUDAFEvaluator.Mode.PARTIAL2 || mode == GenericUDAFEvaluator.Mode.FINAL);
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        outputColVector.isNull[batchIndex] = false;
        outputColVector.vector[batchIndex] = myagg.value;
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient long value;

        Aggregation() {
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.value = 0L;
        }
    }
}

