/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.network.shuffle.checksum.ShuffleChecksumHelper;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.MigratableResolver;
import org.apache.spark.shuffle.ShuffleBlockInfo;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleChecksumBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.storage.ShuffleMergedBlockId;
import org.apache.spark.storage.ShuffleMergedDataBlockId;
import org.apache.spark.storage.ShuffleMergedIndexBlockId;
import org.apache.spark.storage.ShuffleMergedMetaBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t]f!\u0002\u0017.\u0001=*\u0004\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011=\u0003!\u00111A\u0005\u0002AC\u0001b\u0016\u0001\u0003\u0002\u0004%\t\u0001\u0017\u0005\t=\u0002\u0011\t\u0011)Q\u0005#\")q\f\u0001C\u0001A\"AA\r\u0001EC\u0002\u0013%\u0001\u000bC\u0004f\u0001\t\u0007I\u0011\u00024\t\r=\u0004\u0001\u0015!\u0003h\u0011\u001d\u0001\bA1A\u0005\nEDa\u0001\u001f\u0001!\u0002\u0013\u0011\b\"B=\u0001\t\u0003Q\bbBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003o\u0001A\u0011BA\u001d\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aa!\u001f\u0001\u0005\u0002\u0005\r\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0005\n\u0003_\u0002\u0011\u0013!C\u0001\u0003cBq!a\"\u0001\t\u0013\tI\tC\u0005\u0002\u001c\u0002\t\n\u0011\"\u0003\u0002r!9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005\"CAV\u0001E\u0005I\u0011BA9\u0011\u001d\ti\u000b\u0001C\u0005\u0003_C\u0011\"a/\u0001#\u0003%I!!\u001d\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007bBAl\u0001\u0011\u0005\u0013\u0011\u001c\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GAqA!\u000e\u0001\t\u0013\u00119\u0004C\u0004\u0003P\u0001!\tE!\u0015\t\u000f\t}\u0003\u0001\"\u0011\u0003b!A!\u0011\u000f\u0001\u0005\u00025\u0012\u0019\bC\u0004\u0003~\u0001!\tAa \t\u0013\t-\u0005!%A\u0005\u0002\u0005E\u0004b\u0002BG\u0001\u0011\u0005#q\u0012\u0005\b\u0005+\u0003A\u0011\tBL\u0011\u001d\u0011y\n\u0001C!\u0005C;\u0001Ba).\u0011\u0003y#Q\u0015\u0004\bY5B\ta\fBT\u0011\u0019yv\u0005\"\u0001\u0003*\"I!1V\u0014C\u0002\u0013\u0005!Q\u0016\u0005\t\u0005_;\u0003\u0015!\u0003\u0002\f!I!\u0011W\u0014\u0012\u0002\u0013\u0005!1\u0017\u0002\u001a\u0013:$W\r_*ik\u001a4G.\u001a\"m_\u000e\\'+Z:pYZ,'O\u0003\u0002/_\u000591\u000f[;gM2,'B\u0001\u00192\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00114'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0005\u0019qN]4\u0014\u000b\u00011D\b\u0011$\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0005s\u0017PU3g!\tid(D\u0001.\u0013\tyTF\u0001\u000bTQV4g\r\\3CY>\u001c7NU3t_24XM\u001d\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007>\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u000b\n\u0013q\u0001T8hO&tw\r\u0005\u0002>\u000f&\u0011\u0001*\f\u0002\u0013\u001b&<'/\u0019;bE2,'+Z:pYZ,'/\u0001\u0003d_:47\u0001\u0001\t\u0003\u00196k\u0011aL\u0005\u0003\u001d>\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u001b}\u0013Gn\\2l\u001b\u0006t\u0017mZ3s+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+0\u0003\u001d\u0019Ho\u001c:bO\u0016L!AV*\u0003\u0019\tcwnY6NC:\fw-\u001a:\u0002#}\u0013Gn\\2l\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002Z9B\u0011qGW\u0005\u00037b\u0012A!\u00168ji\"9QlAA\u0001\u0002\u0004\t\u0016a\u0001=%c\u0005qqL\u00197pG.l\u0015M\\1hKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0002bE\u000e\u0004\"!\u0010\u0001\t\u000b%+\u0001\u0019A&\t\u000f=+\u0001\u0013!a\u0001#\u0006a!\r\\8dW6\u000bg.Y4fe\u0006iAO]1ogB|'\u000f^\"p]\u001a,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA!\u001e;jY*\u0011AnL\u0001\b]\u0016$xo\u001c:l\u0013\tq\u0017NA\u0007Ue\u0006t7\u000f]8si\u000e{gNZ\u0001\u000fiJ\fgn\u001d9peR\u001cuN\u001c4!\u0003Q\u0011X-\\8uKNCWO\u001a4mK6\u000b\u0007\u0010R5tWV\t!\u000fE\u00028gVL!\u0001\u001e\u001d\u0003\r=\u0003H/[8o!\t9d/\u0003\u0002xq\t!Aj\u001c8h\u0003U\u0011X-\\8uKNCWO\u001a4mK6\u000b\u0007\u0010R5tW\u0002\n1bZ3u\t\u0006$\u0018MR5mKR)10a\u0002\u0002\u0012A\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\u0005%|'BAA\u0001\u0003\u0011Q\u0017M^1\n\u0007\u0005\u0015QP\u0001\u0003GS2,\u0007bBA\u0005\u0017\u0001\u0007\u00111B\u0001\ng\",hM\u001a7f\u0013\u0012\u00042aNA\u0007\u0013\r\ty\u0001\u000f\u0002\u0004\u0013:$\bBBA\n\u0017\u0001\u0007Q/A\u0003nCBLE-A\thKR\u001cFo\u001c:fINCWO\u001a4mKN$\"!!\u0007\u0011\r\u0005m\u00111FA\u0019\u001d\u0011\ti\"a\n\u000f\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\tK\u0003\u0019a$o\\8u}%\t\u0011(C\u0002\u0002*a\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002.\u0005=\"aA*fc*\u0019\u0011\u0011\u0006\u001d\u0011\u0007u\n\u0019$C\u0002\u000265\u0012\u0001c\u00155vM\u001adWM\u00117pG.LeNZ8\u0002+\u001d,Go\u00155vM\u001adWMQ=uKN\u001cFo\u001c:fIR\tQ/\u0001\bde\u0016\fG/\u001a+f[B4\u0015\u000e\\3\u0015\u0007m\fy\u0004\u0003\u0004\u0002B9\u0001\ra_\u0001\u0005M&dW\rF\u0004|\u0003\u000b\n9%!\u0013\t\u000f\u0005%q\u00021\u0001\u0002\f!1\u00111C\bA\u0002UDq!a\u0013\u0010\u0001\u0004\ti%\u0001\u0003eSJ\u001c\b\u0003B\u001ct\u0003\u001f\u0002RaNA)\u0003+J1!a\u00159\u0005\u0015\t%O]1z!\u0011\t9&a\u0018\u000f\t\u0005e\u00131\f\t\u0004\u0003?A\u0014bAA/q\u00051\u0001K]3eK\u001aLA!!\u0019\u0002d\t11\u000b\u001e:j]\u001eT1!!\u00189\u000319W\r^%oI\u0016Dh)\u001b7f)\u001dY\u0018\u0011NA6\u0003[Bq!!\u0003\u0011\u0001\u0004\tY\u0001\u0003\u0004\u0002\u0014A\u0001\r!\u001e\u0005\n\u0003\u0017\u0002\u0002\u0013!a\u0001\u0003\u001b\nacZ3u\u0013:$W\r\u001f$jY\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003gRC!!\u0014\u0002v-\u0012\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0002b\n!\"\u00198o_R\fG/[8o\u0013\u0011\t))a\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fhKRlUM]4fI\ncwnY6ECR\fg)\u001b7f)-Y\u00181RAH\u0003#\u000b)*!'\t\u000f\u00055%\u00031\u0001\u0002V\u0005)\u0011\r\u001d9JI\"9\u0011\u0011\u0002\nA\u0002\u0005-\u0001bBAJ%\u0001\u0007\u00111B\u0001\u000fg\",hM\u001a7f\u001b\u0016\u0014x-Z%e\u0011\u001d\t9J\u0005a\u0001\u0003\u0017\t\u0001B]3ek\u000e,\u0017\n\u001a\u0005\n\u0003\u0017\u0012\u0002\u0013!a\u0001\u0003\u001b\n\u0001eZ3u\u001b\u0016\u0014x-\u001a3CY>\u001c7\u000eR1uC\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u00059r-\u001a;NKJ<W\r\u001a\"m_\u000e\\\u0017J\u001c3fq\u001aKG.\u001a\u000b\fw\u0006\u0005\u00161UAS\u0003O\u000bI\u000bC\u0004\u0002\u000eR\u0001\r!!\u0016\t\u000f\u0005%A\u00031\u0001\u0002\f!9\u00111\u0013\u000bA\u0002\u0005-\u0001bBAL)\u0001\u0007\u00111\u0002\u0005\n\u0003\u0017\"\u0002\u0013!a\u0001\u0003\u001b\n\u0011eZ3u\u001b\u0016\u0014x-\u001a3CY>\u001c7.\u00138eKb4\u0015\u000e\\3%I\u00164\u0017-\u001e7uIU\nacZ3u\u001b\u0016\u0014x-\u001a3CY>\u001c7.T3uC\u001aKG.\u001a\u000b\fw\u0006E\u00161WA[\u0003o\u000bI\fC\u0004\u0002\u000eZ\u0001\r!!\u0016\t\u000f\u0005%a\u00031\u0001\u0002\f!9\u00111\u0013\fA\u0002\u0005-\u0001bBAL-\u0001\u0007\u00111\u0002\u0005\n\u0003\u00172\u0002\u0013!a\u0001\u0003\u001b\n\u0001eZ3u\u001b\u0016\u0014x-\u001a3CY>\u001c7.T3uC\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005y!/Z7pm\u0016$\u0015\r^1Cs6\u000b\u0007\u000fF\u0003Z\u0003\u0003\f\u0019\rC\u0004\u0002\na\u0001\r!a\u0003\t\r\u0005M\u0001\u00041\u0001v\u0003U\u0019\u0007.Z2l\u0013:$W\r_!oI\u0012\u000bG/\u0019$jY\u0016$\u0002\"!3\u0002L\u0006=\u00171\u001b\t\u0005o\u0005ES\u000f\u0003\u0004\u0002Nf\u0001\ra_\u0001\u0006S:$W\r\u001f\u0005\u0007\u0003#L\u0002\u0019A>\u0002\t\u0011\fG/\u0019\u0005\b\u0003+L\u0002\u0019AA\u0006\u0003\u0019\u0011Gn\\2lg\u00069\u0002/\u001e;TQV4g\r\\3CY>\u001c7.Q:TiJ,\u0017-\u001c\u000b\u0007\u00037\f9/!=\u0011\t\u0005u\u00171]\u0007\u0003\u0003?T1!!9l\u0003\u0019\u0019G.[3oi&!\u0011Q]Ap\u0005Q\u0019FO]3b[\u000e\u000bG\u000e\u001c2bG.<\u0016\u000e\u001e5J\t\"9\u0011\u0011\u001e\u000eA\u0002\u0005-\u0018a\u00022m_\u000e\\\u0017\n\u001a\t\u0004%\u00065\u0018bAAx'\n9!\t\\8dW&#\u0007bBAz5\u0001\u0007\u0011Q_\u0001\u0012g\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00198bO\u0016\u0014\b\u0003BA|\u0003{l!!!?\u000b\u0007\u0005mx&\u0001\u0006tKJL\u0017\r\\5{KJLA!a@\u0002z\n\t2+\u001a:jC2L'0\u001a:NC:\fw-\u001a:\u0002%\u001d,G/T5he\u0006$\u0018n\u001c8CY>\u001c7n\u001d\u000b\u0005\u0005\u000b\u0011i\u0002\u0005\u0004\u0002\u001c\t\u001d!1B\u0005\u0005\u0005\u0013\tyC\u0001\u0003MSN$\bcB\u001c\u0003\u000e\u0005-(\u0011C\u0005\u0004\u0005\u001fA$A\u0002+va2,'\u0007\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\r\u00119b[\u0001\u0007EV4g-\u001a:\n\t\tm!Q\u0003\u0002\u000e\u001b\u0006t\u0017mZ3e\u0005V4g-\u001a:\t\u000f\t}1\u00041\u0001\u00022\u0005\u00012\u000f[;gM2,'\t\\8dW&sgm\\\u0001\u001boJLG/Z'fi\u0006$\u0017\r^1GS2,\u0017I\u001c3D_6l\u0017\u000e\u001e\u000b\f3\n\u0015\"q\u0005B\u0015\u0005[\u0011\t\u0004C\u0004\u0002\nq\u0001\r!a\u0003\t\r\u0005MA\u00041\u0001v\u0011\u001d\u0011Y\u0003\ba\u0001\u0003\u0013\fq\u0001\\3oORD7\u000fC\u0004\u00030q\u0001\r!!3\u0002\u0013\rDWmY6tk6\u001c\bB\u0002B\u001a9\u0001\u000710A\u0004eCR\fG+\u001c9\u0002#]\u0014\u0018\u000e^3NKR\fG-\u0019;b\r&dW\rF\u0005Z\u0005s\u0011iD!\u0011\u0003F!9!1H\u000fA\u0002\u0005%\u0017AC7fi\u00064\u0016\r\\;fg\"1!qH\u000fA\u0002m\fq\u0001^7q\r&dW\r\u0003\u0004\u0003Du\u0001\ra_\u0001\u000bi\u0006\u0014x-\u001a;GS2,\u0007b\u0002B$;\u0001\u0007!\u0011J\u0001\u000faJ|\u0007/Y4bi\u0016,%O]8s!\r9$1J\u0005\u0004\u0005\u001bB$a\u0002\"p_2,\u0017M\\\u0001\u0013O\u0016$X*\u001a:hK\u0012\u0014En\\2l\t\u0006$\u0018\r\u0006\u0004\u0003T\tU#Q\f\t\u0007\u00037\tYC!\u0005\t\u000f\u0005%h\u00041\u0001\u0003XA\u0019!K!\u0017\n\u0007\tm3K\u0001\u000bTQV4g\r\\3NKJ<W\r\u001a\"m_\u000e\\\u0017\n\u001a\u0005\b\u0003\u0017r\u0002\u0019AA'\u0003I9W\r^'fe\u001e,GM\u00117pG.lU\r^1\u0015\r\t\r$Q\u000eB8!\u0011\u0011)G!\u001b\u000e\u0005\t\u001d$B\u0001\u0018l\u0013\u0011\u0011YGa\u001a\u0003\u001f5+'oZ3e\u00052|7m['fi\u0006Dq!!; \u0001\u0004\u00119\u0006C\u0004\u0002L}\u0001\r!!\u0014\u0002\u0019\u001d,Go\u00115fG.\u001cX/\\:\u0015\r\u0005%'Q\u000fB=\u0011\u0019\u00119\b\ta\u0001w\u0006a1\r[3dWN,XNR5mK\"9!1\u0010\u0011A\u0002\u0005-\u0011\u0001\u00032m_\u000e\\g*^7\u0002\u001f\u001d,Go\u00115fG.\u001cX/\u001c$jY\u0016$\u0012b\u001fBA\u0005\u0007\u0013)I!#\t\u000f\u0005%\u0011\u00051\u0001\u0002\f!1\u00111C\u0011A\u0002UDqAa\"\"\u0001\u0004\t)&A\u0005bY\u001e|'/\u001b;i[\"I\u00111J\u0011\u0011\u0002\u0003\u0007\u0011QJ\u0001\u001aO\u0016$8\t[3dWN,XNR5mK\u0012\"WMZ1vYR$C'\u0001\u0007hKR\u0014En\\2l\t\u0006$\u0018\r\u0006\u0004\u0003\u0012\tE%1\u0013\u0005\b\u0003S\u001c\u0003\u0019AAv\u0011%\tYe\tI\u0001\u0002\u0004\ti%A\nhKR\u0014En\\2lg\u001a{'o\u00155vM\u001adW\r\u0006\u0004\u0003\u001a\nm%Q\u0014\t\u0007\u00037\tY#a;\t\u000f\u0005%A\u00051\u0001\u0002\f!1\u00111\u0003\u0013A\u0002U\fAa\u001d;paR\t\u0011,A\rJ]\u0012,\u0007p\u00155vM\u001adWM\u00117pG.\u0014Vm]8mm\u0016\u0014\bCA\u001f('\t9c\u0007\u0006\u0002\u0003&\u0006qajT(Q?J+E)V\"F?&#UCAA\u0006\u0003=quj\u0014)`%\u0016#UkQ#`\u0013\u0012\u0003\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u00036*\u001a\u0011+!\u001e")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging,
MigratableResolver {
    private BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    private final SparkConf conf;
    private BlockManager _blockManager;
    private final TransportConf transportConf;
    private final Option<Object> remoteShuffleMaxDisk;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static BlockManager $lessinit$greater$default$2() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2();
    }

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Option<String[]> getBlockData$default$2() {
        return ShuffleBlockResolver.getBlockData$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManager _blockManager() {
        return this._blockManager;
    }

    public void _blockManager_$eq(BlockManager x$1) {
        this._blockManager = x$1;
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkEnv$.MODULE$.get().blockManager());
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    public BlockManager org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager() {
        if (!this.bitmap$0) {
            return this.blockManager$lzycompute();
        }
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    private Option<Object> remoteShuffleMaxDisk() {
        return this.remoteShuffleMaxDisk;
    }

    public File getDataFile(int shuffleId, long mapId) {
        return this.getDataFile(shuffleId, mapId, (Option<String[]>)None$.MODULE$);
    }

    @Override
    public Seq<ShuffleBlockInfo> getStoredShuffles() {
        Seq<BlockId> allBlocks = this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getAllBlocks();
        return (Seq)allBlocks.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BlockId blockId = x0$1;
            if (blockId instanceof ShuffleIndexBlockId) {
                ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId;
                int shuffleId = shuffleIndexBlockId.shuffleId();
                long mapId = shuffleIndexBlockId.mapId();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new ShuffleBlockInfo(shuffleId, mapId)));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private long getShuffleBytesStored() {
        Seq shuffleFiles = (Seq)this.getStoredShuffles().map((Function1 & Serializable & scala.Serializable)si -> this.getDataFile(si.shuffleId(), si.mapId()), Seq$.MODULE$.canBuildFrom());
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)shuffleFiles.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.length()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public File createTempFile(File file) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().createTempFileWith(file);
    }

    public File getDataFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleDataBlockId blockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public File getIndexFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleIndexBlockId blockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)blockId.name()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(blockId));
    }

    public Option<String[]> getIndexFile$default$3() {
        return None$.MODULE$;
    }

    private File getMergedBlockDataFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedDataBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    private File getMergedBlockIndexFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedIndexBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    private Option<String[]> getMergedBlockIndexFile$default$5() {
        return None$.MODULE$;
    }

    private File getMergedBlockMetaFile(String appId, int shuffleId, int shuffleMergeId, int reduceId, Option<String[]> dirs) {
        return this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getMergedShuffleFile(new ShuffleMergedMetaBlockId(appId, shuffleId, shuffleMergeId, reduceId), dirs);
    }

    public void removeDataByMap(int shuffleId, long mapId) {
        ObjectRef file = ObjectRef.create((Object)this.getDataFile(shuffleId, mapId));
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Error deleting data ").append(((File)file$1.elem).getPath()).toString());
        }
        file.elem = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Error deleting index ").append(((File)file$1.elem).getPath()).toString());
        }
        file.elem = this.getChecksumFile(shuffleId, mapId, this.conf.get(package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM()), this.getChecksumFile$default$4());
        if (((File)file.elem).exists() && !((File)file.elem).delete()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Error deleting checksum ").append(((File)file$1.elem).getPath()).toString());
            return;
        }
    }

    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        long[] lengths;
        block12: {
            long[] lArray;
            block11: {
                DataInputStream dataInputStream;
                if (index.length() != (long)(blocks + 1) * 8L) {
                    return null;
                }
                lengths = new long[blocks];
                try {
                    dataInputStream = new DataInputStream(new NioBufferedFileInputStream(index));
                }
                catch (IOException e) {
                    return null;
                }
                try (DataInputStream in = dataInputStream;){
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            lArray = null;
                            break block11;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        lArray = null;
                    }
                }
            }
            return lArray;
        }
        if (data.length() == BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))) {
            return lengths;
        }
        return null;
    }

    @Override
    public StreamCallbackWithID putShuffleBlockAsStream(BlockId blockId, SerializerManager serializerManager) {
        File file;
        this.remoteShuffleMaxDisk().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)maxBytes -> {
            long bytesUsed = this.getShuffleBytesStored();
            if (maxBytes < bytesUsed) {
                throw new SparkException(new StringBuilder(37).append("Not storing remote shuffles ").append(bytesUsed).append(" exceeds ").append(maxBytes).toString());
            }
        });
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleIndexBlockId) {
            ShuffleIndexBlockId shuffleIndexBlockId = (ShuffleIndexBlockId)blockId2;
            int shuffleId = shuffleIndexBlockId.shuffleId();
            long mapId = shuffleIndexBlockId.mapId();
            file = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        } else if (blockId2 instanceof ShuffleDataBlockId) {
            ShuffleDataBlockId shuffleDataBlockId = (ShuffleDataBlockId)blockId2;
            int shuffleId = shuffleDataBlockId.shuffleId();
            long mapId = shuffleDataBlockId.mapId();
            file = this.getDataFile(shuffleId, mapId);
        } else {
            throw new IllegalStateException(new StringBuilder(38).append("Unexpected shuffle block transfer ").append(blockId).append(" as ").append(blockId.getClass().getSimpleName()).toString());
        }
        File file2 = file;
        File fileTmp = this.createTempFile(file2);
        WritableByteChannel channel = Channels.newChannel(new FileOutputStream(fileTmp));
        return new StreamCallbackWithID(this, blockId, channel, fileTmp, file2){
            private final /* synthetic */ IndexShuffleBlockResolver $outer;
            private final BlockId blockId$3;
            private final WritableByteChannel channel$1;
            private final File fileTmp$1;
            private final File file$2;

            public ByteBuffer getCompletionResponse() {
                return super.getCompletionResponse();
            }

            public String getID() {
                return this.blockId$3.name();
            }

            public void onData(String streamId, ByteBuffer buf) {
                while (buf.hasRemaining()) {
                    this.channel$1.write(buf);
                }
            }

            public void onComplete(String streamId) {
                this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Done receiving shuffle block ").append($this.blockId$3).append(", now storing on local disk.").toString());
                this.channel$1.close();
                long diskSize = this.fileTmp$1.length();
                $anon$1 var4_3 = this;
                synchronized (var4_3) {
                    Object object = this.file$2.exists() ? BoxesRunTime.boxToBoolean((boolean)this.file$2.delete()) : BoxedUnit.UNIT;
                    if (!this.fileTmp$1.renameTo(this.file$2)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(this.fileTmp$1).append(" to ").append(this.file$2).toString());
                    }
                }
                this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus(this.blockId$3, new BlockStatus(StorageLevel$.MODULE$.DISK_ONLY(), 0L, diskSize), this.$outer.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().reportBlockStatus$default$3());
            }

            public void onFailure(String streamId, Throwable cause) {
                this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error while uploading ").append($this.blockId$3).toString(), cause);
                this.channel$1.close();
                this.fileTmp$1.delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$3 = blockId$3;
                this.channel$1 = channel$1;
                this.fileTmp$1 = fileTmp$1;
                this.file$2 = file$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 ), $anonfun$onFailure$1(org.apache.spark.shuffle.IndexShuffleBlockResolver$$anon$1 )}, serializedLambda);
            }
        };
    }

    @Override
    public List<Tuple2<BlockId, ManagedBuffer>> getMigrationBlocks(ShuffleBlockInfo shuffleBlockInfo) {
        List list;
        block4: {
            try {
                int shuffleId = shuffleBlockInfo.shuffleId();
                long mapId = shuffleBlockInfo.mapId();
                File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
                ShuffleIndexBlockId indexBlockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                long indexFileSize = indexFile.length();
                FileSegmentManagedBuffer indexBlockData = new FileSegmentManagedBuffer(this.transportConf(), indexFile, 0L, indexFileSize);
                File dataFile = this.getDataFile(shuffleId, mapId);
                ShuffleDataBlockId dataBlockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
                FileSegmentManagedBuffer dataBlockData = new FileSegmentManagedBuffer(this.transportConf(), dataFile, 0L, dataFile.length());
                if (!indexFile.exists()) {
                    throw new FileNotFoundException("Index file is deleted already.");
                }
                if (dataFile.exists()) {
                    list = new .colon.colon((Object)new Tuple2((Object)dataBlockId, (Object)dataBlockData), (List)new .colon.colon((Object)new Tuple2((Object)indexBlockId, (Object)indexBlockData), (List)Nil$.MODULE$));
                    break block4;
                }
                list = new .colon.colon((Object)new Tuple2((Object)indexBlockId, (Object)indexBlockData), (List)Nil$.MODULE$);
            }
            catch (Exception exception) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Failed to resolve shuffle block ").append(shuffleBlockInfo).append(". ").append("This is expected to occur if a block is removed after decommissioning has started.").toString());
                list = List$.MODULE$.empty();
            }
        }
        return list;
    }

    public void writeMetadataFileAndCommit(int shuffleId, long mapId, long[] lengths, long[] checksums, File dataTmp) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        File indexTmp = this.createTempFile(indexFile);
        boolean checksumEnabled = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(checksums)).nonEmpty();
        if (checksumEnabled) {
            Predef$.MODULE$.assert(lengths.length == checksums.length, (Function0 & Serializable & scala.Serializable)() -> "The size of partition lengths and checksums should be equal");
            File checksumFile = this.getChecksumFile(shuffleId, mapId, this.conf.get(package$.MODULE$.SHUFFLE_CHECKSUM_ALGORITHM()), this.getChecksumFile$default$4());
            tuple22 = new Tuple2((Object)new Some((Object)checksumFile), (Object)new Some((Object)this.createTempFile(checksumFile)));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option checksumFileOpt = (Option)tuple2._1();
        Option checksumTmpOpt = (Option)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)checksumFileOpt, (Object)checksumTmpOpt);
        Option checksumFileOpt2 = (Option)tuple23._1();
        Option checksumTmpOpt2 = (Option)tuple23._2();
        try {
            File dataFile = this.getDataFile(shuffleId, mapId);
            IndexShuffleBlockResolver indexShuffleBlockResolver = this;
            synchronized (indexShuffleBlockResolver) {
                Object object;
                long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                if (existingLengths != null) {
                    System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                    if (checksumEnabled) {
                        long[] existingChecksums = this.getChecksums((File)checksumFileOpt2.get(), checksums.length);
                        if (existingChecksums != null) {
                            System.arraycopy(existingChecksums, 0, checksums, 0, lengths.length);
                        } else {
                            this.writeMetadataFile(checksums, (File)checksumTmpOpt2.get(), (File)checksumFileOpt2.get(), false);
                        }
                    }
                    object = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                } else {
                    long[] offsets = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).scanLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 + x$4, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                    this.writeMetadataFile(offsets, indexTmp, indexFile, true);
                    Object object2 = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(dataTmp).append(" to ").append(dataFile).toString());
                    }
                    ((IterableLike)Option$.MODULE$.option2Iterable(checksumTmpOpt2).zip((GenIterable)Option$.MODULE$.option2Iterable(checksumFileOpt2), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        IndexShuffleBlockResolver.$anonfun$writeMetadataFileAndCommit$3(this, checksums, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    object = BoxedUnit.UNIT;
                }
            }
        }
        finally {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Shuffle index for mapId ").append(mapId).append(": ").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).mkString("[", ",", "]")).toString());
            if (indexTmp.exists() && !indexTmp.delete()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to delete temporary index file at ").append(indexTmp.getAbsolutePath()).toString());
            }
            checksumTmpOpt2.foreach((Function1 & Serializable & scala.Serializable)checksumTmp -> {
                IndexShuffleBlockResolver.$anonfun$writeMetadataFileAndCommit$7(this, checksumTmp);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void writeMetadataFile(long[] metaValues, File tmpFile, File targetFile, boolean propagateError) {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(metaValues)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> out.writeLong(x$1)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
        Object object = targetFile.exists() ? BoxesRunTime.boxToBoolean((boolean)targetFile.delete()) : BoxedUnit.UNIT;
        if (!tmpFile.renameTo(targetFile)) {
            String errorMsg = new StringBuilder(24).append("fail to rename file ").append(tmpFile).append(" to ").append(targetFile).toString();
            if (propagateError) {
                throw new IOException(errorMsg);
            }
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            return;
        }
    }

    @Override
    public Seq<ManagedBuffer> getMergedBlockData(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
        File indexFile = this.getMergedBlockIndexFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        File dataFile = this.getMergedBlockDataFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        int size = (int)indexFile.length();
        LongBuffer offsets = (LongBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new DataInputStream(Files.newInputStream(indexFile.toPath(), new OpenOption[0])), (Function1 & Serializable & scala.Serializable)dis -> {
            ByteBuffer buffer = ByteBuffer.allocate(size);
            dis.readFully(buffer.array());
            return buffer.asLongBuffer();
        });
        int numChunks = size / 8 - 1;
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numChunks).map((Function1 & Serializable & scala.Serializable)index -> IndexShuffleBlockResolver.$anonfun$getMergedBlockData$3(this, dataFile, offsets, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private Option<String[]> getMergedBlockDataFile$default$5() {
        return None$.MODULE$;
    }

    @Override
    public MergedBlockMeta getMergedBlockMeta(ShuffleMergedBlockId blockId, Option<String[]> dirs) {
        File indexFile = this.getMergedBlockIndexFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        int size = (int)indexFile.length();
        int numChunks = size / 8 - 1;
        File metaFile = this.getMergedBlockMetaFile(this.conf.getAppId(), blockId.shuffleId(), blockId.shuffleMergeId(), blockId.reduceId(), dirs);
        FileSegmentManagedBuffer chunkBitMaps = new FileSegmentManagedBuffer(this.transportConf(), metaFile, 0L, metaFile.length());
        return new MergedBlockMeta(numChunks, (ManagedBuffer)chunkBitMaps);
    }

    private Option<String[]> getMergedBlockMetaFile$default$5() {
        return None$.MODULE$;
    }

    public long[] getChecksums(File checksumFile, int blockNum) {
        ArrayBuffer checksums;
        block8: {
            long[] lArray;
            block9: {
                if (!checksumFile.exists()) {
                    return null;
                }
                checksums = new ArrayBuffer();
                try (FilterInputStream in = null;){
                    try {
                        in = new DataInputStream(new NioBufferedFileInputStream(checksumFile));
                        while (checksums.size() < blockNum) {
                            checksums.$plus$eq((Object)BoxesRunTime.boxToLong((long)((DataInputStream)in).readLong()));
                        }
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof IOException ? true : throwable2 instanceof EOFException) {
                            lArray = null;
                            break block9;
                        }
                        throw throwable;
                    }
                }
            }
            return lArray;
        }
        return (long[])checksums.toArray(ClassTag$.MODULE$.Long());
    }

    public File getChecksumFile(int shuffleId, long mapId, String algorithm, Option<String[]> dirs) {
        ShuffleChecksumBlockId blockId = new ShuffleChecksumBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        String fileName = ShuffleChecksumHelper.getChecksumFileName((String)blockId.name(), (String)algorithm);
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)d -> new File(ExecutorDiskUtils.getFilePath((String[])d, (int)this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().subDirsPerLocalDir(), (String)fileName))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.org$apache$spark$shuffle$IndexShuffleBlockResolver$$blockManager().diskBlockManager().getFile(fileName));
    }

    public Option<String[]> getChecksumFile$default$4() {
        return None$.MODULE$;
    }

    @Override
    public ManagedBuffer getBlockData(BlockId blockId, Option<String[]> dirs) {
        FileSegmentManagedBuffer fileSegmentManagedBuffer;
        Tuple4 tuple4;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToInteger((int)(shuffleBlockId.reduceId() + 1)));
        } else if (blockId2 instanceof ShuffleBlockBatchId) {
            ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockBatchId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.startReduceId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.endReduceId()));
        } else {
            throw new IllegalArgumentException(new StringBuilder(36).append("unexpected shuffle block id format: ").append(blockId).toString());
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        int shuffleId = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long mapId = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int startReduceId = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int endReduceId = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)BoxesRunTime.boxToLong((long)mapId), (Object)BoxesRunTime.boxToInteger((int)startReduceId), (Object)BoxesRunTime.boxToInteger((int)endReduceId));
        int shuffleId2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        long mapId2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        int startReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int endReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        File indexFile = this.getIndexFile(shuffleId2, mapId2, dirs);
        SeekableByteChannel channel = Files.newByteChannel(indexFile.toPath(), new OpenOption[0]);
        channel.position((long)startReduceId2 * 8L);
        try (DataInputStream in = new DataInputStream(Channels.newInputStream(channel));){
            long startOffset = in.readLong();
            channel.position((long)endReduceId2 * 8L);
            long endOffset = in.readLong();
            long actualPosition = channel.position();
            long expectedPosition = (long)endReduceId2 * 8L + 8L;
            if (actualPosition != expectedPosition) {
                throw new Exception(new StringBuilder(99).append("SPARK-22982: Incorrect channel position after index file reads: ").append("expected ").append(expectedPosition).append(" but actual position was ").append(actualPosition).append(".").toString());
            }
            fileSegmentManagedBuffer = new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(shuffleId2, mapId2, dirs), startOffset, endOffset - startOffset);
        }
        return fileSegmentManagedBuffer;
    }

    @Override
    public Seq<BlockId> getBlocksForShuffle(int shuffleId, long mapId) {
        return (Seq)new .colon.colon((Object)new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()), (List)new .colon.colon((Object)new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()), (List)Nil$.MODULE$));
    }

    @Override
    public void stop() {
    }

    public static final /* synthetic */ void $anonfun$writeMetadataFileAndCommit$3(IndexShuffleBlockResolver $this, long[] checksums$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            BoxedUnit boxedUnit;
            File checksumTmp = (File)tuple2._1();
            File checksumFile = (File)tuple2._2();
            try {
                $this.writeMetadataFile(checksums$1, checksumTmp, checksumFile, false);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to write checksum file", e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$writeMetadataFileAndCommit$7(IndexShuffleBlockResolver $this, File checksumTmp) {
        if (checksumTmp.exists()) {
            try {
                if (!checksumTmp.delete()) {
                    $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed to delete temporary checksum file ").append("at ").append(checksumTmp.getAbsolutePath()).toString());
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed to delete temporary checksum file ").append("at ").append(checksumTmp.getAbsolutePath()).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ FileSegmentManagedBuffer $anonfun$getMergedBlockData$3(IndexShuffleBlockResolver $this, File dataFile$1, LongBuffer offsets$1, int index) {
        return new FileSegmentManagedBuffer($this.transportConf(), dataFile$1, offsets$1.get(index), offsets$1.get(index + 1) - offsets$1.get(index));
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager) {
        this.conf = conf;
        this._blockManager = _blockManager;
        ShuffleBlockResolver.$init$(this);
        Logging.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3(), SparkTransportConf$.MODULE$.fromSparkConf$default$4());
        this.remoteShuffleMaxDisk = (Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_SHUFFLE_MAX_DISK_SIZE());
    }
}

