/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import sdsu.io.ASCIIFileRepository;
import sdsu.io.Repository;

public class LocalRepository
implements Repository {
    static final char DEFAULT_NAME_SEPARATOR = '.';
    private char nameSeparator = (char)46;
    private File repositoryDirectory;
    private Repository elements;
    private Hashtable subrepositories;

    public LocalRepository(File file) {
        this.repositoryDirectory = file;
        this.elements = new ASCIIFileRepository(this.repositoryDirectory);
        this.subrepositories = this.exists() ? this.openSubrepositories(file) : new Hashtable();
    }

    public LocalRepository(String string) {
        this(new File(string));
    }

    public boolean containsKey(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        if (this.isBaseKey(string)) {
            return this.elements.containsKey(string);
        }
        if (this.subrepositories.containsKey(this.prefixKey(string))) {
            Repository repository = (Repository)this.subrepositories.get(this.prefixKey(string));
            return repository.containsKey(this.suffixKey(string));
        }
        return false;
    }

    public boolean containsSubrepository(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return true;
        }
        if (this.isBaseKey(string)) {
            return this.subrepositories.containsKey(string);
        }
        if (this.subrepositories.containsKey(this.prefixKey(string))) {
            Repository repository = (Repository)this.subrepositories.get(this.prefixKey(string));
            return repository.containsSubrepository(this.suffixKey(string));
        }
        return false;
    }

    public boolean create() {
        return this.elements.create();
    }

    public boolean createSubrepository(String string) {
        if (string == null) {
            return true;
        }
        if (string.equals("")) {
            return true;
        }
        String string2 = this.prefixKey(string);
        String string3 = this.suffixKey(string);
        if (this.subrepositories.containsKey(string2)) {
            Repository repository = (Repository)this.subrepositories.get(string2);
            return repository.createSubrepository(string3);
        }
        File file = new File(this.repositoryDirectory, string2);
        LocalRepository localRepository = new LocalRepository(file);
        localRepository.create();
        this.subrepositories.put(string2, localRepository);
        return localRepository.createSubrepository(string3);
    }

    public boolean exists() {
        return this.repositoryDirectory.exists();
    }

    public Object get(String string) throws IOException {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return null;
        }
        if (this.isBaseKey(string)) {
            return this.elements.get(string);
        }
        if (this.subrepositories.containsKey(this.prefixKey(string))) {
            Repository repository = (Repository)this.subrepositories.get(this.prefixKey(string));
            return repository.get(this.suffixKey(string));
        }
        return null;
    }

    public Enumeration getSubrepositories() {
        return this.subrepositories.elements();
    }

    public Repository getSubrepository(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return null;
        }
        if (this.isBaseKey(string)) {
            return (Repository)this.subrepositories.get(string);
        }
        String string2 = this.prefixKey(string);
        String string3 = this.suffixKey(string);
        Repository repository = (Repository)this.subrepositories.get(string2);
        return repository.getSubrepository(string3);
    }

    private boolean isBaseKey(String string) {
        return string.indexOf(this.nameSeparator) <= -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Enumeration keys() {
        return this.elements.keys();
    }

    public int length() {
        return this.size();
    }

    private Hashtable openSubrepositories(File file) {
        Hashtable<String, LocalRepository> hashtable = new Hashtable<String, LocalRepository>();
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(file, stringArray[n]);
            if (file2.isDirectory()) {
                hashtable.put(stringArray[n], new LocalRepository(file2));
            }
            ++n;
        }
        return hashtable;
    }

    private String prefixKey(String string) {
        int n = string.indexOf(this.nameSeparator);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void put(String string, Object object) throws IOException {
        this.put(string, object, null);
    }

    public void put(String string, Object object, String string2) throws IOException {
        this.put(string, object, string2, false);
    }

    private void put(String string, Object object, String string2, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            return;
        }
        if (this.isBaseKey(string)) {
            if (bl) {
                this.elements.putSerializable(string, (Serializable)object, string2);
            } else {
                this.elements.put(string, object, string2);
            }
        } else if (this.subrepositories.containsKey(this.prefixKey(string))) {
            Repository repository = (Repository)this.subrepositories.get(this.prefixKey(string));
            if (bl) {
                repository.putSerializable(this.suffixKey(string), (Serializable)object, string2);
            } else {
                repository.put(this.suffixKey(string), object, string2);
            }
        } else {
            this.createSubrepository(this.prefixKey(string));
            Repository repository = (Repository)this.subrepositories.get(this.prefixKey(string));
            repository.put(this.suffixKey(string), object, string2);
        }
    }

    public void putSerializable(String string, Serializable serializable) throws IOException {
        this.putSerializable(string, serializable, null);
    }

    public void putSerializable(String string, Serializable serializable, String string2) throws IOException {
        this.put(string, serializable, string2, true);
    }

    public boolean remove(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        if (this.isBaseKey(string)) {
            return this.elements.remove(string);
        }
        if (this.subrepositories.containsKey(this.prefixKey(string))) {
            Repository repository = (Repository)this.subrepositories.get(this.prefixKey(string));
            return repository.remove(this.suffixKey(string));
        }
        return true;
    }

    public void setNameSeparator(char c) {
        this.nameSeparator = c;
    }

    public int size() {
        return this.elements.size() + this.subrepositories.size();
    }

    private String suffixKey(String string) {
        int n = string.indexOf(this.nameSeparator);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }
}

