/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HConnectionTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MasterCallable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionAdminServiceCallable;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.RegionMovedException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={LargeTests.class})
public class TestHCM {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final Log LOG = LogFactory.getLog(TestHCM.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final TableName TABLE_NAME1 = TableName.valueOf((String)"test1");
    private static final TableName TABLE_NAME2 = TableName.valueOf((String)"test2");
    private static final TableName TABLE_NAME3 = TableName.valueOf((String)"test3");
    private static final TableName TABLE_NAME4 = TableName.valueOf((String)"test4");
    private static final byte[] FAM_NAM = Bytes.toBytes((String)"f");
    private static final byte[] ROW = Bytes.toBytes((String)"bbb");
    private static final byte[] ROW_X = Bytes.toBytes((String)"xxx");
    private static Random _randy = new Random();
    protected static final AtomicBoolean syncBlockingFilter = new AtomicBoolean(false);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.status.published", true);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 5);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static int getHConnectionManagerCacheSize() {
        return HConnectionTestingUtility.getConnectionCount();
    }

    @Test
    public void testClusterConnection() throws IOException {
        ThreadPoolExecutor otherPool = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"test-hcm"));
        HConnection con1 = HConnectionManager.createConnection((Configuration)TEST_UTIL.getConfiguration());
        HConnection con2 = HConnectionManager.createConnection((Configuration)TEST_UTIL.getConfiguration(), (ExecutorService)otherPool);
        Assert.assertTrue((otherPool == ((ConnectionManager.HConnectionImplementation)con2).getCurrentBatchPool() ? 1 : 0) != 0);
        String tableName = "testClusterConnection";
        TEST_UTIL.createTable(tableName.getBytes(), FAM_NAM).close();
        HTable t = (HTable)con1.getTable(tableName, (ExecutorService)otherPool);
        Assert.assertNull((String)"Internal Thread pool should be null", (Object)((ConnectionManager.HConnectionImplementation)con1).getCurrentBatchPool());
        Assert.assertTrue((otherPool == t.getPool() ? 1 : 0) != 0);
        t.close();
        t = (HTable)con2.getTable(tableName);
        Assert.assertTrue((otherPool == t.getPool() ? 1 : 0) != 0);
        t.close();
        t = (HTable)con2.getTable(Bytes.toBytes((String)tableName));
        Assert.assertTrue((otherPool == t.getPool() ? 1 : 0) != 0);
        t.close();
        t = (HTable)con2.getTable(TableName.valueOf((String)tableName));
        Assert.assertTrue((otherPool == t.getPool() ? 1 : 0) != 0);
        t.close();
        t = (HTable)con1.getTable(tableName);
        ExecutorService pool = ((ConnectionManager.HConnectionImplementation)con1).getCurrentBatchPool();
        Assert.assertNotNull((String)"An internal Thread pool should have been created", (Object)pool);
        Assert.assertTrue((t.getPool() == pool ? 1 : 0) != 0);
        t.close();
        t = (HTable)con1.getTable(tableName);
        Assert.assertTrue((t.getPool() == pool ? 1 : 0) != 0);
        t.close();
        con1.close();
        Assert.assertTrue((boolean)pool.isShutdown());
        con2.close();
        Assert.assertFalse((boolean)otherPool.isShutdown());
        otherPool.shutdownNow();
    }

    @Test
    public void testAdminFactory() throws IOException {
        Connection con1 = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        Admin admin = con1.getAdmin();
        Assert.assertTrue((admin.getConnection() == con1 ? 1 : 0) != 0);
        Assert.assertTrue((admin.getConfiguration() == TEST_UTIL.getConfiguration() ? 1 : 0) != 0);
        con1.close();
    }

    @Ignore
    @Test(expected=RegionServerStoppedException.class)
    public void testClusterStatus() throws Exception {
        TableName tn = TableName.valueOf((String)"testClusterStatus");
        byte[] cf = "cf".getBytes();
        byte[] rk = "rk1".getBytes();
        JVMClusterUtil.RegionServerThread rs = TEST_UTIL.getHBaseCluster().startRegionServer();
        rs.waitForServerOnline();
        final ServerName sn = rs.getRegionServer().getServerName();
        HTable t = TEST_UTIL.createTable(tn, cf);
        TEST_UTIL.waitTableAvailable(tn);
        while (TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        final ConnectionManager.HConnectionImplementation hci = (ConnectionManager.HConnectionImplementation)t.getConnection();
        while (t.getRegionLocation(rk).getPort() != sn.getPort()) {
            TEST_UTIL.getHBaseAdmin().move(t.getRegionLocation(rk).getRegionInfo().getEncodedNameAsBytes(), Bytes.toBytes((String)sn.toString()));
            while (TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition()) {
                Thread.sleep(1L);
            }
            hci.clearRegionCache(tn);
        }
        Assert.assertNotNull((Object)hci.clusterStatusListener);
        TEST_UTIL.assertRegionOnServer(t.getRegionLocation(rk).getRegionInfo(), sn, 20000L);
        Put p1 = new Put(rk);
        p1.add(cf, "qual".getBytes(), "val".getBytes());
        t.put(p1);
        rs.getRegionServer().abort("I'm dead");
        TEST_UTIL.waitFor(40000L, 1000L, true, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getDeadServers().isDeadServer(sn);
            }
        });
        TEST_UTIL.waitFor(40000L, 1000L, true, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return hci.clusterStatusListener.isDeadServer(sn);
            }
        });
        t.close();
        hci.getClient(sn);
    }

    @Test
    public void testConnectionCloseAllowsInterrupt() throws Exception {
        this.testConnectionClose(true);
    }

    @Test
    public void testConnectionNotAllowsInterrupt() throws Exception {
        this.testConnectionClose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOperationTimeout() throws Exception {
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor("HCM-testOperationTimeout");
        hdt.addCoprocessor(SleepAndFailFirstTime.class.getName());
        HTable table = TEST_UTIL.createTable(hdt, (byte[][])new byte[][]{FAM_NAM}, TEST_UTIL.getConfiguration());
        table.setRpcTimeout(Integer.MAX_VALUE);
        table.setOperationTimeout(120000);
        table.get(new Get(FAM_NAM));
        SleepAndFailFirstTime.ct.set(0L);
        try {
            table.setOperationTimeout(30000);
            table.get(new Get(FAM_NAM));
            Assert.fail((String)"We expect an exception here");
        }
        catch (SocketTimeoutException e) {
            LOG.info((Object)"We received an exception, as expected ", (Throwable)e);
        }
        catch (IOException e) {
            Assert.fail((String)("Wrong exception:" + e.getMessage()));
        }
        finally {
            table.close();
        }
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testRpcTimeout() throws Exception {
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor("HCM-testRpcTimeout");
        hdt.addCoprocessor(SleepCoprocessor.class.getName());
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        try (HTable t = TEST_UTIL.createTable(hdt, (byte[][])new byte[][]{FAM_NAM}, c);){
            assert (t instanceof HTable);
            HTable table = t;
            table.setRpcTimeout(2500);
            table.setOperationTimeout(500000);
            table.get(new Get(FAM_NAM));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcRetryingCallerSleep() throws Exception {
        HTableDescriptor hdt = TEST_UTIL.createTableDescriptor("HCM-testRpcRetryingCallerSleep");
        hdt.addCoprocessorWithSpec("|" + SleepAndFailFirstTime.class.getName() + "||" + "hbase.coprocessor.SleepAndFailFirstTime.sleepTime" + "=2000");
        TEST_UTIL.createTable(hdt, (byte[][])new byte[][]{FAM_NAM}).close();
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        c.setInt("hbase.client.pause", 3000);
        c.setInt("hbase.rpc.timeout", 4000);
        Connection connection = ConnectionFactory.createConnection((Configuration)c);
        Table t = connection.getTable(TableName.valueOf((String)"HCM-testRpcRetryingCallerSleep"));
        if (t instanceof HTable) {
            HTable table = (HTable)t;
            table.setOperationTimeout(8000);
            table.get(new Get(FAM_NAM));
            SleepAndFailFirstTime.ct.set(0L);
            try {
                table.setOperationTimeout(6000);
                table.get(new Get(FAM_NAM));
                Assert.fail((String)"We expect an exception here");
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)"We received an exception, as expected ", (Throwable)e);
            }
            catch (IOException e) {
                Assert.fail((String)("Wrong exception:" + e.getMessage()));
            }
            finally {
                table.close();
                connection.close();
            }
        }
    }

    @Test
    public void testCallableSleep() throws Exception {
        long pauseTime;
        long baseTime = 100L;
        TableName tableName = TableName.valueOf((String)"HCM-testCallableSleep");
        HTable table = TEST_UTIL.createTable(tableName, FAM_NAM);
        RegionServerCallable<Object> regionServerCallable = new RegionServerCallable<Object>(TEST_UTIL.getConnection(), tableName, ROW){

            public Object call(int timeout) throws IOException {
                return null;
            }
        };
        regionServerCallable.prepare(false);
        for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
            pauseTime = regionServerCallable.sleep(baseTime, i);
            Assert.assertTrue((pauseTime >= baseTime * (long)HConstants.RETRY_BACKOFF[i] ? 1 : 0) != 0);
            Assert.assertTrue(((float)pauseTime <= (float)(baseTime * (long)HConstants.RETRY_BACKOFF[i]) * 1.01f ? 1 : 0) != 0);
        }
        RegionAdminServiceCallable<Object> regionAdminServiceCallable = new RegionAdminServiceCallable<Object>((ClusterConnection)TEST_UTIL.getConnection(), new RpcControllerFactory(TEST_UTIL.getConfiguration()), tableName, ROW){

            public Object call(int timeout) throws IOException {
                return null;
            }
        };
        regionAdminServiceCallable.prepare(false);
        for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
            pauseTime = regionAdminServiceCallable.sleep(baseTime, i);
            Assert.assertTrue((pauseTime >= baseTime * (long)HConstants.RETRY_BACKOFF[i] ? 1 : 0) != 0);
            Assert.assertTrue(((float)pauseTime <= (float)(baseTime * (long)HConstants.RETRY_BACKOFF[i]) * 1.01f ? 1 : 0) != 0);
        }
        MasterCallable masterCallable = new MasterCallable((HConnection)TEST_UTIL.getConnection()){

            public Object call(int timeout) throws IOException {
                return null;
            }
        };
        for (int i = 0; i < HConstants.RETRY_BACKOFF.length; ++i) {
            pauseTime = masterCallable.sleep(baseTime, i);
            Assert.assertTrue((pauseTime >= baseTime * (long)HConstants.RETRY_BACKOFF[i] ? 1 : 0) != 0);
            Assert.assertTrue(((float)pauseTime <= (float)(baseTime * (long)HConstants.RETRY_BACKOFF[i]) * 1.01f ? 1 : 0) != 0);
        }
    }

    private void testConnectionClose(boolean allowsInterrupt) throws Exception {
        TableName tableName = TableName.valueOf((String)("HCM-testConnectionClose" + allowsInterrupt));
        TEST_UTIL.createTable(tableName, FAM_NAM).close();
        boolean previousBalance = TEST_UTIL.getHBaseAdmin().setBalancerRunning(false, true);
        Configuration c2 = new Configuration(TEST_UTIL.getConfiguration());
        c2.set("hbase.client.instance.id", String.valueOf(-1));
        c2.setInt("hbase.client.retries.number", 100);
        c2.setInt("hbase.client.pause", 1);
        c2.setInt("hbase.ipc.client.failed.servers.expiry", 0);
        c2.setBoolean("hbase.ipc.client.specificThreadForWriting", allowsInterrupt);
        final HTable table = new HTable(c2, tableName);
        Put put = new Put(ROW);
        put.add(FAM_NAM, ROW, ROW);
        table.put(put);
        final AtomicInteger step = new AtomicInteger(0);
        final AtomicReference<Object> failed = new AtomicReference<Object>(null);
        Thread t = new Thread("testConnectionCloseThread"){

            @Override
            public void run() {
                int done = 0;
                try {
                    step.set(1);
                    while (step.get() == 1) {
                        Get get = new Get(ROW);
                        table.get(get);
                        if (++done % 100 != 0) continue;
                        LOG.info((Object)("done=" + done));
                    }
                }
                catch (Throwable t) {
                    failed.set(t);
                    LOG.error((Object)t);
                }
                step.set(3);
            }
        };
        t.start();
        TEST_UTIL.waitFor(20000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return step.get() == 1;
            }
        });
        ServerName sn = table.getRegionLocation(ROW).getServerName();
        ConnectionManager.HConnectionImplementation conn = (ConnectionManager.HConnectionImplementation)table.getConnection();
        RpcClient rpcClient = conn.getRpcClient();
        LOG.info((Object)("Going to cancel connections. connection=" + conn.toString() + ", sn=" + sn));
        for (int i = 0; i < 5000; ++i) {
            rpcClient.cancelConnections(sn);
            Thread.sleep(5L);
        }
        step.compareAndSet(1, 2);
        TEST_UTIL.waitFor(40000L, new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return step.get() == 3;
            }
        });
        table.close();
        Assert.assertTrue((String)("Unexpected exception is " + failed.get()), (failed.get() == null ? 1 : 0) != 0);
        TEST_UTIL.getHBaseAdmin().setBalancerRunning(previousBalance, true);
    }

    @Test
    public void testConnectionIdle() throws Exception {
        TableName tableName = TableName.valueOf((String)"HCM-testConnectionIdle");
        TEST_UTIL.createTable(tableName, FAM_NAM).close();
        int idleTime = 20000;
        boolean previousBalance = TEST_UTIL.getHBaseAdmin().setBalancerRunning(false, true);
        Configuration c2 = new Configuration(TEST_UTIL.getConfiguration());
        c2.set("hbase.client.instance.id", String.valueOf(-1));
        c2.setInt("hbase.client.retries.number", 1);
        c2.setInt("hbase.ipc.client.connection.minIdleTimeBeforeClose", idleTime);
        HTable table = new HTable(c2, tableName);
        Put put = new Put(ROW);
        put.add(FAM_NAM, ROW, ROW);
        table.put(put);
        ManualEnvironmentEdge mee = new ManualEnvironmentEdge();
        mee.setValue(System.currentTimeMillis());
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)mee);
        LOG.info((Object)"first get");
        table.get(new Get(ROW));
        LOG.info((Object)"first get - changing the time & sleeping");
        mee.incValue((long)(idleTime + 1000));
        Thread.sleep(1500L);
        LOG.info((Object)"second get - connection has been marked idle in the middle");
        table.get(new Get(ROW));
        mee.incValue((long)(idleTime + 1000));
        LOG.info((Object)"third get - connection is idle, but the reader doesn't know yet");
        table.get(new Get(ROW));
        LOG.info((Object)"we're done - time will change back");
        table.close();
        EnvironmentEdgeManager.reset();
        TEST_UTIL.getHBaseAdmin().setBalancerRunning(previousBalance, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionCut() throws Exception {
        TableName tableName = TableName.valueOf((String)"HCM-testConnectionCut");
        TEST_UTIL.createTable(tableName, FAM_NAM).close();
        boolean previousBalance = TEST_UTIL.getHBaseAdmin().setBalancerRunning(false, true);
        Configuration c2 = new Configuration(TEST_UTIL.getConfiguration());
        c2.set("hbase.client.instance.id", String.valueOf(-1));
        c2.setInt("hbase.client.retries.number", 1);
        c2.setInt("hbase.rpc.timeout", 30000);
        HTable table = new HTable(c2, tableName);
        Put p = new Put(FAM_NAM);
        p.add(FAM_NAM, FAM_NAM, FAM_NAM);
        table.put(p);
        final ConnectionManager.HConnectionImplementation hci = (ConnectionManager.HConnectionImplementation)table.getConnection();
        final HRegionLocation loc = table.getRegionLocation(FAM_NAM);
        Get get = new Get(FAM_NAM);
        Assert.assertNotNull((Object)table.get(get));
        get = new Get(FAM_NAM);
        get.setFilter((Filter)new BlockingFilter());
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicBoolean atomicBoolean = syncBlockingFilter;
                synchronized (atomicBoolean) {
                    try {
                        syncBlockingFilter.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                hci.clusterStatusListener.deadServerHandler.newDead(loc.getServerName());
            }
        };
        t.start();
        try {
            table.get(get);
            Assert.fail();
        }
        catch (IOException expected) {
            LOG.debug((Object)("Received: " + expected));
            Assert.assertFalse((boolean)(expected instanceof SocketTimeoutException));
            Assert.assertFalse((boolean)syncBlockingFilter.get());
        }
        finally {
            syncBlockingFilter.set(true);
            t.join();
            HConnectionManager.getConnection((Configuration)c2).close();
            TEST_UTIL.getHBaseAdmin().setBalancerRunning(previousBalance, true);
        }
        table.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void abortingHConnectionRemovesItselfFromHCM() throws Exception {
        HashMap oldHBaseInstances = new HashMap();
        oldHBaseInstances.putAll(ConnectionManager.CONNECTION_INSTANCES);
        ConnectionManager.CONNECTION_INSTANCES.clear();
        try {
            HConnection connection = HConnectionManager.getConnection((Configuration)TEST_UTIL.getConfiguration());
            connection.abort("test abortingHConnectionRemovesItselfFromHCM", (Throwable)new Exception("test abortingHConnectionRemovesItselfFromHCM"));
            Assert.assertNotSame((Object)connection, (Object)HConnectionManager.getConnection((Configuration)TEST_UTIL.getConfiguration()));
        }
        finally {
            ConnectionManager.CONNECTION_INSTANCES.clear();
            ConnectionManager.CONNECTION_INSTANCES.putAll(oldHBaseInstances);
        }
    }

    @Test
    public void testRegionCaching() throws Exception {
        TEST_UTIL.createMultiRegionTable(TABLE_NAME, FAM_NAM).close();
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.client.retries.number", 1);
        HTable table = new HTable(conf, TABLE_NAME);
        TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
        Put put = new Put(ROW);
        put.add(FAM_NAM, ROW, ROW);
        table.put(put);
        ConnectionManager.HConnectionImplementation conn = (ConnectionManager.HConnectionImplementation)table.getConnection();
        Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, ROW));
        int nextPort = conn.getCachedLocation(TABLE_NAME, ROW).getRegionLocation().getPort() + 1;
        HRegionLocation loc = conn.getCachedLocation(TABLE_NAME, ROW).getRegionLocation();
        conn.updateCachedLocation(loc.getRegionInfo(), loc.getServerName(), ServerName.valueOf((String)"127.0.0.1", (int)nextPort, (long)Long.MAX_VALUE), Long.MAX_VALUE);
        Assert.assertEquals((long)conn.getCachedLocation(TABLE_NAME, ROW).getRegionLocation().getPort(), (long)nextPort);
        conn.clearRegionCache(TABLE_NAME, (byte[])ROW.clone());
        RegionLocations rl = conn.getCachedLocation(TABLE_NAME, ROW);
        Assert.assertNull((String)("What is this location?? " + rl), (Object)rl);
        conn.clearRegionCache(TABLE_NAME);
        Assert.assertEquals((long)0L, (long)conn.getNumberOfCachedRegionLocations(TABLE_NAME));
        Put put2 = new Put(ROW);
        put2.add(FAM_NAM, ROW, ROW);
        table.put(put2);
        Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, ROW));
        Assert.assertNotNull((Object)conn.getCachedLocation(TableName.valueOf((byte[])TABLE_NAME.getName()), (byte[])ROW.clone()));
        TEST_UTIL.getHBaseAdmin().setBalancerRunning(false, false);
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        while (master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        HRegionLocation toMove = conn.getCachedLocation(TABLE_NAME, ROW).getRegionLocation();
        byte[] regionName = toMove.getRegionInfo().getRegionName();
        byte[] encodedRegionNameBytes = toMove.getRegionInfo().getEncodedNameAsBytes();
        int curServerId = TEST_UTIL.getHBaseCluster().getServerWith(regionName);
        int destServerId = curServerId == 0 ? 1 : 0;
        HRegionServer curServer = TEST_UTIL.getHBaseCluster().getRegionServer(curServerId);
        HRegionServer destServer = TEST_UTIL.getHBaseCluster().getRegionServer(destServerId);
        ServerName destServerName = destServer.getServerName();
        Assert.assertTrue((curServer != destServer ? 1 : 0) != 0);
        Assert.assertFalse((boolean)curServer.getServerName().equals((Object)destServer.getServerName()));
        Assert.assertFalse((toMove.getPort() == destServerName.getPort() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)curServer.getOnlineRegion(regionName));
        Assert.assertNull((Object)destServer.getOnlineRegion(regionName));
        Assert.assertFalse((boolean)TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition());
        LOG.info((Object)("Move starting region=" + toMove.getRegionInfo().getRegionNameAsString()));
        TEST_UTIL.getHBaseAdmin().move(toMove.getRegionInfo().getEncodedNameAsBytes(), destServerName.getServerName().getBytes());
        while (destServer.getOnlineRegion(regionName) == null || destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        LOG.info((Object)("Move finished for region=" + toMove.getRegionInfo().getRegionNameAsString()));
        Assert.assertNull((Object)curServer.getOnlineRegion(regionName));
        Assert.assertNotNull((Object)destServer.getOnlineRegion(regionName));
        Assert.assertFalse((boolean)destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        Assert.assertFalse((boolean)curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        Assert.assertFalse((conn.getCachedLocation(TABLE_NAME, ROW).getRegionLocation().getPort() == destServerName.getPort() ? 1 : 0) != 0);
        LOG.info((Object)"Put starting");
        Put put3 = new Put(ROW);
        put3.add(FAM_NAM, ROW, ROW);
        try {
            table.put(put3);
            Assert.fail((String)"Unreachable point");
        }
        catch (RetriesExhaustedWithDetailsException e) {
            LOG.info((Object)("Put done, exception caught: " + ((Object)((Object)e)).getClass()));
            Assert.assertEquals((long)1L, (long)e.getNumExceptions());
            Assert.assertEquals((long)1L, (long)e.getCauses().size());
            Assert.assertArrayEquals((byte[])e.getRow(0).getRow(), (byte[])ROW);
            Throwable cause = ClientExceptionsUtil.findException((Object)e.getCause(0));
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof RegionMovedException));
        }
        Assert.assertNotNull((String)"Cached connection is null", (Object)conn.getCachedLocation(TABLE_NAME, ROW));
        Assert.assertEquals((String)("Previous server was " + curServer.getServerName().getHostAndPort()), (long)destServerName.getPort(), (long)conn.getCachedLocation(TABLE_NAME, ROW).getRegionLocation().getPort());
        Assert.assertFalse((boolean)destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        Assert.assertFalse((boolean)curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
        LOG.info((Object)("Move starting region=" + toMove.getRegionInfo().getRegionNameAsString()));
        TEST_UTIL.getHBaseAdmin().move(toMove.getRegionInfo().getEncodedNameAsBytes(), curServer.getServerName().getServerName().getBytes());
        while (curServer.getOnlineRegion(regionName) == null || destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
            Thread.sleep(1L);
        }
        Assert.assertNotNull((Object)curServer.getOnlineRegion(regionName));
        Assert.assertNull((Object)destServer.getOnlineRegion(regionName));
        LOG.info((Object)("Move finished for region=" + toMove.getRegionInfo().getRegionNameAsString()));
        Assert.assertFalse((conn.getCachedLocation(TABLE_NAME, ROW).getRegionLocation().getPort() == curServer.getServerName().getPort() ? 1 : 0) != 0);
        Scan sc = new Scan();
        sc.setStopRow(ROW);
        sc.setStartRow(ROW);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        try {
            ResultScanner rs = table.getScanner(sc);
            while (rs.next() != null) {
            }
            Assert.fail((String)"Unreachable point");
        }
        catch (RetriesExhaustedException e) {
            LOG.info((Object)("Scan done, expected exception caught: " + ((Object)((Object)e)).getClass()));
        }
        Assert.assertNotNull((Object)conn.getCachedLocation(TABLE_NAME, ROW));
        Assert.assertEquals((String)("Previous server was " + destServer.getServerName().getHostAndPort()), (long)curServer.getServerName().getPort(), (long)conn.getCachedLocation(TABLE_NAME, ROW).getRegionLocation().getPort());
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 31);
        table.close();
    }

    @Test
    public void testConnectionManagement() throws Exception {
        HTable table0 = TEST_UTIL.createTable(TABLE_NAME1, FAM_NAM);
        Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
        HTable table = (HTable)conn.getTable(TABLE_NAME1);
        table.close();
        Assert.assertFalse((boolean)conn.isClosed());
        Assert.assertFalse((boolean)table.getPool().isShutdown());
        table = (HTable)conn.getTable(TABLE_NAME1);
        table.close();
        Assert.assertFalse((boolean)table.getPool().isShutdown());
        conn.close();
        Assert.assertTrue((boolean)table.getPool().isShutdown());
        table0.close();
    }

    @Test
    public void testCacheSeqNums() throws Exception {
        HTable table = TEST_UTIL.createMultiRegionTable(TABLE_NAME2, FAM_NAM);
        Put put = new Put(ROW);
        put.add(FAM_NAM, ROW, ROW);
        table.put(put);
        ConnectionManager.HConnectionImplementation conn = (ConnectionManager.HConnectionImplementation)table.getConnection();
        HRegionLocation location = conn.getCachedLocation(TABLE_NAME2, ROW).getRegionLocation();
        Assert.assertNotNull((Object)location);
        ServerName anySource = ServerName.valueOf((String)location.getHostname(), (int)(location.getPort() - 1), (long)0L);
        int nextPort = location.getPort() + 1;
        conn.updateCachedLocation(location.getRegionInfo(), location.getServerName(), ServerName.valueOf((String)"127.0.0.1", (int)nextPort, (long)0L), location.getSeqNum() - 1L);
        location = conn.getCachedLocation(TABLE_NAME2, ROW).getRegionLocation();
        Assert.assertEquals((long)nextPort, (long)location.getPort());
        nextPort = location.getPort() + 1;
        conn.updateCachedLocation(location.getRegionInfo(), location.getServerName(), ServerName.valueOf((String)"127.0.0.1", (int)nextPort, (long)0L), location.getSeqNum() - 1L);
        location = conn.getCachedLocation(TABLE_NAME2, ROW).getRegionLocation();
        Assert.assertEquals((long)nextPort, (long)location.getPort());
        nextPort = location.getPort() + 1;
        conn.updateCachedLocation(location.getRegionInfo(), anySource, ServerName.valueOf((String)"127.0.0.1", (int)nextPort, (long)0L), location.getSeqNum() + 1L);
        location = conn.getCachedLocation(TABLE_NAME2, ROW).getRegionLocation();
        Assert.assertEquals((long)nextPort, (long)location.getPort());
        nextPort = location.getPort() + 1;
        conn.updateCachedLocation(location.getRegionInfo(), anySource, ServerName.valueOf((String)"127.0.0.1", (int)nextPort, (long)0L), location.getSeqNum() - 1L);
        location = conn.getCachedLocation(TABLE_NAME2, ROW).getRegionLocation();
        Assert.assertEquals((long)(nextPort - 1), (long)location.getPort());
        table.close();
    }

    @Test
    public void testConnectionSameness() throws Exception {
        HConnection previousConnection = null;
        for (int i = 0; i < 2; ++i) {
            Configuration configuration = TEST_UTIL.getConfiguration();
            configuration.set("some_key", String.valueOf(_randy.nextInt()));
            LOG.info((Object)("The hash code of the current configuration is: " + configuration.hashCode()));
            HConnection currentConnection = HConnectionManager.getConnection((Configuration)configuration);
            if (previousConnection != null) {
                Assert.assertTrue((String)"Did not get the same connection even though its key didn't change", (previousConnection == currentConnection ? 1 : 0) != 0);
            }
            previousConnection = currentConnection;
            configuration.set("other_key", String.valueOf(_randy.nextInt()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Test
    public void testConnectionUniqueness() throws Exception {
        int zkmaxconnections = TEST_UTIL.getConfiguration().getInt("hbase.zookeeper.property.maxClientCnxns", 300);
        int maxConnections = Math.min(zkmaxconnections - 1, 20);
        ArrayList<HConnection> connections = new ArrayList<HConnection>(maxConnections);
        HConnection previousConnection = null;
        try {
            for (int i = 0; i < maxConnections; ++i) {
                Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
                configuration.set("some_key", String.valueOf(_randy.nextInt()));
                configuration.set("hbase.client.instance.id", String.valueOf(_randy.nextInt()));
                LOG.info((Object)("The hash code of the current configuration is: " + configuration.hashCode()));
                HConnection currentConnection = HConnectionManager.getConnection((Configuration)configuration);
                if (previousConnection != null) {
                    Assert.assertTrue((String)"Got the same connection even though its key changed!", (previousConnection != currentConnection ? 1 : 0) != 0);
                }
                configuration.set("other_key", String.valueOf(_randy.nextInt()));
                previousConnection = currentConnection;
                LOG.info((Object)("The current HConnectionManager#HBASE_INSTANCES cache size is: " + TestHCM.getHConnectionManagerCacheSize()));
                Thread.sleep(50L);
                connections.add(currentConnection);
            }
        }
        finally {
            for (Connection connection : connections) {
                HConnectionManager.deleteConnection((Configuration)connection.getConfiguration());
            }
        }
    }

    @Test
    public void testClosing() throws Exception {
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        configuration.set("hbase.client.instance.id", String.valueOf(_randy.nextInt()));
        Connection c1 = ConnectionFactory.createConnection((Configuration)configuration);
        Connection c2 = ConnectionFactory.createConnection((Configuration)configuration);
        HConnection c3 = HConnectionManager.getConnection((Configuration)configuration);
        HConnection c4 = HConnectionManager.getConnection((Configuration)configuration);
        Assert.assertTrue((c3 == c4 ? 1 : 0) != 0);
        c1.close();
        Assert.assertTrue((boolean)c1.isClosed());
        Assert.assertFalse((boolean)c2.isClosed());
        Assert.assertFalse((boolean)c3.isClosed());
        c3.close();
        Assert.assertFalse((boolean)c3.isClosed());
        c3.close();
        Assert.assertTrue((boolean)c3.isClosed());
        HConnection c5 = HConnectionManager.getConnection((Configuration)configuration);
        Assert.assertTrue((c5 != c3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)c2.isClosed());
        c2.close();
        Assert.assertTrue((boolean)c2.isClosed());
        c5.close();
        Assert.assertTrue((boolean)c5.isClosed());
    }

    @Test
    public void testCreateConnection() throws Exception {
        Connection c2;
        Configuration configuration = TEST_UTIL.getConfiguration();
        Connection c1 = ConnectionFactory.createConnection((Configuration)configuration);
        Assert.assertTrue((c1 != (c2 = ConnectionFactory.createConnection((Configuration)configuration)) ? 1 : 0) != 0);
        Assert.assertTrue((c1.getConfiguration() == c2.getConfiguration() ? 1 : 0) != 0);
        HConnection c3 = HConnectionManager.getConnection((Configuration)configuration);
        Assert.assertTrue((c1 != c3 ? 1 : 0) != 0);
        Assert.assertTrue((c2 != c3 ? 1 : 0) != 0);
    }

    @Test
    public void testConnection() throws Exception {
        Configuration c = new Configuration();
        c.set("hbase.zookeeper.quorum", TEST_UTIL.getConfiguration().get("hbase.zookeeper.quorum"));
        c.set("hbase.zookeeper.property.clientPort", TEST_UTIL.getConfiguration().get("hbase.zookeeper.property.clientPort"));
        HConnection conn = HConnectionManager.getConnection((Configuration)c);
        Assert.assertTrue((boolean)conn.isMasterRunning());
        conn.close();
    }

    private int setNumTries(ConnectionManager.HConnectionImplementation hci, int newVal) throws Exception {
        Field numTries = hci.getClass().getDeclaredField("numTries");
        numTries.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(numTries, numTries.getModifiers() & 0xFFFFFFEF);
        int prevNumRetriesVal = (Integer)numTries.get(hci);
        numTries.set(hci, newVal);
        return prevNumRetriesVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMulti() throws Exception {
        try (HTable table = TEST_UTIL.createMultiRegionTable(TABLE_NAME3, FAM_NAM);){
            ConnectionManager.HConnectionImplementation conn = (ConnectionManager.HConnectionImplementation)table.getConnection();
            conn.clearRegionCache(TABLE_NAME3);
            Assert.assertEquals((long)0L, (long)conn.getNumberOfCachedRegionLocations(TABLE_NAME3));
            TEST_UTIL.getHBaseAdmin().setBalancerRunning(false, false);
            HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
            while (master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
                Thread.sleep(1L);
            }
            Put put = new Put(ROW_X);
            put.add(FAM_NAM, ROW_X, ROW_X);
            table.put(put);
            HRegionLocation toMove = conn.getCachedLocation(TABLE_NAME3, ROW_X).getRegionLocation();
            byte[] regionName = toMove.getRegionInfo().getRegionName();
            byte[] encodedRegionNameBytes = toMove.getRegionInfo().getEncodedNameAsBytes();
            int curServerId = TEST_UTIL.getHBaseCluster().getServerWith(regionName);
            int destServerId = curServerId == 0 ? 1 : 0;
            HRegionServer curServer = TEST_UTIL.getHBaseCluster().getRegionServer(curServerId);
            HRegionServer destServer = TEST_UTIL.getHBaseCluster().getRegionServer(destServerId);
            ServerName destServerName = destServer.getServerName();
            List regions = curServer.getOnlineRegions(TABLE_NAME3);
            byte[] otherRow = null;
            for (Region region : regions) {
                if (region.getRegionInfo().getEncodedName().equals(toMove.getRegionInfo().getEncodedName()) || Bytes.BYTES_COMPARATOR.compare(region.getRegionInfo().getStartKey(), ROW_X) >= 0) continue;
                otherRow = region.getRegionInfo().getStartKey();
                break;
            }
            Assert.assertNotNull(otherRow);
            if (otherRow.length <= 0) {
                otherRow = Bytes.toBytes((String)"aaa");
            }
            Put put2 = new Put(otherRow);
            put2.add(FAM_NAM, otherRow, otherRow);
            table.put(put2);
            Assert.assertTrue((curServer != destServer ? 1 : 0) != 0);
            Assert.assertNotEquals((Object)curServer.getServerName(), (Object)destServer.getServerName());
            Assert.assertNotEquals((long)toMove.getPort(), (long)destServerName.getPort());
            Assert.assertNotNull((Object)curServer.getOnlineRegion(regionName));
            Assert.assertNull((Object)destServer.getOnlineRegion(regionName));
            Assert.assertFalse((boolean)TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionStates().isRegionsInTransition());
            LOG.info((Object)("Move starting region=" + toMove.getRegionInfo().getRegionNameAsString()));
            TEST_UTIL.getHBaseAdmin().move(toMove.getRegionInfo().getEncodedNameAsBytes(), destServerName.getServerName().getBytes());
            while (destServer.getOnlineRegion(regionName) == null || destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes) || master.getAssignmentManager().getRegionStates().isRegionsInTransition()) {
                Thread.sleep(1L);
            }
            LOG.info((Object)("Move finished for region=" + toMove.getRegionInfo().getRegionNameAsString()));
            Assert.assertNull((Object)curServer.getOnlineRegion(regionName));
            Assert.assertNotNull((Object)destServer.getOnlineRegion(regionName));
            Assert.assertFalse((boolean)destServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
            Assert.assertFalse((boolean)curServer.getRegionsInTransitionInRS().containsKey(encodedRegionNameBytes));
            Assert.assertFalse((conn.getCachedLocation(TABLE_NAME3, ROW_X).getRegionLocation().getPort() == destServerName.getPort() ? 1 : 0) != 0);
            int prevNumRetriesVal = this.setNumTries(conn, 2);
            Put put3 = new Put(ROW_X);
            put3.add(FAM_NAM, ROW_X, ROW_X);
            Put put4 = new Put(otherRow);
            put4.add(FAM_NAM, otherRow, otherRow);
            table.batch((List)Lists.newArrayList((Object[])new Put[]{put4, put3}));
            this.setNumTries(conn, prevNumRetriesVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testErrorBackoffTimeCalculation() throws Exception {
        long ANY_PAUSE = 100L;
        ServerName location = ServerName.valueOf((String)"127.0.0.1", (int)1, (long)0L);
        ServerName diffLocation = ServerName.valueOf((String)"127.0.0.1", (int)2, (long)0L);
        ManualEnvironmentEdge timeMachine = new ManualEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)timeMachine);
        try {
            long timeBase = timeMachine.currentTime();
            long largeAmountOfTime = 100000L;
            ConnectionManager.ServerErrorTracker tracker = new ConnectionManager.ServerErrorTracker(largeAmountOfTime, 100);
            Assert.assertEquals((long)0L, (long)tracker.calculateBackoffTime(location, 100L));
            tracker.reportServerError(location);
            TestHCM.assertEqualsWithJitter(100L * (long)HConstants.RETRY_BACKOFF[0], tracker.calculateBackoffTime(location, 100L));
            tracker.reportServerError(location);
            tracker.reportServerError(location);
            tracker.reportServerError(location);
            TestHCM.assertEqualsWithJitter(100L * (long)HConstants.RETRY_BACKOFF[3], tracker.calculateBackoffTime(location, 100L));
            Assert.assertEquals((long)0L, (long)tracker.calculateBackoffTime(diffLocation, 100L));
            tracker.reportServerError(diffLocation);
            TestHCM.assertEqualsWithJitter(100L * (long)HConstants.RETRY_BACKOFF[0], tracker.calculateBackoffTime(diffLocation, 100L));
            TestHCM.assertEqualsWithJitter(200L * (long)HConstants.RETRY_BACKOFF[3], tracker.calculateBackoffTime(location, 200L));
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private static void assertEqualsWithJitter(long expected, long actual) {
        TestHCM.assertEqualsWithJitter(expected, actual, expected);
    }

    private static void assertEqualsWithJitter(long expected, long actual, long jitterBase) {
        Assert.assertTrue((String)("Value not within jitter: " + expected + " vs " + actual), ((float)Math.abs(actual - expected) <= 0.01f * (float)jitterBase ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Flakey test: See HBASE-8996")
    @Test
    public void testDeleteForZKConnLeak() throws Exception {
        TEST_UTIL.createTable(TABLE_NAME4, FAM_NAM);
        final Configuration config = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        config.setInt("zookeeper.recovery.retry", 1);
        config.setInt("zookeeper.recovery.retry.intervalmill", 1000);
        config.setInt("hbase.rpc.timeout", 2000);
        config.setInt("hbase.client.retries.number", 1);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, 10, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"test-hcm-delete"));
        pool.submit(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        HConnection conn = HConnectionManager.getConnection((Configuration)config);
                        LOG.info((Object)("Connection " + conn));
                        HConnectionManager.deleteStaleConnection((HConnection)conn);
                        LOG.info((Object)("Connection closed " + conn));
                        Threads.sleep((long)10L);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        for (int i = 0; i < 30; ++i) {
            ClusterConnection c1 = null;
            try {
                c1 = ConnectionManager.getConnectionInternal((Configuration)config);
                LOG.info((Object)("HTable connection " + i + " " + c1));
                HTable table = new HTable(config, TABLE_NAME4, (ExecutorService)pool);
                table.close();
                LOG.info((Object)("HTable connection " + i + " closed " + c1));
                continue;
            }
            catch (Exception e) {
                LOG.info((Object)"We actually want this to happen!!!!  So we can see if we are leaking zk", (Throwable)e);
                continue;
            }
            finally {
                if (c1 != null) {
                    if (c1.isClosed()) {
                        Field zkwField = c1.getClass().getDeclaredField("keepAliveZookeeper");
                        zkwField.setAccessible(true);
                        Object watcher = zkwField.get(c1);
                        if (watcher != null && ((ZooKeeperWatcher)watcher).getRecoverableZooKeeper().getState().isAlive()) {
                            Thread.sleep(1000L);
                            if (((ZooKeeperWatcher)watcher).getRecoverableZooKeeper().getState().isAlive()) {
                                pool.shutdownNow();
                                Assert.fail((String)"Live zookeeper in closed connection");
                            }
                        }
                    }
                    c1.close();
                }
            }
        }
        pool.shutdownNow();
    }

    @Test
    public void testConnectionRideOverClusterRestart() throws IOException, InterruptedException {
        Configuration config = new Configuration(TEST_UTIL.getConfiguration());
        TableName tableName = TableName.valueOf((String)"testConnectionRideOverClusterRestart");
        TEST_UTIL.createTable(tableName.getName(), (byte[][])new byte[][]{FAM_NAM}, config).close();
        Connection connection = ConnectionFactory.createConnection((Configuration)config);
        Table table = connection.getTable(tableName);
        table.get(new Get(Bytes.toBytes((String)"foo")));
        TEST_UTIL.shutdownMiniHBaseCluster();
        TEST_UTIL.restartHBaseCluster(2);
        table.get(new Get(Bytes.toBytes((String)"foo")));
        TEST_UTIL.deleteTable(tableName);
        table.close();
        connection.close();
    }

    public static class BlockingFilter
    extends FilterBase {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean filterRowKey(byte[] buffer, int offset, int length) throws IOException {
            int i = 0;
            while (i++ < 1000 && !syncBlockingFilter.get()) {
                AtomicBoolean atomicBoolean = syncBlockingFilter;
                synchronized (atomicBoolean) {
                    syncBlockingFilter.notifyAll();
                }
                Threads.sleep((long)100L);
            }
            syncBlockingFilter.set(true);
            return false;
        }

        public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
            return Filter.ReturnCode.INCLUDE;
        }

        public static Filter parseFrom(byte[] pbBytes) throws DeserializationException {
            return new BlockingFilter();
        }
    }

    public static class SleepCoprocessor
    extends BaseRegionObserver {
        public static final int SLEEP_TIME = 5000;

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            Threads.sleep((long)5000L);
        }
    }

    public static class SleepAndFailFirstTime
    extends BaseRegionObserver {
        static final AtomicLong ct = new AtomicLong(0L);
        static final String SLEEP_TIME_CONF_KEY = "hbase.coprocessor.SleepAndFailFirstTime.sleepTime";
        static final long DEFAULT_SLEEP_TIME = 20000L;
        static final AtomicLong sleepTime = new AtomicLong(20000L);

        public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
            Configuration conf = env.getConfiguration();
            sleepTime.set(conf.getLong(SLEEP_TIME_CONF_KEY, 20000L));
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            Threads.sleep((long)sleepTime.get());
            if (ct.incrementAndGet() == 1L) {
                throw new IOException("first call I fail");
            }
        }
    }
}

