/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.string;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.piggybank.evaluation.string.HashFNV1;
import org.apache.pig.piggybank.evaluation.string.HashFNV2;

public class HashFNV
extends EvalFunc<Long> {
    static final int FNV1_32_INIT = 0x2000023;
    static final int FNV_32_PRIME = 16777619;

    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 15));
        }
        catch (Exception e) {
            return null;
        }
    }

    long hashFnv32Init(int init, String s) {
        int hval = init;
        byte[] bytes = null;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        for (int i = 0; i < bytes.length; ++i) {
            hval *= 16777619;
            hval ^= bytes[i];
        }
        return hval;
    }

    long hashFnv32(String s) {
        return this.hashFnv32Init(0x2000023, s);
    }

    public Long exec(Tuple input) throws IOException {
        throw new IOException("HashFNV: internal error, try to use HashFNV directly");
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(HashFNV1.class.getName(), s));
        s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 10));
        funcList.add(new FuncSpec(HashFNV2.class.getName(), s));
        return funcList;
    }
}

