/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.ContainerBatchIterator;
import org.roaringbitmap.Util;

public class ArrayBatchIterator
implements ContainerBatchIterator {
    private int index = 0;
    private final ArrayContainer array;

    public ArrayBatchIterator(ArrayContainer array) {
        this.array = array;
    }

    @Override
    public int next(int key, int[] buffer) {
        int consumed = 0;
        short[] data = this.array.content;
        while (consumed < buffer.length && this.index < this.array.getCardinality()) {
            buffer[consumed++] = key + Util.toIntUnsigned(data[this.index++]);
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.getCardinality();
    }

    @Override
    public ContainerBatchIterator clone() {
        try {
            return (ContainerBatchIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

