/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;

public class TezJobSplitWriter {
    private static final Log LOG = LogFactory.getLog(TezJobSplitWriter.class);
    private static final int splitVersion = 1;
    private static final byte[] SPLIT_FILE_HEADER;
    static final byte[] META_SPLIT_FILE_HEADER;

    public static void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, InputSplit[] splits, MRRuntimeProtos.MRSplitsProto splitsProto) throws IOException, InterruptedException {
        FSDataOutputStream out = TezJobSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile((Path)jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = TezJobSplitWriter.writeSplits(conf, splits, out, splitsProto);
        out.close();
        TezJobSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile((Path)jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    private static FSDataOutputStream createFile(FileSystem fs, Path splitFile, Configuration job) throws IOException {
        FSDataOutputStream out = FileSystem.create((FileSystem)fs, (Path)splitFile, (FsPermission)new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
        int replication = job.getInt("mapreduce.client.submit.file.replication", 10);
        fs.setReplication(splitFile, (short)replication);
        TezJobSplitWriter.writeSplitHeader(out);
        return out;
    }

    private static void writeSplitHeader(FSDataOutputStream out) throws IOException {
        out.write(SPLIT_FILE_HEADER);
        out.writeInt(1);
    }

    private static JobSplit.SplitMetaInfo[] writeSplits(Configuration conf, InputSplit[] inputSplits, FSDataOutputStream out, MRRuntimeProtos.MRSplitsProto splitsProto) throws IOException, InterruptedException {
        JobSplit.SplitMetaInfo[] info = null;
        if (inputSplits.length != 0) {
            info = new JobSplit.SplitMetaInfo[inputSplits.length];
            SerializationFactory factory = new SerializationFactory(conf);
            int maxBlockLocations = conf.getInt("mapreduce.job.max.split.locations", 10);
            long offset = out.getPos();
            int i = 0;
            for (MRRuntimeProtos.MRSplitProto splitProto : splitsProto.getSplitsList()) {
                long prevCount = out.getPos();
                Text.writeString((DataOutput)out, (String)splitProto.getSplitClassName());
                splitProto.getSplitBytes().writeTo((OutputStream)out);
                info[i] = TezJobSplitWriter.createSplitMetaInfo(inputSplits[i], offset, maxBlockLocations);
                ++i;
                offset += out.getPos() - prevCount;
            }
            while (i < inputSplits.length) {
                long prevCount = out.getPos();
                Text.writeString((DataOutput)out, (String)inputSplits[i].getClass().getName());
                Serializer serializer = factory.getSerializer(inputSplits[i].getClass());
                serializer.open((OutputStream)out);
                serializer.serialize((Object)inputSplits[i]);
                info[i] = TezJobSplitWriter.createSplitMetaInfo(inputSplits[i], offset, maxBlockLocations);
                ++i;
                offset += out.getPos() - prevCount;
            }
        }
        LOG.info((Object)("Size of serialized job.split file is " + out.getPos()));
        return info;
    }

    private static <T extends InputSplit> JobSplit.SplitMetaInfo createSplitMetaInfo(T split, long offset, int maxBlockLocations) throws IOException, InterruptedException {
        String[] locations = split.getLocations();
        if (locations.length > maxBlockLocations) {
            LOG.warn((Object)("Max block location exceeded for split: " + split + " splitsize: " + locations.length + " maxsize: " + maxBlockLocations));
            locations = Arrays.copyOf(locations, maxBlockLocations);
        }
        return new JobSplit.SplitMetaInfo(locations, offset, split.getLength());
    }

    private static void writeJobSplitMetaInfo(FileSystem fs, Path filename, FsPermission p, int splitMetaInfoVersion, JobSplit.SplitMetaInfo[] allSplitMetaInfo) throws IOException {
        FSDataOutputStream out = FileSystem.create((FileSystem)fs, (Path)filename, (FsPermission)p);
        out.write(META_SPLIT_FILE_HEADER);
        WritableUtils.writeVInt((DataOutput)out, (int)splitMetaInfoVersion);
        WritableUtils.writeVInt((DataOutput)out, (int)allSplitMetaInfo.length);
        for (JobSplit.SplitMetaInfo splitMetaInfo : allSplitMetaInfo) {
            splitMetaInfo.write((DataOutput)out);
        }
        out.close();
    }

    static {
        try {
            SPLIT_FILE_HEADER = "SPL".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
        try {
            META_SPLIT_FILE_HEADER = "META-SPL".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }
}

