/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreMetadata;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputFormat;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Pair;

public class PigOutputCommitter
extends OutputCommitter {
    List<Pair<OutputCommitter, POStore>> mapOutputCommitters;
    List<Pair<OutputCommitter, POStore>> reduceOutputCommitters;
    boolean recoverySupported;

    public PigOutputCommitter(TaskAttemptContext context, List<POStore> mapStores, List<POStore> reduceStores) throws IOException {
        this.mapOutputCommitters = this.getCommitters(context, mapStores);
        this.reduceOutputCommitters = this.getCommitters(context, reduceStores);
        this.recoverySupported = context.getConfiguration().getBoolean("pig.output.committer.recovery.support", false);
    }

    private List<Pair<OutputCommitter, POStore>> getCommitters(TaskAttemptContext context, List<POStore> stores) throws IOException {
        ArrayList<Pair<OutputCommitter, POStore>> committers = new ArrayList<Pair<OutputCommitter, POStore>>();
        for (POStore store : stores) {
            StoreFuncInterface sFunc = store.getStoreFunc();
            TaskAttemptContext updatedContext = this.setUpContext(context, store);
            try {
                committers.add(new Pair<OutputCommitter, POStore>(sFunc.getOutputFormat().getOutputCommitter(updatedContext), store));
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        return committers;
    }

    private TaskAttemptContext setUpContext(TaskAttemptContext context, POStore store) throws IOException {
        MapRedUtil.setupUDFContext(context.getConfiguration());
        TaskAttemptContext contextCopy = HadoopShims.createTaskAttemptContext(context.getConfiguration(), context.getTaskAttemptID());
        PigOutputFormat.setLocation((JobContext)contextCopy, store);
        return contextCopy;
    }

    public static JobContext setUpContext(JobContext context, POStore store) throws IOException {
        JobContext contextCopy = HadoopShims.createJobContext(context.getConfiguration(), context.getJobID());
        MapRedUtil.setupUDFContext(context.getConfiguration());
        PigOutputFormat.setLocation(contextCopy, store);
        return contextCopy;
    }

    public static void storeCleanup(POStore store, Configuration conf) throws IOException {
        Schema schema;
        StoreFuncInterface storeFunc = store.getStoreFunc();
        if (storeFunc instanceof StoreMetadata && (schema = store.getSchema()) != null) {
            ((StoreMetadata)((Object)storeFunc)).storeSchema(new ResourceSchema(schema, store.getSortInfo()), store.getSFile().getFileName(), new Job(conf));
        }
    }

    public boolean isRecoverySupported() {
        if (!this.recoverySupported) {
            return false;
        }
        boolean allOutputCommitterSupportRecovery = true;
        for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
            if (mapCommitter.first == null) continue;
            try {
                allOutputCommitterSupportRecovery = allOutputCommitterSupportRecovery && ((OutputCommitter)mapCommitter.first).isRecoverySupported();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (allOutputCommitterSupportRecovery) continue;
            return false;
        }
        for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
            if (reduceCommitter.first == null) continue;
            try {
                allOutputCommitterSupportRecovery = allOutputCommitterSupportRecovery && ((OutputCommitter)reduceCommitter.first).isRecoverySupported();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (allOutputCommitterSupportRecovery) continue;
            return false;
        }
        return true;
    }

    public void recoverTask(TaskAttemptContext context) throws IOException {
        TaskAttemptContext updatedContext;
        for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
            if (mapCommitter.first == null) continue;
            updatedContext = this.setUpContext(context, (POStore)mapCommitter.second);
            try {
                ((OutputCommitter)mapCommitter.first).recoverTask(updatedContext);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
            if (reduceCommitter.first == null) continue;
            updatedContext = this.setUpContext(context, (POStore)reduceCommitter.second);
            try {
                ((OutputCommitter)reduceCommitter.first).recoverTask(updatedContext);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void cleanupJob(JobContext context) throws IOException {
        JobContext updatedContext;
        for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
            if (mapCommitter.first == null) continue;
            updatedContext = PigOutputCommitter.setUpContext(context, (POStore)mapCommitter.second);
            PigOutputCommitter.storeCleanup((POStore)mapCommitter.second, updatedContext.getConfiguration());
            ((OutputCommitter)mapCommitter.first).cleanupJob(updatedContext);
        }
        for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
            if (reduceCommitter.first == null) continue;
            updatedContext = PigOutputCommitter.setUpContext(context, (POStore)reduceCommitter.second);
            PigOutputCommitter.storeCleanup((POStore)reduceCommitter.second, updatedContext.getConfiguration());
            ((OutputCommitter)reduceCommitter.first).cleanupJob(updatedContext);
        }
    }

    public void commitJob(JobContext context) throws IOException {
        JobContext updatedContext;
        for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
            if (mapCommitter.first == null) continue;
            updatedContext = PigOutputCommitter.setUpContext(context, (POStore)mapCommitter.second);
            try {
                ((OutputCommitter)mapCommitter.first).commitJob(updatedContext);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            PigOutputCommitter.storeCleanup((POStore)mapCommitter.second, updatedContext.getConfiguration());
        }
        for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
            if (reduceCommitter.first == null) continue;
            updatedContext = PigOutputCommitter.setUpContext(context, (POStore)reduceCommitter.second);
            try {
                ((OutputCommitter)reduceCommitter.first).commitJob(updatedContext);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            PigOutputCommitter.storeCleanup((POStore)reduceCommitter.second, updatedContext.getConfiguration());
        }
    }

    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        JobContext updatedContext;
        for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
            if (mapCommitter.first == null) continue;
            updatedContext = PigOutputCommitter.setUpContext(context, (POStore)mapCommitter.second);
            try {
                ((OutputCommitter)mapCommitter.first).abortJob(updatedContext, state);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            PigOutputCommitter.storeCleanup((POStore)mapCommitter.second, updatedContext.getConfiguration());
        }
        for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
            if (reduceCommitter.first == null) continue;
            updatedContext = PigOutputCommitter.setUpContext(context, (POStore)reduceCommitter.second);
            try {
                ((OutputCommitter)reduceCommitter.first).abortJob(updatedContext, state);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            PigOutputCommitter.storeCleanup((POStore)reduceCommitter.second, updatedContext.getConfiguration());
        }
    }

    public void abortTask(TaskAttemptContext context) throws IOException {
        if (HadoopShims.isMap(context.getTaskAttemptID())) {
            for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
                if (mapCommitter.first == null) continue;
                TaskAttemptContext updatedContext = this.setUpContext(context, (POStore)mapCommitter.second);
                ((OutputCommitter)mapCommitter.first).abortTask(updatedContext);
            }
        } else {
            for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
                if (reduceCommitter.first == null) continue;
                TaskAttemptContext updatedContext = this.setUpContext(context, (POStore)reduceCommitter.second);
                ((OutputCommitter)reduceCommitter.first).abortTask(updatedContext);
            }
        }
    }

    public void commitTask(TaskAttemptContext context) throws IOException {
        if (HadoopShims.isMap(context.getTaskAttemptID())) {
            for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
                if (mapCommitter.first == null) continue;
                TaskAttemptContext updatedContext = this.setUpContext(context, (POStore)mapCommitter.second);
                ((OutputCommitter)mapCommitter.first).commitTask(updatedContext);
            }
        } else {
            for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
                if (reduceCommitter.first == null) continue;
                TaskAttemptContext updatedContext = this.setUpContext(context, (POStore)reduceCommitter.second);
                ((OutputCommitter)reduceCommitter.first).commitTask(updatedContext);
            }
        }
    }

    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        boolean needCommit = false;
        if (HadoopShims.isMap(context.getTaskAttemptID())) {
            for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
                if (mapCommitter.first == null) continue;
                TaskAttemptContext updatedContext = this.setUpContext(context, (POStore)mapCommitter.second);
                needCommit = needCommit || ((OutputCommitter)mapCommitter.first).needsTaskCommit(updatedContext);
            }
            return needCommit;
        }
        for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
            if (reduceCommitter.first == null) continue;
            TaskAttemptContext updatedContext = this.setUpContext(context, (POStore)reduceCommitter.second);
            needCommit = needCommit || ((OutputCommitter)reduceCommitter.first).needsTaskCommit(updatedContext);
        }
        return needCommit;
    }

    public void setupJob(JobContext context) throws IOException {
        JobContext updatedContext;
        for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
            if (mapCommitter.first == null) continue;
            updatedContext = PigOutputCommitter.setUpContext(context, (POStore)mapCommitter.second);
            ((OutputCommitter)mapCommitter.first).setupJob(updatedContext);
        }
        for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
            if (reduceCommitter.first == null) continue;
            updatedContext = PigOutputCommitter.setUpContext(context, (POStore)reduceCommitter.second);
            ((OutputCommitter)reduceCommitter.first).setupJob(updatedContext);
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        if (HadoopShims.isMap(context.getTaskAttemptID())) {
            for (Pair<OutputCommitter, POStore> mapCommitter : this.mapOutputCommitters) {
                if (mapCommitter.first == null) continue;
                TaskAttemptContext updatedContext = this.setUpContext(context, (POStore)mapCommitter.second);
                ((OutputCommitter)mapCommitter.first).setupTask(updatedContext);
            }
        } else {
            for (Pair<OutputCommitter, POStore> reduceCommitter : this.reduceOutputCommitters) {
                if (reduceCommitter.first == null) continue;
                TaskAttemptContext updatedContext = this.setUpContext(context, (POStore)reduceCommitter.second);
                ((OutputCommitter)reduceCommitter.first).setupTask(updatedContext);
            }
        }
    }
}

