/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import org.junit.Assert;
import org.junit.Test;

public class TestReadOnly {
    private static final Method[] ALL_METHODS = ClientProtocol.class.getMethods();
    private static final Set<String> READONLY_METHOD_NAMES = new HashSet<String>(Arrays.asList("getBlockLocations", "getServerDefaults", "getStoragePolicies", "getStoragePolicy", "getListing", "getSnapshottableDirListing", "getPreferredBlockSize", "listCorruptFileBlocks", "getFileInfo", "isFileClosed", "getFileLinkInfo", "getContentSummary", "getLinkTarget", "getSnapshotDiffReport", "listCacheDirectives", "listCachePools", "getAclStatus", "getEZForPath", "listEncryptionZones", "getXAttrs", "listXAttrs", "checkAccess", "listOpenFiles", "getStats", "getDatanodeReport", "getDatanodeStorageReport", "getDataEncryptionKey", "getCurrentEditLogTxid", "getEditsFromTxid", "getQuotaUsage", "msync", "getHAServiceState"));

    @Test
    public void testReadOnly() {
        for (Method m : ALL_METHODS) {
            boolean expected = READONLY_METHOD_NAMES.contains(m.getName());
            this.checkIsReadOnly(m.getName(), expected);
        }
    }

    private void checkIsReadOnly(String methodName, boolean expected) {
        for (Method m : ALL_METHODS) {
            if (!m.getName().equals(methodName)) continue;
            Assert.assertEquals((String)("Expected ReadOnly for method '" + methodName + "' to be " + expected), (Object)m.isAnnotationPresent(ReadOnly.class), (Object)expected);
            return;
        }
        throw new IllegalArgumentException("Unknown method name: " + methodName);
    }
}

