/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.MarkableIterator;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestValueIterReset {
    private static final int NUM_MAPS = 1;
    private static final int NUM_TESTS = 4;
    private static final int NUM_VALUES = 40;
    private static Path TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp"));
    private static Configuration conf = new Configuration();
    private static FileSystem localFs;
    private static final Log LOG;

    private static int test0(IntWritable key, MarkableIterator<IntWritable> values) throws IOException {
        IntWritable i;
        int errors = 0;
        ArrayList<IntWritable> expectedValues = new ArrayList<IntWritable>();
        LOG.info((Object)("Executing TEST:0 for Key:" + key.toString()));
        values.mark();
        LOG.info((Object)"TEST:0. Marking");
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            expectedValues.add(i);
            LOG.info((Object)(key + ":" + i));
        }
        values.reset();
        LOG.info((Object)"TEST:0. Reset");
        int count = 0;
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (i != expectedValues.get(count)) {
                LOG.info((Object)("TEST:0. Check:1 Expected: " + expectedValues.get(count) + ", Got: " + i));
                return ++errors;
            }
            ++count;
        }
        LOG.info((Object)"TEST:0 Done");
        return errors;
    }

    private static int test1(IntWritable key, MarkableIterator<IntWritable> values) throws IOException {
        IntWritable i;
        int errors = 0;
        int count = 0;
        ArrayList<IntWritable> expectedValues = new ArrayList<IntWritable>();
        ArrayList<IntWritable> expectedValues1 = new ArrayList<IntWritable>();
        LOG.info((Object)("Executing TEST:1 for Key:" + key));
        values.mark();
        LOG.info((Object)"TEST:1. Marking");
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            expectedValues.add(i);
            if (count == 2) break;
            ++count;
        }
        values.reset();
        LOG.info((Object)"TEST:1. Reset");
        count = 0;
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (count < expectedValues.size() && i != expectedValues.get(count)) {
                LOG.info((Object)("TEST:1. Check:1 Expected: " + expectedValues.get(count) + ", Got: " + i));
                return ++errors;
            }
            if (count == 3) {
                values.mark();
                LOG.info((Object)("TEST:1. Marking -- " + key + ": " + i));
            }
            if (count >= 3) {
                expectedValues1.add(i);
            }
            if (count == 5) break;
            ++count;
        }
        if (count < expectedValues.size()) {
            LOG.info((Object)"TEST:1 Check:2. Iterator returned lesser values");
            return ++errors;
        }
        values.reset();
        count = 0;
        LOG.info((Object)"TEST:1. Reset");
        expectedValues.clear();
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (count < expectedValues1.size() && i != expectedValues1.get(count)) {
                LOG.info((Object)("TEST:1. Check:3 Expected: " + expectedValues1.get(count) + ", Got: " + i));
                return ++errors;
            }
            if (count == 25) {
                values.mark();
                LOG.info((Object)("TEST:1. Marking -- " + key + ":" + i));
            }
            if (count >= 25) {
                expectedValues.add(i);
            }
            ++count;
        }
        if (count < expectedValues1.size()) {
            LOG.info((Object)"TEST:1 Check:4. Iterator returned fewer values");
            return ++errors;
        }
        values.reset();
        LOG.info((Object)"TEST:1. Reset");
        count = 0;
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (i == expectedValues.get(count)) continue;
            LOG.info((Object)("TEST:1. Check:5 Expected: " + expectedValues.get(count) + ", Got: " + i));
            return ++errors;
        }
        LOG.info((Object)"TEST:1 Done");
        return errors;
    }

    private static int test2(IntWritable key, MarkableIterator<IntWritable> values) throws IOException {
        IntWritable i;
        int errors = 0;
        int count = 0;
        ArrayList<IntWritable> expectedValues = new ArrayList<IntWritable>();
        ArrayList<IntWritable> expectedValues1 = new ArrayList<IntWritable>();
        LOG.info((Object)("Executing TEST:2 for Key:" + key));
        values.mark();
        LOG.info((Object)"TEST:2 Marking");
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            expectedValues.add(i);
            if (count == 8) break;
            ++count;
        }
        values.reset();
        count = 0;
        LOG.info((Object)"TEST:2 reset");
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (count < expectedValues.size() && i != expectedValues.get(count)) {
                LOG.info((Object)("TEST:2. Check:1 Expected: " + expectedValues.get(count) + ", Got: " + i));
                return ++errors;
            }
            if (count == 3) {
                values.mark();
                LOG.info((Object)("TEST:2. Marking -- " + key + ":" + i));
            }
            if (count >= 3) {
                expectedValues1.add(i);
            }
            ++count;
        }
        values.reset();
        LOG.info((Object)"TEST:2. Reset");
        expectedValues.clear();
        count = 0;
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (count < expectedValues1.size() && i != expectedValues1.get(count)) {
                LOG.info((Object)("TEST:2. Check:2 Expected: " + expectedValues1.get(count) + ", Got: " + i));
                return ++errors;
            }
            if (count == 20) {
                values.mark();
                LOG.info((Object)("TEST:2. Marking -- " + key + ":" + i));
            }
            if (count >= 20) {
                expectedValues.add(i);
            }
            ++count;
        }
        values.reset();
        count = 0;
        LOG.info((Object)"TEST:2. Reset");
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (i == expectedValues.get(count)) continue;
            LOG.info((Object)("TEST:2. Check:1 Expected: " + expectedValues.get(count) + ", Got: " + i));
            return ++errors;
        }
        LOG.info((Object)"TEST:2 Done");
        return errors;
    }

    private static int test3(IntWritable key, MarkableIterator<IntWritable> values) throws IOException {
        IntWritable i;
        int errors = 0;
        ArrayList<IntWritable> expectedValues = new ArrayList<IntWritable>();
        LOG.info((Object)("Executing TEST:3 for Key:" + key));
        values.mark();
        LOG.info((Object)"TEST:3. Marking");
        int count = 0;
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (count == 5) {
                LOG.info((Object)"TEST:3. Clearing Mark");
                values.clearMark();
            }
            if (count == 8) {
                LOG.info((Object)("TEST:3. Marking -- " + key + ":" + i));
                values.mark();
            }
            if (count >= 8) {
                expectedValues.add(i);
            }
            ++count;
        }
        values.reset();
        LOG.info((Object)"TEST:3. After reset");
        if (!values.hasNext()) {
            LOG.info((Object)"TEST:3, Check:1. HasNext returned false");
            return ++errors;
        }
        count = 0;
        while (values.hasNext()) {
            i = (IntWritable)values.next();
            LOG.info((Object)(key + ":" + i));
            if (count < expectedValues.size() && i != expectedValues.get(count)) {
                LOG.info((Object)("TEST:2. Check:1 Expected: " + expectedValues.get(count) + ", Got: " + i));
                return ++errors;
            }
            if (count == 10) {
                values.clearMark();
                LOG.info((Object)"TEST:3. After clear mark");
            }
            ++count;
        }
        boolean successfulClearMark = false;
        try {
            LOG.info((Object)"TEST:3. Before Reset");
            values.reset();
        }
        catch (IOException e) {
            successfulClearMark = true;
        }
        if (!successfulClearMark) {
            LOG.info((Object)"TEST:3 Check:4 reset was successfule even after clearMark");
            return ++errors;
        }
        LOG.info((Object)"TEST:3 Done.");
        return errors;
    }

    public void createInput() throws Exception {
        for (int i = 0; i < 1; ++i) {
            Path file = new Path(TEST_ROOT_DIR + "/in", "test" + i + ".txt");
            localFs.delete(file, false);
            FSDataOutputStream os = localFs.create(file);
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
            wr.write("dummy");
            ((Writer)wr).close();
        }
    }

    @Test
    public void testValueIterReset() {
        try {
            Configuration conf = new Configuration();
            Job job = Job.getInstance((Configuration)conf, (String)"TestValueIterReset");
            job.setJarByClass(TestValueIterReset.class);
            job.setMapperClass(TestMapper.class);
            job.setReducerClass(TestReducer.class);
            job.setNumReduceTasks(4);
            job.setMapOutputKeyClass(IntWritable.class);
            job.setMapOutputValueClass(IntWritable.class);
            job.setOutputKeyClass(IntWritable.class);
            job.setOutputValueClass(IntWritable.class);
            job.getConfiguration().setInt("mapreduce.reduce.markreset.buffer.size", 128);
            job.setInputFormatClass(TextInputFormat.class);
            job.setOutputFormatClass(TextOutputFormat.class);
            FileInputFormat.addInputPath((Job)job, (Path)new Path(TEST_ROOT_DIR + "/in"));
            Path output = new Path(TEST_ROOT_DIR + "/out");
            localFs.delete(output, true);
            FileOutputFormat.setOutputPath((Job)job, (Path)output);
            this.createInput();
            Assert.assertTrue((boolean)job.waitForCompletion(true));
            this.validateOutput();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    private void validateOutput() throws IOException {
        Path[] outputFiles = FileUtil.stat2Paths((FileStatus[])localFs.listStatus(new Path(TEST_ROOT_DIR + "/out"), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        if (outputFiles.length > 0) {
            FSDataInputStream is = localFs.open(outputFiles[0]);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is));
            String line = reader.readLine();
            while (line != null) {
                StringTokenizer tokeniz = new StringTokenizer(line, "\t");
                String key = tokeniz.nextToken();
                String value = tokeniz.nextToken();
                LOG.info((Object)("Output: key: " + key + " value: " + value));
                int errors = Integer.parseInt(value);
                Assert.assertTrue((errors == 0 ? 1 : 0) != 0);
                line = reader.readLine();
            }
            reader.close();
        }
    }

    static {
        try {
            localFs = FileSystem.getLocal((Configuration)conf);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        LOG = LogFactory.getLog(TestValueIterReset.class);
    }

    public static class TestReducer
    extends Reducer<IntWritable, IntWritable, IntWritable, IntWritable> {
        public void reduce(IntWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int errors = 0;
            MarkableIterator mitr = new MarkableIterator(values.iterator());
            switch (key.get()) {
                case 0: {
                    errors += TestValueIterReset.test0(key, (MarkableIterator<IntWritable>)mitr);
                    break;
                }
                case 1: {
                    errors += TestValueIterReset.test1(key, (MarkableIterator<IntWritable>)mitr);
                    break;
                }
                case 2: {
                    errors += TestValueIterReset.test2(key, (MarkableIterator<IntWritable>)mitr);
                    break;
                }
                case 3: {
                    errors += TestValueIterReset.test3(key, (MarkableIterator<IntWritable>)mitr);
                    break;
                }
            }
            context.write((Object)key, (Object)new IntWritable(errors));
        }
    }

    public static class TestMapper
    extends Mapper<LongWritable, Text, IntWritable, IntWritable> {
        public void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            IntWritable outKey = new IntWritable();
            IntWritable outValue = new IntWritable();
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < 40; ++i) {
                    outKey.set(j);
                    outValue.set(i);
                    context.write((Object)outKey, (Object)outValue);
                }
            }
        }
    }
}

