/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metanalysis;

import com.beust.jcommander.Parameter;
import java.util.Map;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;

public class FindTablet {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(FindTablet.class.getName(), args, new Object[0]);
        FindTablet.findContainingTablets(opts);
    }

    private static void findContainingTablets(Opts opts) throws Exception {
        Range range = new KeyExtent(new Text(opts.tableId), null, null).toMetadataRange();
        Scanner scanner = opts.getConnector().createScanner("createEvents", opts.auths);
        scanner.setRange(range);
        Text row = new Text(opts.row);
        for (Map.Entry entry : scanner) {
            KeyExtent ke = new KeyExtent(((Key)entry.getKey()).getRow(), new Value(TextUtil.getBytes((Text)((Key)entry.getKey()).getColumnFamily())));
            if (!ke.contains((BinaryComparable)row)) continue;
            System.out.println(((Key)entry.getKey()).getColumnQualifier() + " " + ke + " " + entry.getValue());
        }
    }

    public static class Opts
    extends ClientOpts {
        @Parameter(names={"-r", "--row"}, required=true, description="find tablets that contain this row")
        String row = null;
        @Parameter(names={"--tableId"}, required=true, description="table id")
        String tableId = null;
    }
}

