/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.audit.log4j.layout;

import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.knox.gateway.audit.log4j.audit.Log4jAuditContext;
import org.apache.knox.gateway.audit.log4j.correlation.Log4jCorrelationContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="AuditLayout", category="Core", elementType="layout", printObject=true)
public class AuditLayout
extends AbstractStringLayout {
    private static final String DATE_PATTERN = "yy/MM/dd HH:mm:ss ";
    private final DateFormat dateFormat;
    private static final Character SEPARATOR = Character.valueOf('|');
    private final StringBuffer sb = new StringBuffer();

    @PluginFactory
    public static AuditLayout createLayout(@PluginAttribute(value="charset", defaultString="UTF-8") Charset charset) {
        return new AuditLayout(charset);
    }

    public AuditLayout(Charset charset) {
        super(charset);
        this.dateFormat = this.dateFormat();
    }

    private SimpleDateFormat dateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN, Locale.getDefault(Locale.Category.FORMAT));
        simpleDateFormat.setTimeZone(TimeZone.getDefault());
        return simpleDateFormat;
    }

    public String toSerializable(LogEvent event) {
        this.sb.setLength(0);
        this.sb.append(this.dateFormat.format(event.getTimeMillis()));
        Log4jCorrelationContext cc = Log4jCorrelationContext.of(event);
        this.appendParameter(cc == null ? null : cc.getRootRequestId());
        this.appendParameter(cc == null ? null : cc.getParentRequestId());
        this.appendParameter(cc == null ? null : cc.getRequestId());
        this.appendParameter(event.getLoggerName());
        Log4jAuditContext ac = Log4jAuditContext.of(event);
        this.appendParameter(ac == null ? null : ac.getRemoteIp());
        this.appendParameter(ac == null ? null : ac.getTargetServiceName());
        this.appendParameter(ac == null ? null : ac.getUsername());
        this.appendParameter(ac == null ? null : ac.getProxyUsername());
        this.appendParameter(ac == null ? null : ac.getSystemUsername());
        ReadOnlyStringMap eventContextData = event.getContextData();
        this.appendParameter((String)eventContextData.getValue("action"));
        this.appendParameter((String)eventContextData.getValue("resource_type"));
        this.appendParameter((String)eventContextData.getValue("resource_name"));
        this.appendParameter((String)eventContextData.getValue("outcome"));
        String message = event.getMessage() == null ? null : event.getMessage().getFormattedMessage();
        this.sb.append(message == null || "null".equals(message) ? "" : message).append(System.lineSeparator());
        return this.sb.toString();
    }

    private void appendParameter(String parameter) {
        if (parameter != null) {
            this.sb.append(parameter);
        }
        this.sb.append(SEPARATOR);
    }
}

