/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.annotation;

import org.apache.juneau.annotation.AnnotationBuilder;
import org.apache.juneau.annotation.AnnotationImpl;
import org.apache.juneau.annotation.ExternalDocs;
import org.apache.juneau.annotation.ExternalDocsAnnotation;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.rest.annotation.OpSwagger;

public class OpSwaggerAnnotation {
    public static final OpSwagger DEFAULT = OpSwaggerAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(OpSwagger a) {
        return a == null || DEFAULT.equals(a);
    }

    public static boolean notEmpty(OpSwagger a) {
        return !OpSwaggerAnnotation.empty(a);
    }

    public static class Builder
    extends AnnotationBuilder {
        ExternalDocs externalDocs = ExternalDocsAnnotation.DEFAULT;
        String deprecated = "";
        String operationId = "";
        String[] consumes = new String[0];
        String[] description = new String[0];
        String[] parameters = new String[0];
        String[] produces = new String[0];
        String[] responses = new String[0];
        String[] schemes = new String[0];
        String[] summary = new String[0];
        String[] tags = new String[0];
        String[] value = new String[0];

        protected Builder() {
            super(OpSwagger.class);
        }

        public OpSwagger build() {
            return new Impl(this);
        }

        public Builder consumes(String ... value) {
            this.consumes = value;
            return this;
        }

        public Builder deprecated(String value) {
            this.deprecated = value;
            return this;
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder externalDocs(ExternalDocs value) {
            this.externalDocs = value;
            return this;
        }

        public Builder operationId(String value) {
            this.operationId = value;
            return this;
        }

        public Builder parameters(String ... value) {
            this.parameters = value;
            return this;
        }

        public Builder produces(String ... value) {
            this.produces = value;
            return this;
        }

        public Builder responses(String ... value) {
            this.responses = value;
            return this;
        }

        public Builder schemes(String ... value) {
            this.schemes = value;
            return this;
        }

        public Builder summary(String ... value) {
            this.summary = value;
            return this;
        }

        public Builder tags(String ... value) {
            this.tags = value;
            return this;
        }

        public Builder value(String ... value) {
            this.value = value;
            return this;
        }
    }

    private static class Impl
    extends AnnotationImpl
    implements OpSwagger {
        private final ExternalDocs externalDocs;
        private final String deprecated;
        private final String operationId;
        private final String[] consumes;
        private final String[] description;
        private final String[] parameters;
        private final String[] produces;
        private final String[] responses;
        private final String[] schemes;
        private final String[] summary;
        private final String[] tags;
        private final String[] value;

        Impl(Builder b) {
            super(b);
            this.consumes = ArrayUtils.copyOf(b.consumes);
            this.deprecated = b.deprecated;
            this.description = ArrayUtils.copyOf(b.description);
            this.externalDocs = b.externalDocs;
            this.operationId = b.operationId;
            this.parameters = ArrayUtils.copyOf(b.parameters);
            this.produces = ArrayUtils.copyOf(b.produces);
            this.responses = ArrayUtils.copyOf(b.responses);
            this.schemes = ArrayUtils.copyOf(b.schemes);
            this.summary = ArrayUtils.copyOf(b.summary);
            this.tags = ArrayUtils.copyOf(b.tags);
            this.value = ArrayUtils.copyOf(b.value);
            this.postConstruct();
        }

        @Override
        public String[] consumes() {
            return this.consumes;
        }

        @Override
        public String deprecated() {
            return this.deprecated;
        }

        @Override
        public String[] description() {
            return this.description;
        }

        @Override
        public ExternalDocs externalDocs() {
            return this.externalDocs;
        }

        @Override
        public String operationId() {
            return this.operationId;
        }

        @Override
        public String[] parameters() {
            return this.parameters;
        }

        @Override
        public String[] produces() {
            return this.produces;
        }

        @Override
        public String[] responses() {
            return this.responses;
        }

        @Override
        public String[] schemes() {
            return this.schemes;
        }

        @Override
        public String[] summary() {
            return this.summary;
        }

        @Override
        public String[] tags() {
            return this.tags;
        }

        @Override
        public String[] value() {
            return this.value;
        }
    }
}

