/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.common.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class PathReaderBuilder {
    private Path path;
    private Charset charset = Charset.defaultCharset();
    private boolean allowNoFile;

    public static PathReaderBuilder create() {
        return new PathReaderBuilder();
    }

    public static PathReaderBuilder create(Path path) {
        return new PathReaderBuilder().path(path);
    }

    public PathReaderBuilder allowNoFile() {
        this.allowNoFile = true;
        return this;
    }

    public Reader build() throws IOException {
        if (!this.allowNoFile && this.path == null) {
            throw new IllegalStateException("No path");
        }
        if (!this.allowNoFile && !Files.exists(this.path, new LinkOption[0])) {
            throw new NoSuchFileException(this.path.toString());
        }
        return this.allowNoFile ? new StringReader("") : Files.newBufferedReader(this.path, this.charset != null ? this.charset : Charset.defaultCharset());
    }

    public PathReaderBuilder charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public PathReaderBuilder charset(String charset) {
        this.charset = charset != null ? Charset.forName(charset) : null;
        return this;
    }

    public PathReaderBuilder path(Path path) {
        this.path = path;
        return this;
    }

    public PathReaderBuilder path(String path) {
        this.path = Paths.get(path, new String[0]);
        return this;
    }
}

