/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.Mnemonic;

public final class Flags {
    private static final Mnemonic HEADER_FLAGS = new Mnemonic("DNS Header Flag", 3);
    public static final byte QR = 0;
    public static final byte AA = 5;
    public static final byte TC = 6;
    public static final byte RD = 7;
    public static final byte RA = 8;
    public static final byte AD = 10;
    public static final byte CD = 11;
    public static final int DO = 32768;

    private Flags() {
    }

    public static String string(int i) {
        return HEADER_FLAGS.getText(i);
    }

    public static int value(String s) {
        return HEADER_FLAGS.getValue(s);
    }

    public static boolean isFlag(int index) {
        HEADER_FLAGS.check(index);
        return (index < 1 || index > 4) && index < 12;
    }

    static {
        HEADER_FLAGS.setMaximum(15);
        HEADER_FLAGS.setPrefix("FLAG");
        HEADER_FLAGS.setNumericAllowed(true);
        HEADER_FLAGS.add(0, "qr");
        HEADER_FLAGS.add(5, "aa");
        HEADER_FLAGS.add(6, "tc");
        HEADER_FLAGS.add(7, "rd");
        HEADER_FLAGS.add(8, "ra");
        HEADER_FLAGS.add(10, "ad");
        HEADER_FLAGS.add(11, "cd");
    }
}

