/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.tagvalue;

import java.util.Set;
import org.apache.james.jdkim.tagvalue.TagValue;
import org.junit.Assert;
import org.junit.Test;

public class TagValueTest {
    @Test
    public void testEmpty() {
        new TagValue("");
    }

    @Test
    public void testValid() {
        new TagValue("v=DKIM1; p=ciao; s=cips;");
        new TagValue("v=");
        new TagValue("v=;");
        Assert.assertTrue((boolean)this.tagValuesEquals("v=", "v=;"));
        Assert.assertTrue((boolean)this.tagValuesEquals("v=", "v= ;"));
        Assert.assertTrue((boolean)this.tagValuesEquals("v=", "v=\r\n ;"));
        Assert.assertFalse((boolean)this.tagValuesEquals("", "v=;"));
    }

    @Test
    public void testInvalidSyntax() {
        try {
            new TagValue("_p=ciao; s=cips; v=DKIM1;");
            Assert.fail((String)"expected invalid tag exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleTag() {
        try {
            new TagValue("s=ciao; s=cips; v=DKIM1;");
            Assert.fail((String)"expected duplicate tag exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidFWS() {
        try {
            new TagValue("\r\n");
            Assert.fail((String)"we only expect WSP/FWS withing a tag-value. No FWS/WSP allowed with no tag");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidFWSSyntax() {
        try {
            new TagValue("p=test \r\n\r\n");
            Assert.fail((String)"expecting WSP after CRLF to handle it as FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new TagValue("p=\r\n\r\n test");
            Assert.fail((String)"expecting WSP after CRLF to handle it as FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidFWSStartSyntax() {
        try {
            new TagValue("\r\np=ciao; s=cips; v=DKIM1;");
            Assert.fail((String)"\\r\\n at the beginning is not valid FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new TagValue("\t\r\np=ciao; s=cips; v=DKIM1;");
            Assert.fail((String)"\\t\\r\\n at the beginning is not valid FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidFWSEndSyntax() {
        try {
            new TagValue("p\r\n=ciao; s=cips; v=DKIM1;");
            Assert.fail((String)"\\r\\n at the end is not valid FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new TagValue("p \r\n=ciao; s=cips; v=DKIM1;");
            Assert.fail((String)"\\r\\n at the end is not valid FWS");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testValidFWSTags() {
        Assert.assertTrue((boolean)this.tagValuesEquals("\r\n\tp=ciao; s=cips; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
        Assert.assertTrue((boolean)this.tagValuesEquals("p\r\n =ciao; s=cips; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
        Assert.assertTrue((boolean)this.tagValuesEquals("p\r\n = \r\n\tciao; s=cips; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
        Assert.assertTrue((boolean)this.tagValuesEquals("p\r\n = ciao; s=cips\r\n\t; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
        Assert.assertTrue((boolean)this.tagValuesEquals("p=ciao\r\n\r\n  ; \r\n   s=cips\r\n\t; v=DKIM1;", "p=ciao;s=cips;v=DKIM1;"));
    }

    @Test
    public void testNoTermination() {
        TagValue t = new TagValue("\r\n\tp=ciao; s=cips; v=DKIM1\r\n\t");
        Assert.assertEquals((Object)"DKIM1", (Object)t.getValue("v"));
    }

    @Test
    public void testSingleValue() {
        TagValue t = new TagValue("\r\n\tp  =      hi\t");
        Assert.assertEquals((Object)"hi", (Object)t.getValue("p"));
    }

    @Test
    public void testWSPinValue() {
        TagValue t = new TagValue("\r\n\tp  = \r\n hi \thi hi \t hi\t");
        Assert.assertEquals((Object)"hi \thi hi \t hi", (Object)t.getValue("p"));
    }

    @Test
    public void testFWSinValue() {
        TagValue t = new TagValue("\r\n\tp  = \r\n hi \thi\r\n hi \t hi\t");
        Assert.assertEquals((Object)"hi \thi\r\n hi \t hi", (Object)t.getValue("p"));
    }

    @Test
    public void testNoEqual() {
        try {
            new TagValue("\r\n\tp        hi\t");
            Assert.fail((String)"Expected value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new TagValue("v=DKIM1; pciao; s=cips;");
            Assert.fail((String)"Expected value");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEndingWSP() {
        new TagValue("t=value; ");
    }

    @Test
    public void testTagSetWithEquals() {
        TagValue tv = new TagValue("t=value; v=encoded=40value");
        Set tags = tv.getTags();
        Assert.assertEquals((long)2L, (long)tags.size());
        Assert.assertTrue((boolean)tags.contains("t"));
        Assert.assertTrue((boolean)tags.contains("v"));
    }

    public boolean tagValuesEquals(String t1, String t2) {
        TagValue tv1 = new TagValue(t1);
        TagValue tv2 = new TagValue(t2);
        boolean eq = tv1.equals((Object)tv2);
        if (eq) {
            Assert.assertTrue((tv1.hashCode() == tv2.hashCode() ? 1 : 0) != 0);
        }
        return eq;
    }
}

