/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.Text;

@Description(name="like all", value="test _FUNC_(pattern1, pattern2...) - returns true if test matches all patterns patternN.  Returns NULL if the expression on the left hand side is NULL or if one of the patterns in the list is NULL.")
public class GenericUDFLikeAll
extends GenericUDF {
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes;
    private transient ObjectInspectorConverters.Converter[] converters;
    private transient boolean isConstantNullPatternContain;
    private boolean isAllPatternsConstant = true;
    private final BooleanWritable bw = new BooleanWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The like all operator requires at least one pattern for matching, got " + (arguments.length - 1));
        }
        this.inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[arguments.length];
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        for (int idx = 0; idx < arguments.length; ++idx) {
            this.checkArgPrimitive(arguments, idx);
            this.checkArgGroups(arguments, idx, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
            PrimitiveObjectInspector.PrimitiveCategory inputType = ((PrimitiveObjectInspector)arguments[idx]).getPrimitiveCategory();
            if (arguments[idx] instanceof ConstantObjectInspector && idx != 0) {
                Object constValue = ((ConstantObjectInspector)arguments[idx]).getWritableConstantValue();
                if (!this.isConstantNullPatternContain && constValue == null) {
                    this.isConstantNullPatternContain = true;
                }
            } else if (idx != 0 && this.isAllPatternsConstant) {
                this.isAllPatternsConstant = false;
            }
            this.converters[idx] = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[idx], (ObjectInspector)this.getOutputOI(inputType));
            this.inputTypes[idx] = inputType;
        }
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.bw.set(true);
        if (arguments[0].get() == null || this.isConstantNullPatternContain) {
            return null;
        }
        Text columnValue = (Text)this.converters[0].convert(arguments[0].get());
        Text pattern = new Text();
        UDFLike likeUdf = new UDFLike();
        for (int idx = 1; idx < arguments.length; ++idx) {
            if (arguments[idx].get() == null) {
                return null;
            }
            pattern.set((Text)this.converters[idx].convert(arguments[idx].get()));
            if (likeUdf.evaluate(columnValue, pattern).get() || !this.bw.get()) continue;
            this.bw.set(false);
            if (!this.isAllPatternsConstant) continue;
            return this.bw;
        }
        return this.bw;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("likeall", children);
    }

    private ObjectInspector getOutputOI(PrimitiveObjectInspector.PrimitiveCategory inputType) {
        switch (inputType) {
            case CHAR: 
            case STRING: 
            case VARCHAR: {
                return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
            }
            case VOID: {
                return PrimitiveObjectInspectorFactory.writableVoidObjectInspector;
            }
        }
        return null;
    }
}

