/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice.impl;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.alert.notice.AlertNoticeException;
import org.apache.hertzbeat.alert.notice.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.alert.notice.impl.CommonRobotNotifyResp;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
final class FlyBookAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(FlyBookAlertNotifyHandlerImpl.class);
    private static final String[] TITLE_COLOR = new String[]{"red", "yellow", "orange"};

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        try {
            String notificationContent = JsonUtil.toJson((Object)this.renderContent(noticeTemplate, alert));
            String cardMessage = this.createLarkMessage(receiver.getUserId(), notificationContent, (byte)1);
            String webHookUrl = this.alerterProperties.getFlyBookWebhookUrl() + receiver.getAccessToken();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity flyEntity = new HttpEntity((Object)cardMessage, (MultiValueMap)headers);
            ResponseEntity entity = this.restTemplate.postForEntity(webHookUrl, (Object)flyEntity, CommonRobotNotifyResp.class, new Object[0]);
            if (entity.getStatusCode() == HttpStatus.OK) {
                assert (entity.getBody() != null);
                if (((CommonRobotNotifyResp)entity.getBody()).getCode() != null && ((CommonRobotNotifyResp)entity.getBody()).getCode() != 0) {
                    log.warn("Send feiShu webHook: {} Failed: {}", (Object)webHookUrl, (Object)((CommonRobotNotifyResp)entity.getBody()).getMsg());
                    throw new AlertNoticeException(((CommonRobotNotifyResp)entity.getBody()).getMsg());
                }
            } else {
                log.warn("Send feiShu webHook: {} Failed: {}", (Object)webHookUrl, entity.getBody());
                throw new AlertNoticeException("Http StatusCode " + entity.getStatusCode());
            }
            log.debug("Send feiShu webHook: {} Success", (Object)webHookUrl);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[FeiShu Notify Error] " + e.getMessage());
        }
    }

    private String createLarkMessage(String userId, String notificationContent, byte priority) {
        String larkCardMessage = " {\n \"msg_type\": \"interactive\",\n \"card\":  {\n      \"schema\": \"2.0\",\n      \"config\": {\n          \"update_multi\": true,\n          \"locales\": [\n              \"en_us\",\n              \"zh_cn\"\n          ],\n          \"style\": {\n              \"text_size\": {\n                  \"normal_v2\": {\n                      \"default\": \"normal\",\n                      \"pc\": \"normal\",\n                      \"mobile\": \"heading\"\n                  }\n              }\n          }\n      },\n      \"body\": {\n          \"direction\": \"vertical\",\n          \"padding\": \"12px 12px 12px 12px\",\n          \"elements\": [\n              {\n                  \"tag\": \"markdown\",\n                  \"content\": \"%s\",\n                  \"i18n_content\": {\n                      \"en_us\": \"\"\n                  },\n                  \"text_align\": \"left\",\n                  \"text_size\": \"normal_v2\",\n                  \"margin\": \"0px 0px 0px 0px\"\n              },\n              {\n                  \"tag\": \"hr\",\n                  \"margin\": \"0px 0px 0px 0px\"\n              },\n              {\n                  \"tag\": \"column_set\",\n                  \"horizontal_align\": \"left\",\n                  \"columns\": [\n                      {\n                          \"tag\": \"column\",\n                          \"width\": \"weighted\",\n                          \"elements\": [\n                              {\n                                  \"tag\": \"button\",\n                                  \"text\": {\n                                      \"tag\": \"plain_text\",\n                                      \"content\": \"\u767b\u5165\u63a7\u5236\u53f0\",\n                                      \"i18n_content\": {\n                                          \"en_us\": \"Login In\"\n                                      }\n                                  },\n                                  \"type\": \"default\",\n                                  \"width\": \"default\",\n                                  \"size\": \"medium\",\n                                  \"behaviors\": [\n                                      {\n                                          \"type\": \"open_url\",\n                                          \"default_url\": \"%s\",\n                                          \"pc_url\": \"\",\n                                          \"ios_url\": \"\",\n                                          \"android_url\": \"\"\n                                      }\n                                  ]\n                              }\n                          ],\n                          \"direction\": \"horizontal\",\n                          \"vertical_spacing\": \"8px\",\n                          \"horizontal_align\": \"left\",\n                          \"vertical_align\": \"top\",\n                          \"weight\": 1\n                      }\n                  ],\n                  \"margin\": \"0px 0px 0px 0px\"\n              }\n          ]\n      },\n      \"header\": {\n          \"title\": {\n              \"tag\": \"plain_text\",\n              \"content\": \"HertzBeat \u544a\u8b66\",\n              \"i18n_content\": {\n                  \"en_us\": \"HertzBeat Alarm\"\n              }\n          },\n          \"subtitle\": {\n              \"tag\": \"plain_text\",\n              \"content\": \"\"\n          },\n          \"template\": \"%s\",\n          \"padding\": \"12px 12px 12px 12px\"\n      }\n  }\n}\n";
        Object atUserElement = "";
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            atUserElement = "\\n" + Arrays.stream(userId.split(",")).map(id -> "<at id=" + id + "></at>").collect(Collectors.joining(" "));
        }
        if (notificationContent.startsWith("\"") && notificationContent.endsWith("\"")) {
            notificationContent = StringUtils.removeStart((String)notificationContent, (String)"\"");
            notificationContent = StringUtils.removeEnd((String)notificationContent, (String)"\"");
        }
        return String.format(larkCardMessage, notificationContent.replace("\"", "\\\"") + (String)atUserElement, this.alerterProperties.getConsoleUrl(), TITLE_COLOR[priority]);
    }

    @Override
    public byte type() {
        return 6;
    }
}

