/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.rpc.signal;

import io.greptime.common.SPI;
import io.greptime.common.signal.FileSignal;
import io.greptime.common.signal.FileSignalHelper;
import io.greptime.common.signal.SignalHandler;
import io.greptime.rpc.interceptors.ClientRequestLimitInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(priority=89)
public class RpcLimitSignalHandler
implements SignalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RpcLimitSignalHandler.class);

    public void handle(String signalName) {
        if (FileSignalHelper.ignoreSignal((FileSignal)FileSignal.RpcLimit)) {
            LOG.info("`LIMIT_SWITCH`={}.", (Object)ClientRequestLimitInterceptor.isLimitSwitchOpen());
            return;
        }
        boolean oldValue = ClientRequestLimitInterceptor.resetLimitSwitch();
        LOG.warn("Reset `LIMIT_SWITCH` to {} triggered by signal: {}.", (Object)(!oldValue ? 1 : 0), (Object)signalName);
    }
}

