/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import java.util.Collections;
import java.util.List;
import org.flywaydb.core.extensibility.ConfigurationParameter;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public interface PluginMetadata
extends Plugin {
    default public String getHelpText() {
        StringBuilder result = new StringBuilder();
        String indent = "    ";
        String description = this.getDescription();
        List<ConfigurationParameter> configurationParameters = this.getConfigurationParameters();
        List<ConfigurationParameter> flags = this.getFlags();
        String example = this.getExample();
        String documentationLink = this.getDocumentationLink();
        if (description != null) {
            result.append("Description:\n").append(indent).append(description).append("\n\n");
        }
        int padSize = 0;
        if (configurationParameters != null) {
            padSize = configurationParameters.stream().mapToInt(p -> p.name.length()).max().orElse(0) + 2;
        }
        if (flags != null) {
            padSize = Math.max(padSize, flags.stream().mapToInt(p -> p.name.length()).max().orElse(0) + 2);
        }
        if (configurationParameters != null) {
            result.append("Configuration parameters: (Format: -key=value)\n");
            for (ConfigurationParameter p2 : configurationParameters) {
                result.append(indent).append(StringUtils.rightPad(p2.name.substring("flyway.".length()), padSize, ' ')).append(p2.description);
                if (p2.required) {
                    result.append(" [REQUIRED]");
                }
                result.append("\n");
            }
            result.append("\n");
        }
        if (flags != null) {
            result.append("Flags:\n");
            for (ConfigurationParameter p2 : flags) {
                result.append(indent).append(StringUtils.rightPad(p2.name, padSize, ' ')).append(p2.description);
                if (p2.required) {
                    result.append(" [REQUIRED]");
                }
                result.append("\n");
            }
            result.append("\n");
        }
        if (example != null) {
            result.append("Example:\n").append(indent).append(example).append("\n\n");
        }
        if (documentationLink != null) {
            result.append("Online documentation: ").append(documentationLink).append("\n");
        }
        return result.toString();
    }

    default public String getDescription() {
        return null;
    }

    default public List<ConfigurationParameter> getConfigurationParameters() {
        return null;
    }

    default public List<ConfigurationParameter> getFlags() {
        return null;
    }

    default public String getExample() {
        return null;
    }

    default public List<Pair<String, String>> getUsage() {
        return Collections.emptyList();
    }

    default public String getDocumentationLink() {
        return null;
    }
}

