/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.failover;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.client.AMRMClientUtils;
import org.apache.hadoop.yarn.client.RMFailoverProxyProvider;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.federation.failover.FederationRMFailoverProxyProvider;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class FederationProxyProviderUtil {
    public static final Logger LOG = LoggerFactory.getLogger(FederationProxyProviderUtil.class);

    private FederationProxyProviderUtil() {
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static <T> T createRMProxy(Configuration configuration, Class<T> protocol, SubClusterId subClusterId, UserGroupInformation user) throws IOException {
        return FederationProxyProviderUtil.createRMProxy(configuration, protocol, subClusterId, user, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static <T> T createRMProxy(Configuration configuration, Class<T> protocol, SubClusterId subClusterId, UserGroupInformation user, Token<? extends TokenIdentifier> token) throws IOException {
        YarnConfiguration config = new YarnConfiguration(configuration);
        FederationProxyProviderUtil.updateConfForFederation((Configuration)config, subClusterId.getId());
        return (T)AMRMClientUtils.createRMProxy((Configuration)config, protocol, (UserGroupInformation)user, token);
    }

    public static void updateConfForFederation(Configuration conf, String subClusterId) {
        conf.set("yarn.resourcemanager.cluster-id", subClusterId);
        conf.setBoolean("yarn.federation.enabled", true);
        conf.setClass("yarn.client.failover-proxy-provider", FederationRMFailoverProxyProvider.class, RMFailoverProxyProvider.class);
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            conf.setBoolean("yarn.federation.failover.enabled", true);
            conf.setBoolean("yarn.resourcemanager.ha.enabled", false);
        }
    }
}

