/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.net.InetAddresses;
import org.apache.hadoop.util.MachineList;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMachineList {
    private static String IP_LIST = "10.119.103.110,10.119.103.112,10.119.103.114";
    private static String IP_LIST_SPACES = " 10.119.103.110 , 10.119.103.112,10.119.103.114 ,10.119.103.110, ";
    private static String CIDR_LIST = "10.222.0.0/16,10.241.23.0/24";
    private static String CIDR_LIST1 = "10.222.0.0/16";
    private static String CIDR_LIST2 = "10.241.23.0/24";
    private static String INVALID_CIDR = "10.241/24";
    private static String IP_CIDR_LIST = "10.222.0.0/16,10.119.103.110,10.119.103.112,10.119.103.114,10.241.23.0/24";
    private static String HOST_LIST = "host1,host4";
    private static String HOSTNAME_IP_CIDR_LIST = "host1,10.222.0.0/16,10.119.103.110,10.119.103.112,10.119.103.114,10.241.23.0/24,host4,";

    @Test
    public void testWildCard() {
        MachineList ml = new MachineList("*", (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertTrue((boolean)ml.includes("1.2.3.4"));
    }

    @Test
    public void testIPList() {
        MachineList ml = new MachineList(IP_LIST, (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testIPListSpaces() {
        MachineList ml = new MachineList(IP_LIST_SPACES, (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testStaticIPHostNameList() throws UnknownHostException {
        TestAddressFactory addressFactory = new TestAddressFactory();
        addressFactory.put("1.2.3.1", "host1");
        addressFactory.put("1.2.3.4", "host4");
        MachineList ml = new MachineList(StringUtils.getTrimmedStringCollection((String)HOST_LIST), (MachineList.InetAddressFactory)addressFactory);
        Assert.assertTrue((boolean)ml.includes("1.2.3.4"));
        Assert.assertFalse((boolean)ml.includes("1.2.3.5"));
    }

    @Test
    public void testHostNames() throws UnknownHostException {
        TestAddressFactory addressFactory = new TestAddressFactory();
        addressFactory.put("1.2.3.1", "host1");
        addressFactory.put("1.2.3.4", "host4", "differentname");
        addressFactory.put("1.2.3.5", "host5");
        MachineList ml = new MachineList(StringUtils.getTrimmedStringCollection((String)HOST_LIST), (MachineList.InetAddressFactory)addressFactory);
        Assert.assertTrue((boolean)ml.includes("1.2.3.4"));
        Assert.assertFalse((boolean)ml.includes("1.2.3.5"));
    }

    @Test
    public void testHostNamesReverserIpMatch() throws UnknownHostException {
        TestAddressFactory addressFactory = new TestAddressFactory();
        addressFactory.put("1.2.3.1", "host1");
        addressFactory.put("1.2.3.4", "host4");
        addressFactory.put("1.2.3.5", "host5");
        MachineList ml = new MachineList(StringUtils.getTrimmedStringCollection((String)HOST_LIST), (MachineList.InetAddressFactory)addressFactory);
        Assert.assertTrue((boolean)ml.includes("1.2.3.4"));
        Assert.assertFalse((boolean)ml.includes("1.2.3.5"));
    }

    @Test
    public void testCIDRs() {
        MachineList ml = new MachineList(CIDR_LIST, (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertFalse((boolean)ml.includes("10.221.255.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.1"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.254"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.255"));
        Assert.assertFalse((boolean)ml.includes("10.223.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.1"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.254"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.255"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullIpAddress() {
        MachineList ml = new MachineList(CIDR_LIST, (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertFalse((boolean)ml.includes((String)null));
        Assert.assertFalse((boolean)ml.includes((InetAddress)null));
    }

    @Test
    public void testCIDRWith16bitmask() {
        MachineList ml = new MachineList(CIDR_LIST1, (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertFalse((boolean)ml.includes("10.221.255.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.1"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.254"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.255"));
        Assert.assertFalse((boolean)ml.includes("10.223.0.0"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testCIDRWith8BitMask() {
        MachineList ml = new MachineList(CIDR_LIST2, (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertFalse((boolean)ml.includes("10.241.22.255"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.1"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.254"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.255"));
        Assert.assertFalse((boolean)ml.includes("10.241.24.0"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
    }

    @Test
    public void testInvalidCIDR() {
        try {
            MachineList ml = new MachineList(INVALID_CIDR, (MachineList.InetAddressFactory)new TestAddressFactory());
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException ml) {
        }
        catch (Throwable t) {
            Assert.fail((String)"Expected only IllegalArgumentException");
        }
    }

    @Test
    public void testIPandCIDRs() {
        MachineList ml = new MachineList(IP_CIDR_LIST, (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
        Assert.assertFalse((boolean)ml.includes("10.221.255.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.255"));
        Assert.assertFalse((boolean)ml.includes("10.223.0.0"));
        Assert.assertFalse((boolean)ml.includes("10.241.22.255"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.255"));
        Assert.assertFalse((boolean)ml.includes("10.241.24.0"));
    }

    @Test
    public void testHostNameIPandCIDRs() {
        MachineList ml = new MachineList(HOSTNAME_IP_CIDR_LIST, (MachineList.InetAddressFactory)new TestAddressFactory());
        Assert.assertTrue((boolean)ml.includes("10.119.103.112"));
        Assert.assertFalse((boolean)ml.includes("10.119.103.111"));
        Assert.assertFalse((boolean)ml.includes("10.221.255.255"));
        Assert.assertTrue((boolean)ml.includes("10.222.0.0"));
        Assert.assertTrue((boolean)ml.includes("10.222.255.255"));
        Assert.assertFalse((boolean)ml.includes("10.223.0.0"));
        Assert.assertFalse((boolean)ml.includes("10.241.22.255"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.0"));
        Assert.assertTrue((boolean)ml.includes("10.241.23.255"));
        Assert.assertFalse((boolean)ml.includes("10.241.24.0"));
    }

    @Test
    public void testGetCollection() {
        MachineList ml = new MachineList(HOSTNAME_IP_CIDR_LIST, (MachineList.InetAddressFactory)new TestAddressFactory());
        Collection col = ml.getCollection();
        Assert.assertEquals((long)7L, (long)ml.getCollection().size());
        for (String item : StringUtils.getTrimmedStringCollection((String)HOSTNAME_IP_CIDR_LIST)) {
            Assert.assertTrue((boolean)col.contains(item));
        }
    }

    class TestAddressFactory
    extends MachineList.InetAddressFactory {
        private Map<String, InetAddress> cache = new HashMap<String, InetAddress>();

        TestAddressFactory() {
        }

        InetAddress put(String ip) throws UnknownHostException {
            return this.put(ip, ip);
        }

        InetAddress put(String ip, String ... hosts) throws UnknownHostException {
            InetAddress addr = InetAddress.getByName(ip);
            for (String host : hosts) {
                addr = InetAddress.getByAddress(host, addr.getAddress());
                this.cache.put(host, addr);
                this.cache.put(ip, addr);
            }
            return addr;
        }

        public InetAddress getByName(String host) throws UnknownHostException {
            InetAddress addr = this.cache.get(host);
            if (addr == null) {
                if (!InetAddresses.isInetAddress((String)host)) {
                    throw new UnknownHostException(host);
                }
                addr = InetAddress.getByName(host);
                addr = InetAddress.getByAddress(host, addr.getAddress());
            }
            return addr;
        }
    }
}

