/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ResourceOverCommitException;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class NoOverCommitPolicy
implements SharingPolicy {
    @Override
    public void validate(Plan plan, ReservationAllocation reservation) throws PlanningException {
        RLESparseResourceAllocation available = plan.getAvailableResourceOverTime(reservation.getUser(), reservation.getReservationId(), reservation.getStartTime(), reservation.getEndTime(), reservation.getPeriodicity());
        try {
            RLESparseResourceAllocation ask = reservation.getResourcesOverTime(reservation.getStartTime(), reservation.getEndTime());
            RLESparseResourceAllocation.merge(plan.getResourceCalculator(), plan.getTotalCapacity(), available, ask, RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, reservation.getStartTime(), reservation.getEndTime());
        }
        catch (PlanningException p) {
            throw new ResourceOverCommitException("Resources at time " + reservation.getStartTime() + " would be overcommitted by accepting reservation: " + reservation.getReservationId(), p);
        }
    }

    @Override
    public long getValidWindow() {
        return 0L;
    }

    @Override
    public void init(String planQueuePath, ReservationSchedulerConfiguration conf) {
    }

    @Override
    public RLESparseResourceAllocation availableResources(RLESparseResourceAllocation available, Plan plan, String user, ReservationId oldId, long start, long end) throws PlanningException {
        return available;
    }
}

