/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.ArrayList;
import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.PhysicalStore;

public final class RowsSupplier<N extends Number>
implements Access2D<N>,
ElementsSupplier<N> {
    private final int myColumnsCount;
    private final PhysicalStore.Factory<N, ?> myFactory;
    private final List<Access1D<N>> myRows = new ArrayList<Access1D<N>>();

    RowsSupplier(PhysicalStore.Factory<N, ?> factory, int numberOfColumns) {
        this.myColumnsCount = numberOfColumns;
        this.myFactory = factory;
    }

    public PhysicalStore<N> addRow() {
        PhysicalStore retVal = (PhysicalStore)this.myFactory.makeZero(1L, this.myColumnsCount);
        if (this.myRows.add(retVal)) {
            return retVal;
        }
        return null;
    }

    public Access1D<N> addRow(Access1D<N> row) {
        if (row.count() != (long)this.myColumnsCount) {
            throw new IllegalArgumentException("All rows must have the same legth!");
        }
        if (this.myRows.add(row)) {
            return row;
        }
        return null;
    }

    @Override
    public long countColumns() {
        return this.myColumnsCount;
    }

    @Override
    public long countRows() {
        return this.myRows.size();
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.myRows.get((int)row).doubleValue(col);
    }

    @Override
    public N get(long row, long col) {
        return this.myRows.get((int)row).get(col);
    }

    public Access1D<N> getRow(int index) {
        return this.myRows.get(index);
    }

    @Override
    public PhysicalStore.Factory<N, ?> physical() {
        return this.myFactory;
    }

    public Access1D<N> removeRow(int index) {
        return this.myRows.remove(index);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        int tmpLimit = this.myRows.size();
        for (int i = 0; i < tmpLimit; ++i) {
            receiver.fillRow((long)i, this.myRows.get(i));
        }
    }
}

